/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.floatview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.bihe0832.android.lib.aaf.tools.AAFException;
import com.bihe0832.android.lib.floatview.IconView;
import com.bihe0832.android.lib.floatview.R;
import com.bihe0832.android.lib.ui.image.BitmapUtil;
import com.bihe0832.android.lib.utils.os.DisplayUtil;

public class IconViewWithRedDot
extends IconView {
    public ImageView mView;
    private ImageView mRedViewL;
    private ImageView mRedViewR;
    private View layout;
    private boolean mHasRed = false;
    private Bitmap mIconCache;

    @Override
    public ImageView getIconView() {
        return this.mView;
    }

    @Override
    public View getIconLayout() {
        return this.layout;
    }

    @Override
    public int getLayoutId() {
        return R.layout.com_bihe0832_icon_view;
    }

    @Override
    public void initView() {
        this.layout = this.findViewById(R.id.com_bihe0832_lib_icon_layout);
        this.mView = (ImageView)this.findViewById(R.id.com_bihe0832_lib_icon_icon);
        this.mRedViewL = (ImageView)this.findViewById(R.id.com_bihe0832_lib_icon_icon_redl);
        this.mRedViewR = (ImageView)this.findViewById(R.id.com_bihe0832_lib_icon_icon_redr);
    }

    public IconViewWithRedDot(Context context) throws AAFException {
        super(context);
    }

    public IconViewWithRedDot(Context context, Drawable drawable) throws AAFException {
        this(context);
        this.mView.setImageDrawable(drawable);
    }

    public void setHasNew(boolean isNew) {
        this.mHasRed = isNew;
    }

    public void setIconImage(final String iconURL) {
        if (TextUtils.isEmpty((CharSequence)iconURL)) {
            Log.e((String)"ICON_VIEW", (String)"Icon URL is Empty can`t update");
            return;
        }
        if (null != this.mIconCache) {
            this.mView.setImageBitmap(this.mIconCache);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)iconURL)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Log.e((String)"ICON_VIEW", (String)("Icon URL is \uff1a" + iconURL));
                        Bitmap bitmap = BitmapUtil.getRemoteBitmap((String)iconURL, (int)DisplayUtil.dip2px((Context)IconViewWithRedDot.this.getContext(), (float)40.0f), (int)DisplayUtil.dip2px((Context)IconViewWithRedDot.this.getContext(), (float)40.0f));
                        if (bitmap != null) {
                            IconViewWithRedDot.this.mIconCache = bitmap;
                            IconViewWithRedDot.this.mView.post(new Runnable(){

                                @Override
                                public void run() {
                                    IconViewWithRedDot.this.mView.setImageBitmap(IconViewWithRedDot.this.mIconCache);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void updateReddot() {
        boolean iconLocationIsLeft = this.iconLocationIsLeft();
        Log.d((String)"ICON_VIEW", (String)("Icon updateViewRed point " + this.mHasRed));
        if (this.mHasRed) {
            if (iconLocationIsLeft) {
                this.mRedViewL.setVisibility(4);
                this.mRedViewR.setVisibility(0);
            } else {
                this.mRedViewL.setVisibility(0);
                this.mRedViewR.setVisibility(4);
            }
        } else {
            this.mRedViewR.setVisibility(4);
            this.mRedViewL.setVisibility(4);
        }
    }

    @Override
    public void onClick(View v) {
        this.mHasRed = false;
        this.updateReddot();
        super.onClick(v);
    }

    @Override
    public void showIcon() {
        super.showIcon();
        this.updateReddot();
    }

    @Override
    protected void updateViewPosition() {
        super.updateViewPosition();
        this.updateReddot();
    }
}

