/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.file.provider;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.file.R;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class ZixieFileProvider
extends FileProvider {
    @NotNull
    public static final Uri getZixieFileProvider(@NotNull Context context, @NotNull File file) {
        Uri uri = null;
        try {
            uri = FileProvider.getUriForFile((Context)context, (String)ZixieFileProvider.getZixieFileProviderName(context), (File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                uri = FileProvider.getUriForFile((Context)context, (String)ZixieFileProvider.getAAFInnerFileProviderName(context), (File)file);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return uri;
    }

    public static final String getZixieFileProviderName(@NotNull Context context) {
        return context.getPackageName() + ".bihe0832";
    }

    static final String getAAFInnerFileProviderName(@NotNull Context context) {
        return context.getPackageName() + ".aaf.inner";
    }

    public static void setFileUriForIntent(Context context, Intent intent, File file, String mine_type) {
        if (BuildUtils.INSTANCE.getSDK_INT() < 24) {
            intent.setDataAndType(Uri.fromFile((File)file), mine_type);
        } else {
            Uri fileProvider = ZixieFileProvider.getZixieFileProvider(context, file);
            intent.setDataAndType(ZixieFileProvider.getZixieFileProvider(context, file), mine_type);
            intent.addFlags(1);
            intent.addFlags(2);
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)fileProvider);
        }
    }

    @NotNull
    public static final String getZixieFilePath(@NotNull Context context) {
        return ZixieFileProvider.getZixieFilePath(context, context.getResources().getString(R.string.lib_bihe0832_file_folder));
    }

    @NotNull
    public static final String getZixieFilePath(@NotNull Context context, String filePath) {
        String subPath = filePath;
        if (TextUtils.isEmpty((CharSequence)subPath)) {
            subPath = context.getResources().getString(R.string.lib_bihe0832_file_folder);
        }
        String absoluteFilePath = "";
        File tempFile = context.getExternalFilesDir(subPath);
        absoluteFilePath = tempFile == null ? context.getFilesDir().getAbsolutePath() + File.separator + subPath : tempFile.getAbsolutePath();
        FileUtils.INSTANCE.checkAndCreateFolder(absoluteFilePath);
        if (!absoluteFilePath.endsWith(File.separator)) {
            return absoluteFilePath + File.separator;
        }
        return absoluteFilePath;
    }

    public static File uriToFile(Context context, Uri uri) {
        if (uri == null) {
            ZLog.e((String)"uri is null");
            return null;
        }
        File file = null;
        if (uri.getScheme() != null) {
            ContentResolver resolver;
            Cursor cursor;
            ZLog.e((String)("uri.getScheme()\uff1a" + uri.getScheme()));
            if (uri.getScheme().equals("file") && uri.getPath() != null) {
                file = new File(uri.getPath());
            } else if (uri.getScheme().equals("content") && (cursor = (resolver = context.getContentResolver()).query(uri, null, null, null, null)) != null && cursor.moveToFirst()) {
                String fileName = cursor.getString(cursor.getColumnIndex("_display_name"));
                try {
                    InputStream inputStream = resolver.openInputStream(uri);
                    if (context.getExternalCacheDir() != null) {
                        File cache = new File(context.getExternalCacheDir(), fileName);
                        FileOutputStream fileOutputStream = new FileOutputStream(cache);
                        if (inputStream != null) {
                            int read;
                            byte[] len = new byte[Math.min(inputStream.available(), 0x100000)];
                            while ((read = inputStream.read(len)) != -1) {
                                fileOutputStream.write(len, 0, read);
                            }
                            file = cache;
                            fileOutputStream.close();
                            inputStream.close();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }
}

