/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.file.mimetype;

import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.bihe0832.android.lib.file.FileUtils;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;

public class MimeTypes {
    private ConcurrentHashMap<String, String> mMimeTypes = new ConcurrentHashMap();
    private static MimeTypes instance = null;

    public static MimeTypes getInstance() {
        if (instance == null) {
            instance = new MimeTypes();
        }
        return instance;
    }

    public void put(String type, String extension) {
        extension = extension.toLowerCase();
        this.mMimeTypes.put(type, extension);
    }

    public String getMimeType(String filename) {
        String extension = FileUtils.INSTANCE.getExtensionName(filename);
        if (TextUtils.isEmpty((CharSequence)extension)) {
            return "*/*";
        }
        String mimetype = this.mMimeTypes.get(extension.toLowerCase());
        if (mimetype == null) {
            String webkitMimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension.substring(1));
            if (webkitMimeType != null) {
                this.put(extension, webkitMimeType);
                return webkitMimeType;
            }
            return "*/*";
        }
        return mimetype;
    }

    public boolean isTextFile(File file) {
        return !file.isDirectory() && MimeTypes.isMimeText(this.getMimeType(file.getPath()));
    }

    public static boolean isMimeText(String mime) {
        return mime.startsWith("text");
    }

    public boolean isImageFile(File file) {
        return !file.isDirectory() && MimeTypes.isImageFile(file.getName());
    }

    public static boolean isImageFile(String file) {
        String ext = file.substring(file.lastIndexOf(".") + 1);
        if (MimeTypes.getInstance().getMimeType(file).startsWith("image/")) {
            return true;
        }
        return ext.equalsIgnoreCase("png") || ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg") || ext.equalsIgnoreCase("gif") || ext.equalsIgnoreCase("tiff") || ext.equalsIgnoreCase("tif");
    }

    public boolean isAPKFile(File file) {
        return !file.isDirectory() && MimeTypes.isAPKFile(file.getName());
    }

    public static boolean isAPKFile(String file) {
        if ((file = file.substring(file.lastIndexOf("/") + 1)).indexOf(".") > -1) {
            file = file.substring(file.lastIndexOf(".") + 1);
        }
        return file.equalsIgnoreCase("apk");
    }

    public boolean isArchive(File file) {
        return FileUtils.INSTANCE.getExtensionName(file.getName()).equalsIgnoreCase("zip");
    }

    public boolean isVideoFile(File file) {
        return !file.isDirectory() && MimeTypes.isVideoFile(file.getName());
    }

    public static boolean isVideoFile(String path) {
        if (MimeTypes.getInstance().getMimeType(path).startsWith("video/")) {
            return true;
        }
        String ext = path.substring(path.lastIndexOf(".") + 1);
        return ext.equalsIgnoreCase("mp4") || ext.equalsIgnoreCase("3gp") || ext.equalsIgnoreCase("avi") || ext.equalsIgnoreCase("webm") || ext.equalsIgnoreCase("m4v");
    }

    public boolean isAudioFile(File file) {
        return !file.isDirectory() && MimeTypes.isAudioFile(file.getName());
    }

    public static boolean isAudioFile(String path) {
        if (MimeTypes.getInstance().getMimeType(path).startsWith("audio/")) {
            return true;
        }
        String ext = path.substring(path.lastIndexOf(".") + 1);
        return ext.equalsIgnoreCase("mp3") || ext.equalsIgnoreCase("wma") || ext.equalsIgnoreCase("flac") || ext.equalsIgnoreCase("wav") || ext.equalsIgnoreCase("aac") || ext.equalsIgnoreCase("ogg") || ext.equalsIgnoreCase("m4a");
    }
}

