/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.file;

import android.content.Context;
import android.content.res.Resources;
import android.os.StatFs;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import com.bihe0832.android.lib.file.action.FileAction;
import com.bihe0832.android.lib.file.content.FileContent;
import com.bihe0832.android.lib.file.content.FileName;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.encrypt.MD5;
import com.bihe0832.android.lib.utils.encrypt.MessageDigestUtils;
import com.bihe0832.android.lib.utils.encrypt.SHA256;
import java.io.File;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fJ&\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\rJ.\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\rJ\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fJ.\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\rJ\u0010\u0010\u001a\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ \u0010\u001d\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000fJ \u0010 \u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000fJ\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&J\u001e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\rJ\u0016\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020&2\u0006\u0010'\u001a\u00020&J\u001e\u0010)\u001a\u00020\r2\u0006\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020&2\u0006\u0010(\u001a\u00020\rJ\u000e\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020&J\u000e\u0010/\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0016\u00100\u001a\u00020$2\u0006\u0010.\u001a\u00020&2\u0006\u00101\u001a\u00020\u0013J\u0016\u00102\u001a\u00020$2\u0006\u0010.\u001a\u00020&2\u0006\u00101\u001a\u00020\u0013J\u0016\u00103\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u000fJ\u000e\u00104\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000fJ\u0010\u00105\u001a\u00020\u000f2\b\u00106\u001a\u0004\u0018\u00010\u000fJ\u0012\u00107\u001a\u0004\u0018\u0001082\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fJ\u0018\u00109\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020\u000fJ\u0010\u00109\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fJ\u0018\u00109\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010<\u001a\u00020\rJ\u0018\u00109\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010;\u001a\u00020\u000fJ \u00109\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010;\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020\rJ\u000e\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u0013J\u000e\u0010?\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0010\u0010@\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010A\u001a\u00020\u000f2\b\u00106\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010B\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ\u000e\u0010C\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010D\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0011\u001a\u00020\u000fJ\u000e\u0010E\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fJ\u000e\u0010F\u001a\u00020\r2\u0006\u0010G\u001a\u00020\u000fJ\u001e\u0010H\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010I\u001a\u00020\u000fJ\u001e\u0010J\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010I\u001a\u00020\u000fJ\u001e\u0010K\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010L\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/bihe0832/android/lib/file/FileUtils;", "", "()V", "ILLEGAL_FILENAME_CHARS", "", "getILLEGAL_FILENAME_CHARS", "()[C", "SPACE_GB", "", "SPACE_KB", "SPACE_MB", "SPACE_TB", "checkAndCreateFolder", "", "path", "", "checkFileExist", "filePath", "fileLength", "", "fileMD5", "ignoreWhenMd5IsBad", "fileSHA256", "checkFileExistByMessageDigest", "digestValue", "digestType", "checkStoragePermissions", "context", "Landroid/content/Context;", "copyAssetsFileToPath", "fromFileName", "targetPath", "copyAssetsFolderToFolder", "fromAssetPath", "targetFolder", "copyDirectory", "", "src", "Ljava/io/File;", "dest", "isMove", "copyFile", "source", "srcFile", "dstFile", "deleteDirectory", "dir", "deleteFile", "deleteOld", "duration", "deleteOldAsync", "getAssetFileContent", "getDirectoryAvailableSpace", "getExtensionName", "filename", "getFileBytes", "", "getFileContent", "Ljava/io/InputStream;", "encoding", "isGzip", "getFileLength", "sizeInBytes", "getFileMD5", "getFileName", "getFileNameWithoutEx", "getFileSHA256", "getFolderPathWithSeparator", "isAssetsExists", "isBinaryFile", "isInvalidFilename", "fileName", "openFile", "fileType", "sendFile", "writeToFile", "data", "append", "LibFile_release"})
public final class FileUtils {
    @NotNull
    private static final char[] ILLEGAL_FILENAME_CHARS;
    public static final double SPACE_KB = 1024.0;
    public static final double SPACE_MB = 1048576.0;
    public static final double SPACE_GB = 1.073741824E9;
    public static final double SPACE_TB = 1.099511627776E12;
    public static final FileUtils INSTANCE;

    @NotNull
    public final char[] getILLEGAL_FILENAME_CHARS() {
        return ILLEGAL_FILENAME_CHARS;
    }

    public final boolean checkStoragePermissions(@Nullable Context context) {
        Context context2 = context;
        if (context2 != null) {
            Context context3 = context2;
            boolean bl = false;
            boolean bl2 = false;
            Context it = context3;
            boolean bl3 = false;
            return ContextCompat.checkSelfPermission((Context)it, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0;
        }
        return false;
    }

    public final long getDirectoryAvailableSpace(@NotNull String filePath) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        try {
            StatFs mStatFs = new StatFs(filePath);
            long blockSize = mStatFs.getBlockSizeLong();
            long availableBlocks = mStatFs.getAvailableBlocksLong();
            l = availableBlocks * blockSize;
        }
        catch (Exception e) {
            e.printStackTrace();
            l = 0L;
        }
        return l;
    }

    public final boolean checkAndCreateFolder(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        try {
            File file = new File(path);
            boolean bl = false;
            boolean bl2 = false;
            File it = file;
            boolean bl3 = false;
            return !it.exists() ? it.mkdirs() : true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @NotNull
    public final String getFolderPathWithSeparator(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        try {
            boolean result = this.checkAndCreateFolder(path);
            if (!result) {
                ZLog.e((String)("file " + path + " is bad !!!"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String string2 = File.separator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.separator");
        return StringsKt.endsWith$default((String)path, (String)string2, (boolean)false, (int)2, null) ? path : path + File.separator;
    }

    public final boolean checkFileExist(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        return this.checkFileExist(filePath, "");
    }

    public final boolean checkFileExist(@NotNull String filePath, @NotNull String fileMD5) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)fileMD5, (String)"fileMD5");
        return this.checkFileExist(filePath, 0L, fileMD5, true);
    }

    public final boolean checkFileExist(@NotNull String filePath, long fileLength, @NotNull String fileMD5, boolean ignoreWhenMd5IsBad) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)fileMD5, (String)"fileMD5");
        return this.checkFileExist(filePath, fileLength, fileMD5, "", ignoreWhenMd5IsBad);
    }

    public final boolean checkFileExist(@NotNull String filePath, long fileLength, @NotNull String fileMD5, @NotNull String fileSHA256, boolean ignoreWhenMd5IsBad) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)fileMD5, (String)"fileMD5");
        Intrinsics.checkParameterIsNotNull((Object)fileSHA256, (String)"fileSHA256");
        return TextUtils.isEmpty((CharSequence)fileMD5) ? this.checkFileExistByMessageDigest(filePath, fileLength, fileSHA256, "SHA-256", ignoreWhenMd5IsBad) : this.checkFileExistByMessageDigest(filePath, fileLength, fileMD5, "MD5", ignoreWhenMd5IsBad);
    }

    public final boolean checkFileExistByMessageDigest(@NotNull String filePath, long fileLength, @NotNull String digestValue, @NotNull String digestType, boolean ignoreWhenMd5IsBad) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)digestValue, (String)"digestValue");
        Intrinsics.checkParameterIsNotNull((Object)digestType, (String)"digestType");
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            bl = false;
        } else {
            File file = new File(filePath);
            if (!file.exists() || !file.isFile()) {
                bl = false;
            } else {
                boolean hasMD5;
                boolean bl2 = hasMD5 = !TextUtils.isEmpty((CharSequence)digestValue);
                bl = fileLength > 0L ? (fileLength == file.length() ? (hasMD5 ? StringsKt.equals((String)MessageDigestUtils.getFileDigestData((String)filePath, (String)digestType), (String)digestValue, (boolean)true) : true) : false) : (hasMD5 ? StringsKt.equals((String)MessageDigestUtils.getFileDigestData((String)filePath, (String)digestType), (String)digestValue, (boolean)true) : ignoreWhenMd5IsBad);
            }
        }
        return bl;
    }

    @NotNull
    public final String getFileLength(long sizeInBytes) {
        Object object = new DecimalFormat();
        boolean bl = false;
        boolean bl2 = false;
        DecimalFormat $this$apply = object;
        boolean bl3 = false;
        $this$apply.setMaximumFractionDigits(2);
        NumberFormat nf = (NumberFormat)object;
        try {
            object = (double)sizeInBytes < 1024.0 ? nf.format(sizeInBytes) + " B" : ((double)sizeInBytes < 1048576.0 ? nf.format((double)sizeInBytes / 1024.0) + " KB" : ((double)sizeInBytes < 1.073741824E9 ? nf.format((double)sizeInBytes / 1048576.0) + " MB" : ((double)sizeInBytes < 1.099511627776E12 ? nf.format((double)sizeInBytes / 1.073741824E9) + " GB" : nf.format((double)sizeInBytes / 1.099511627776E12) + " TB")));
        }
        catch (Exception e) {
            object = sizeInBytes + " B";
        }
        return object;
    }

    public final boolean openFile(@NotNull Context context, @NotNull String filePath, @NotNull String fileType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        return FileAction.INSTANCE.openFile(context, filePath, fileType);
    }

    public final boolean sendFile(@NotNull Context context, @NotNull String filePath, @NotNull String fileType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        return FileAction.INSTANCE.sendFile(context, filePath, fileType);
    }

    public final void deleteOldAsync(@NotNull File dir, long duration) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        FileAction.INSTANCE.deleteOldAsync(dir, duration);
    }

    public final void deleteOld(@NotNull File dir, long duration) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        FileAction.INSTANCE.deleteOld(dir, duration);
    }

    public final boolean deleteDirectory(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        return FileAction.INSTANCE.deleteDirectory(dir);
    }

    public final boolean deleteFile(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        return FileAction.INSTANCE.deleteFile(filePath);
    }

    public final boolean copyFile(@NotNull File source, @NotNull File dest) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        return FileAction.INSTANCE.copyFile(source, dest);
    }

    public final boolean copyFile(@NotNull File srcFile, @NotNull File dstFile, boolean isMove) {
        Intrinsics.checkParameterIsNotNull((Object)srcFile, (String)"srcFile");
        Intrinsics.checkParameterIsNotNull((Object)dstFile, (String)"dstFile");
        return FileAction.INSTANCE.copyFile(srcFile, dstFile, isMove);
    }

    public final void copyDirectory(@NotNull File src, @NotNull File dest) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        FileAction.INSTANCE.copyDirectory(src, dest, false);
    }

    public final void copyDirectory(@NotNull File src, @NotNull File dest, boolean isMove) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        FileAction.INSTANCE.copyDirectory(src, dest, isMove);
    }

    public final boolean copyAssetsFileToPath(@Nullable Context context, @NotNull String fromFileName, @NotNull String targetPath) {
        Intrinsics.checkParameterIsNotNull((Object)fromFileName, (String)"fromFileName");
        Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
        return FileAction.INSTANCE.copyAssetsFileToPath(context, fromFileName, targetPath);
    }

    public final boolean copyAssetsFolderToFolder(@Nullable Context context, @NotNull String fromAssetPath, @NotNull String targetFolder) {
        Intrinsics.checkParameterIsNotNull((Object)fromAssetPath, (String)"fromAssetPath");
        Intrinsics.checkParameterIsNotNull((Object)targetFolder, (String)"targetFolder");
        return FileAction.INSTANCE.copyAssetsFolderToFolder(context, fromAssetPath, targetFolder);
    }

    public final boolean isAssetsExists(@Nullable Context context, @NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        return FileAction.INSTANCE.isAssetsExists(context, filePath);
    }

    @NotNull
    public final String getFileMD5(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        String string2 = MD5.getFileMD5((String)filePath);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"MD5.getFileMD5(filePath)");
        return string2;
    }

    @NotNull
    public final String getFileSHA256(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        String string2 = SHA256.getFileSHA256((String)filePath);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SHA256.getFileSHA256(filePath)");
        return string2;
    }

    @NotNull
    public final String getExtensionName(@Nullable String filename) {
        return FileName.INSTANCE.getExtensionName(filename);
    }

    @NotNull
    public final String getFileName(@Nullable String filePath) {
        return FileName.INSTANCE.getFileName(filePath);
    }

    @NotNull
    public final String getFileNameWithoutEx(@Nullable String filename) {
        return FileName.INSTANCE.getFileNameWithoutEx(filename);
    }

    public final boolean isInvalidFilename(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return FileName.INSTANCE.isInvalidFilename(fileName);
    }

    @NotNull
    public final String getFileContent(@Nullable String filePath) {
        return FileContent.INSTANCE.getFileContent(filePath, "UTF-8");
    }

    @NotNull
    public final String getFileContent(@Nullable String filePath, boolean isGzip) {
        return FileContent.INSTANCE.getFileContent(filePath, "UTF-8", isGzip);
    }

    @NotNull
    public final String getFileContent(@Nullable String filePath, @NotNull String encoding) {
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        return FileContent.INSTANCE.getFileContent(filePath, encoding, false);
    }

    @NotNull
    public final String getFileContent(@Nullable InputStream filePath, @NotNull String encoding) {
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        return FileContent.INSTANCE.getFileContent(filePath, encoding);
    }

    @NotNull
    public final String getAssetFileContent(@NotNull Context context, @NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return FileContent.INSTANCE.getFileContent(resources.getAssets().open(filePath), "UTF-8");
    }

    @NotNull
    public final String getFileContent(@Nullable String filePath, @NotNull String encoding, boolean isGzip) {
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        return FileContent.INSTANCE.getFileContent(filePath, encoding, isGzip);
    }

    @Nullable
    public final byte[] getFileBytes(@Nullable String filePath) {
        return FileContent.INSTANCE.getFileBytes(filePath);
    }

    public final boolean isBinaryFile(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        return FileContent.INSTANCE.isBinaryFile(filePath);
    }

    public final void writeToFile(@NotNull String filePath, @NotNull String data, boolean append) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        FileContent.INSTANCE.writeToFile(filePath, data, append);
    }

    private FileUtils() {
    }

    static {
        FileUtils fileUtils;
        INSTANCE = fileUtils = new FileUtils();
        ILLEGAL_FILENAME_CHARS = new char[]{(char)34, (char)60, (char)62, (char)124, (char)0, (char)1, (char)2, (char)3, (char)4, (char)5, (char)6, (char)7, (char)8, (char)9, (char)10, (char)11, (char)12, (char)13, (char)14, (char)15, (char)16, (char)17, (char)18, (char)19, (char)20, (char)21, (char)22, (char)23, (char)24, (char)25, (char)26, (char)27, (char)28, (char)29, (char)30, (char)31, (char)58, (char)42, (char)63, (char)92, (char)47};
    }
}

