/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.file.select;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.bihe0832.android.lib.file.select.FileViewHolder;
import com.bihe0832.android.lib.file.select.R;
import com.bihe0832.android.lib.immersion.AppCompatActivityImmersiveExtKt;
import com.bihe0832.android.lib.permission.PermissionManager;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.bihe0832.android.lib.ui.toast.ToastUtil;
import com.bihe0832.android.lib.ui.touchregion.ViewExtForTouchRegionKt;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import me.yokeyword.fragmentation.SupportActivity;
import org.jetbrains.annotations.NotNull;

public class FileActivity
extends SupportActivity {
    final int HANDLER_MSG_SELECTED = 1;
    ImageView btn_back;
    ImageView btn_close;
    TextView tv_path;
    ListView lv;
    FileAdapter mAdapter;
    File mFile = null;
    File[] mFileArr = null;
    String mSelectedPath = null;
    FileSearchTask mFSTask = null;
    Handler mHandler;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.com_bihe0832_activity_file);
        AppCompatActivityImmersiveExtKt.enableActivityImmersive((AppCompatActivity)this, (int)ContextCompat.getColor((Context)this, (int)R.color.colorPrimaryDark), (int)ContextCompat.getColor((Context)this, (int)R.color.navigationBarColor));
        this.init();
        this.initHandler();
        this.initView();
        this.initViewAction();
        String path = this.getIntent().getStringExtra("url");
        if (!TextUtils.isEmpty((CharSequence)path)) {
            this.mFSTask.execute(new Object[]{new File(path).getParentFile()});
        } else {
            this.mFSTask.execute(new Object[]{Environment.getExternalStorageDirectory()});
        }
    }

    private void init() {
        PermissionManager.INSTANCE.addPermissionDesc((HashMap)new HashMap<String, String>(){
            {
                this.put("android.permission.WRITE_EXTERNAL_STORAGE", "\u5b58\u50a8\u5361");
            }
        });
        PermissionManager.INSTANCE.addPermissionScene((HashMap)new HashMap<String, String>(){
            {
                this.put("android.permission.WRITE_EXTERNAL_STORAGE", "\u9009\u62e9\u6587\u4ef6");
            }
        });
        String[] permission2 = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
        PermissionManager.INSTANCE.checkPermission((Context)this, "FileSelect", false, new PermissionManager.OnPermissionResult(){

            public void onSuccess() {
            }

            public void onUserCancel(String scene, String permission2) {
                ToastUtil.showShort((Context)FileActivity.this, (String)"\u672a\u83b7\u5f97\u8bbf\u95ee\u5b58\u50a8\u5361\u6743\u9650\uff0c\u8bf7\u91cd\u8bd5");
                FileActivity.this.setResult(0);
                FileActivity.this.finish();
            }

            public void onUserDeny(String scene, String permission2) {
                ToastUtil.showShort((Context)FileActivity.this, (String)"\u672a\u83b7\u5f97\u8bbf\u95ee\u5b58\u50a8\u5361\u6743\u9650\uff0c\u8bf7\u91cd\u8bd5");
                FileActivity.this.setResult(0);
                FileActivity.this.finish();
            }

            public void onFailed(@NotNull String msg) {
                ToastUtil.showShort((Context)FileActivity.this, (String)"\u672a\u83b7\u5f97\u8bbf\u95ee\u5b58\u50a8\u5361\u6743\u9650\uff0c\u8bf7\u91cd\u8bd5");
                FileActivity.this.setResult(0);
                FileActivity.this.finish();
            }
        }, permission2);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mFSTask != null) {
            this.mFSTask.cancel(true);
            this.mFSTask = null;
        }
        this.mFileArr = null;
        this.mFile = null;
    }

    private void initView() {
        this.btn_back = (ImageView)this.findViewById(R.id.activity_file_btn_back);
        this.btn_close = (ImageView)this.findViewById(R.id.activity_file_btn_close);
        this.tv_path = (TextView)this.findViewById(R.id.activity_file_tv_title);
        this.lv = (ListView)this.findViewById(R.id.activity_file_lv);
        this.mAdapter = new FileAdapter();
        this.lv.setAdapter((ListAdapter)this.mAdapter);
        this.mFSTask = new FileSearchTask();
    }

    private void initViewAction() {
        this.btn_back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FileActivity.this.onBackAction();
            }
        });
        ViewExtForTouchRegionKt.expandTouchRegionWithdp((View)this.btn_back, (float)30.0f);
        this.btn_close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FileActivity.this.stopSearch();
                if (FileActivity.this.mSelectedPath == null) {
                    FileActivity.this.setResult(0);
                } else {
                    Intent data = new Intent();
                    data.putExtra("url", FileActivity.this.mSelectedPath);
                    FileActivity.this.setResult(-1, data);
                }
                FileActivity.this.finish();
            }
        });
        ViewExtForTouchRegionKt.expandTouchRegionWithdp((View)this.btn_close, (float)30.0f);
        this.lv.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (FileActivity.this.mFileArr != null) {
                    File mTempFile = FileActivity.this.mFileArr[position];
                    if (mTempFile.isDirectory()) {
                        FileActivity.this.stopSearch();
                        if (mTempFile.list() == null || mTempFile.listFiles() == null || mTempFile.listFiles().length < 1) {
                            ToastUtil.showShort((Context)FileActivity.this, (String)"\u5f53\u524d\u4e3a\u7a7a\u76ee\u5f55");
                        } else {
                            FileActivity.this.mFSTask = new FileSearchTask();
                            FileActivity.this.mFSTask.execute(new Object[]{mTempFile});
                        }
                    } else {
                        FileActivity.this.mSelectedPath = FileActivity.this.mSelectedPath == null ? mTempFile.getAbsolutePath() : null;
                        FileActivity.this.mAdapter.notifyDataSetChanged();
                    }
                }
            }
        });
    }

    private void stopSearch() {
        if (this.mFSTask != null) {
            this.mFSTask.cancel(true);
        }
    }

    private void initHandler() {
        this.mHandler = new Handler(ThreadManager.getInstance().getLooper(0)){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        if (FileActivity.this.mSelectedPath != null) {
                            FileActivity.this.btn_close.setBackgroundResource(R.mipmap.ic_done);
                            FileActivity.this.btn_back.setVisibility(8);
                            FileActivity.this.tv_path.setText((CharSequence)("\u5df2\u9009\u62e9\uff1a" + FileActivity.this.mSelectedPath));
                            break;
                        }
                        FileActivity.this.btn_close.setBackgroundResource(R.mipmap.close);
                        FileActivity.this.btn_back.setVisibility(0);
                        FileActivity.this.tv_path.setText((CharSequence)FileActivity.this.mFile.getAbsolutePath());
                    }
                }
            }
        };
    }

    private void loadFile(File file) {
        File mTempFile = file;
        if (mTempFile != null && mTempFile.exists() && mTempFile.isDirectory()) {
            this.mFile = mTempFile;
            this.mFileArr = mTempFile.listFiles();
            if (this.mFileArr != null && this.mFileArr.length > 0) {
                Arrays.sort(this.mFileArr, new Comparator<File>(){

                    @Override
                    public int compare(File lhs, File rhs) {
                        boolean f1 = lhs.isDirectory();
                        boolean f2 = rhs.isDirectory();
                        int result = f1 && !f2 ? -1 : (!f1 && f2 ? 1 : lhs.getName().toUpperCase().compareTo(rhs.getName().toUpperCase()));
                        return result;
                    }
                });
            }
        }
    }

    private void onBackAction() {
        if (this.mSelectedPath != null) {
            this.mSelectedPath = null;
            this.mAdapter.notifyDataSetChanged();
            return;
        }
        if (this.mFileArr != null) {
            File mTempFile = this.mFile.getParentFile();
            if (mTempFile != null) {
                this.mFSTask = new FileSearchTask();
                this.mFSTask.execute(new Object[]{mTempFile});
            } else {
                ToastUtil.showShort((Context)this, (String)"\u5df2\u7ecf\u662f\u6700\u4e0a\u5c42\u76ee\u5f55\u4e86");
            }
        }
    }

    public void onBackPressedSupport() {
        this.onBackAction();
    }

    class FileAdapter
    extends BaseAdapter {
        CompoundButton.OnCheckedChangeListener MyCheckListener = new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (buttonView.getTag() != null) {
                    int position = (Integer)buttonView.getTag();
                    File mTempFile = FileActivity.this.mFileArr[position];
                    if (isChecked) {
                        FileActivity.this.mSelectedPath = mTempFile.getAbsolutePath();
                    } else if (FileActivity.this.mSelectedPath != null && mTempFile.getAbsolutePath().equals(FileActivity.this.mSelectedPath)) {
                        FileActivity.this.mSelectedPath = null;
                    }
                    FileActivity.this.mHandler.sendEmptyMessage(1);
                    FileAdapter.this.notifyDataSetChanged();
                }
            }
        };

        FileAdapter() {
        }

        public int getCount() {
            return FileActivity.this.mFileArr == null ? 0 : FileActivity.this.mFileArr.length;
        }

        public Object getItem(int position) {
            return FileActivity.this.mFileArr[position];
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            FileViewHolder mHolder;
            if (convertView == null) {
                mHolder = new FileViewHolder();
                convertView = LayoutInflater.from((Context)FileActivity.this).inflate(R.layout.com_bihe0832_card_item_file, null);
                mHolder.iv_icon = (ImageView)convertView.findViewById(R.id.item_file_iv_icon);
                mHolder.tv_fileName = (TextView)convertView.findViewById(R.id.item_file_tv_filename);
                mHolder.cb_selected = (CheckBox)convertView.findViewById(R.id.item_file_cb_selected);
                mHolder.cb_selected.setOnCheckedChangeListener(this.MyCheckListener);
                convertView.setTag((Object)mHolder);
            } else {
                mHolder = (FileViewHolder)convertView.getTag();
            }
            File mTempFile = FileActivity.this.mFileArr[position];
            if (mTempFile.isDirectory()) {
                mHolder.iv_icon.setImageResource(R.mipmap.ic_folder);
                mHolder.iv_icon.setColorFilter(FileActivity.this.getResources().getColor(R.color.primary_text));
            } else {
                mHolder.iv_icon.setImageResource(R.mipmap.ic_file);
                mHolder.iv_icon.setColorFilter(FileActivity.this.getResources().getColor(R.color.primary_text));
            }
            mHolder.cb_selected.setVisibility(0);
            mHolder.cb_selected.setTag((Object)position);
            if (FileActivity.this.mSelectedPath != null && mTempFile.getAbsolutePath().equals(FileActivity.this.mSelectedPath)) {
                mHolder.cb_selected.setChecked(true);
            } else {
                mHolder.cb_selected.setChecked(false);
            }
            mHolder.tv_fileName.setText((CharSequence)mTempFile.getName());
            return convertView;
        }
    }

    private class FileSearchTask
    extends AsyncTask {
        private FileSearchTask() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            FileActivity.this.mFileArr = null;
            FileActivity.this.mAdapter.notifyDataSetChanged();
        }

        protected Object doInBackground(Object[] params) {
            try {
                FileActivity.this.loadFile((File)params[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                FileActivity.this.mFileArr = null;
            }
            return FileActivity.this.mFileArr;
        }

        protected void onPostExecute(Object o) {
            super.onPostExecute(o);
            FileActivity.this.tv_path.setText((CharSequence)FileActivity.this.mFile.getAbsolutePath());
            FileActivity.this.mAdapter.notifyDataSetChanged();
        }

        protected void onCancelled() {
            super.onCancelled();
            FileActivity.this.mAdapter.notifyDataSetChanged();
        }
    }
}

