/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.utils.encrypt;

import android.util.Base64;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.encrypt.HexUtils;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtils {
    private static byte[] ivBytes = new byte[]{77, 78, 65, 64, 50, 48, 49, 55, 71, 79, 72, 69, 65, 68, 33, 33};
    public static byte[] DEFAULT_KEY = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 53, 55, 56};

    private static byte[] doAESEncrypt(byte[] content, byte[] key, byte[] ivParaBytes, int mode) {
        try {
            if (content == null || key == null) {
                return null;
            }
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec iv = new IvParameterSpec(ivParaBytes);
            cipher.init(mode, (Key)keySpec, iv);
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception e) {
            ZLog.e((String)"AESUtil", (String)("AES \u5bc6\u6587\u5904\u7406\u5f02\u5e38\uff1a" + e));
            return null;
        }
    }

    public static byte[] doAESEncryptWithDefaultIV(byte[] content, byte[] keyBytes, int mode) {
        try {
            return AESUtils.doAESEncrypt(content, keyBytes, ivBytes, mode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] doAESEncryptWithoutIV(byte[] content, byte[] keyBytes, int mode) {
        try {
            byte[] ivSpec = new byte[16];
            return AESUtils.doAESEncrypt(content, keyBytes, ivSpec, mode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encrypt(byte[] keyBytes, byte[] content) {
        return AESUtils.doAESEncryptWithDefaultIV(content, keyBytes, 1);
    }

    public static byte[] encrypt(byte[] keyBytes, String content) {
        byte[] cByte = null;
        try {
            cByte = content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return AESUtils.encrypt(keyBytes, cByte);
    }

    public static byte[] encryptWithoutIV(byte[] keyBytes, byte[] content) {
        return AESUtils.doAESEncryptWithoutIV(content, keyBytes, 1);
    }

    public static byte[] decrypt(byte[] keyBytes, byte[] content) {
        return AESUtils.doAESEncryptWithDefaultIV(content, keyBytes, 2);
    }

    public static byte[] decryptWithoutIV(byte[] keyBytes, byte[] content) {
        return AESUtils.doAESEncryptWithoutIV(content, keyBytes, 2);
    }

    public static String encryptToHex(byte[] data, byte[] key, byte[] ivParaBytes) {
        try {
            byte[] result = AESUtils.doAESEncrypt(data, key, ivParaBytes, 1);
            return HexUtils.bytes2HexStr(result);
        }
        catch (Exception e) {
            ZLog.e((String)"AESUtil", (String)("AES \u5bc6\u6587\u5904\u7406\u5f02\u5e38\uff1a" + e));
            return null;
        }
    }

    public static byte[] decryptHex(String data, byte[] key, byte[] ivParaBytes) {
        try {
            return AESUtils.doAESEncrypt(HexUtils.hexStr2Bytes(data), key, ivParaBytes, 2);
        }
        catch (Exception e) {
            ZLog.e((String)"AESUtil", (String)("AES \u5bc6\u6587\u5904\u7406\u5f02\u5e38\uff1a" + e));
            return null;
        }
    }

    public static String encryptToBase64(byte[] data, byte[] key, byte[] ivParaBytes, int base64Flag) {
        try {
            byte[] result = AESUtils.doAESEncrypt(data, key, ivParaBytes, 1);
            return new String(Base64.encode((byte[])result, (int)base64Flag), "UTF-8");
        }
        catch (Exception e) {
            ZLog.e((String)"AESUtil", (String)("AES \u5bc6\u6587\u5904\u7406\u5f02\u5e38\uff1a" + e));
            return null;
        }
    }

    public static String encryptToBase64(byte[] data, byte[] key, byte[] ivParaBytes) {
        return AESUtils.encryptToBase64(data, key, ivParaBytes, 8);
    }

    public static byte[] decryptBase64(String data, byte[] key, byte[] ivParaBytes) {
        return AESUtils.decryptBase64(data, key, ivParaBytes, 8);
    }

    public static byte[] decryptBase64(String data, byte[] key, byte[] ivParaBytes, int base64Flag) {
        try {
            return AESUtils.doAESEncrypt(Base64.decode((String)data, (int)base64Flag), key, ivParaBytes, 2);
        }
        catch (Exception e) {
            ZLog.e((String)"AESUtil", (String)("AES \u5bc6\u6587\u5904\u7406\u5f02\u5e38\uff1a" + e));
            return null;
        }
    }
}

