/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.utils.encrypt;

import android.text.TextUtils;
import com.bihe0832.android.lib.utils.encrypt.HexUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5 {
    private static final int BUFFER_SIZE = 2048;

    public static String getMd5(String string) {
        try {
            return MD5.getMd5(string.getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getMd5(byte[] bytes) {
        try {
            byte[] hash = MessageDigest.getInstance("MD5").digest(bytes);
            StringBuilder hex = new StringBuilder(hash.length * 2);
            for (byte b : hash) {
                if ((b & 0xFF) < 16) {
                    hex.append("0");
                }
                hex.append(Integer.toHexString(b & 0xFF));
            }
            return hex.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getFileMD5(String fileName) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            return "";
        }
        return MD5.getFileMD5(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5(File sourceFile) {
        String ret = "";
        if (null != sourceFile && sourceFile.exists() && sourceFile.length() > 0L) {
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(sourceFile));
                ret = MD5.getInputStreamMd5(is);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return ret;
    }

    public static String getInputStreamMd5(InputStream is) {
        try {
            int len;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[2048];
            int readSize = 0;
            while ((len = is.read(buffer, 0, buffer.length)) != -1) {
                if (len <= 0) continue;
                md5.update(buffer, 0, len);
                readSize += len;
            }
            if (readSize == 0) {
                return "";
            }
            byte[] md5Bytes = md5.digest();
            return HexUtils.bytes2HexStr(md5Bytes);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getFileMD5(String fileName, long start, long end) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            return "";
        }
        return MD5.getFileMD5(new File(fileName), start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5(File sourceFile, long start, long end) {
        String ret = "";
        if (null != sourceFile && sourceFile.exists() && sourceFile.length() > 0L) {
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(sourceFile));
                ret = MD5.getInputStreamMd5(is, start, end);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return ret;
    }

    public static String getInputStreamMd5(InputStream bis, long start, long end) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            if (start < 1L) {
                start = 1L;
            }
            bis.skip(start - 1L);
            if (end < start) {
                return "";
            }
            int total = (int)(end - start + 1L);
            byte[] buffer = new byte[2048];
            for (int i = 0; i < total / 2048; ++i) {
                bis.read(buffer, 0, 2048);
                md5.update(buffer, 0, 2048);
            }
            if (total % 2048 > 0) {
                bis.read(buffer, 0, total % 2048);
                md5.update(buffer, 0, total % 2048);
            }
            byte[] md5Bytes = md5.digest();
            return HexUtils.bytes2HexStr(md5Bytes);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

