/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.menu;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import com.bihe0832.android.lib.ui.dialog.R;
import com.bihe0832.android.lib.ui.menu.PopMenuAdapter;
import com.bihe0832.android.lib.ui.menu.PopMenuItem;
import com.bihe0832.android.lib.utils.os.DisplayUtil;
import java.util.ArrayList;
import java.util.List;

public class PopMenu {
    private ListView mMenuList;
    private PopMenuAdapter mMenuAdapter;
    private PopupWindow mMenuWindow;
    private List<PopMenuItem> mActions = new ArrayList<PopMenuItem>();
    protected Activity mActivity;
    private View mAttachView;
    private int mWidth = -2;
    private Drawable mBackgroundDrawable = null;
    private int gravity = 5;
    private int xOffset = 0;
    private int yOffset = 0;
    private float bgAlpha = 1.0f;

    public PopMenu(Activity activity, View attach) {
        this.mActivity = activity;
        this.mAttachView = attach;
        this.mWidth = (int)this.mActivity.getResources().getDimension(R.dimen.com_bihe0832_pop_menu_width);
        this.mBackgroundDrawable = this.mActivity.getResources().getDrawable(R.drawable.com_bihe0832_pop_menu_bg);
        this.xOffset = DisplayUtil.dip2px((Context)activity, (float)-8.0f);
        this.yOffset = DisplayUtil.dip2px((Context)activity, (float)8.0f);
    }

    public void setMenuItemList(List<PopMenuItem> menuActions) {
        this.mActions.clear();
        this.mActions.addAll(menuActions);
    }

    public void setBackgroundDrawable(Drawable backgroundDrawable) {
        this.mBackgroundDrawable = backgroundDrawable;
    }

    public void setWidth(int width) {
        this.mWidth = width;
    }

    public void setGravity(int gravity) {
        this.gravity = gravity;
    }

    public void setBgAlpha(float bgAlpha) {
        this.bgAlpha = bgAlpha;
    }

    public void setOffset(int xOffset, int yOffset) {
        this.setXOffset(xOffset);
        this.setYOffset(yOffset);
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public boolean isShowing() {
        if (this.mMenuWindow == null) {
            return false;
        }
        return this.mMenuWindow.isShowing();
    }

    public void hide() {
        this.mMenuWindow.dismiss();
    }

    public void show() {
        if (this.mActions == null || this.mActions.size() == 0) {
            return;
        }
        this.mMenuWindow = new PopupWindow((Context)this.mActivity);
        this.mMenuAdapter = new PopMenuAdapter((Context)this.mActivity);
        this.mMenuAdapter.setDataSource(this.mActions);
        View menuView = LayoutInflater.from((Context)this.mAttachView.getContext()).inflate(R.layout.com_bihe0832_pop_menu_layout, null);
        this.mMenuWindow.setContentView(menuView);
        this.mMenuList = (ListView)menuView.findViewById(R.id.conversation_pop_list);
        this.mMenuList.setAdapter((ListAdapter)this.mMenuAdapter);
        this.mMenuList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                PopMenuItem action = (PopMenuItem)PopMenu.this.mMenuAdapter.getItem(position);
                if (action != null && action.getActionClickListener() != null) {
                    action.getActionClickListener().onClick(view);
                }
            }
        });
        this.mMenuWindow.setWidth(this.mWidth);
        this.mMenuWindow.setHeight(-2);
        this.mMenuWindow.setBackgroundDrawable(this.mBackgroundDrawable);
        this.mMenuWindow.setFocusable(true);
        this.mMenuWindow.setTouchable(true);
        this.mMenuWindow.setOutsideTouchable(true);
        this.backgroundAlpha(0.5f);
        this.mMenuWindow.showAsDropDown(this.mAttachView, this.xOffset, this.yOffset, this.gravity);
        this.mMenuWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                PopMenu.this.backgroundAlpha(PopMenu.this.bgAlpha);
            }
        });
    }

    private void backgroundAlpha(float bgAlpha) {
        WindowManager.LayoutParams lp = this.mActivity.getWindow().getAttributes();
        lp.alpha = bgAlpha;
        this.mActivity.getWindow().setAttributes(lp);
        this.mActivity.getWindow().addFlags(2);
    }
}

