/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.network.ping;

import android.content.Context;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.network.IpUtils;
import com.bihe0832.android.lib.network.WifiUtil;
import com.bihe0832.android.lib.network.ping.PingListener;
import com.bihe0832.android.lib.network.ping.PingResult;
import com.bihe0832.android.lib.network.ping.PingThreshold;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PingUtil {
    private static final Pattern TRACE_IP_PATTERN = Pattern.compile("(?<=From )(?:[0-9]{1,3}\\.){3}[0-9]{1,3}");
    private static final Pattern DST_HOST_IP_PATTERN = Pattern.compile("(?<=from ).*(?=: icmp_seq=1 ttl=)");
    private static final int MAXHOP = 30;
    private static PingListener listener = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ping(String ipStr, int count) {
        int avgDelay;
        block43: {
            int n;
            if (ipStr == null || ipStr.length() <= 0 || ipStr.equals("0.0.0.0")) {
                return -3;
            }
            avgDelay = 1000;
            Process pingProcess = null;
            InputStream inputStream = null;
            BufferedReader bufferReader = null;
            try {
                int exitValue;
                pingProcess = Runtime.getRuntime().exec("/system/bin/ping -c " + count + " -W 1 -i 0.2 " + ipStr);
                inputStream = pingProcess.getInputStream();
                bufferReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                String pingResult = null;
                String line = null;
                while ((line = bufferReader.readLine()) != null) {
                    pingResult = line;
                }
                ZLog.d((String)("ping, pingResult:" + pingResult));
                if (pingResult != null) {
                    String pingStats = pingResult.substring(pingResult.indexOf(61) + 1, pingResult.indexOf("ms")).trim();
                    int avgStartIndex = pingStats.indexOf(47) + 1;
                    int avgEndIndex = pingStats.indexOf(47, avgStartIndex);
                    String avgDelayStr = pingStats.substring(avgStartIndex, avgEndIndex).trim();
                    double avgDelayD = Double.valueOf(avgDelayStr);
                    avgDelay = (int)avgDelayD + 1;
                }
                if ((exitValue = pingProcess.waitFor()) == 1) {
                    ZLog.d((String)"ping, ping IP failed.");
                    n = -2;
                    return n;
                }
                if (exitValue == 0) break block43;
                ZLog.d((String)("ping, ping IP not support, exitValue:" + exitValue));
                n = -1;
            }
            catch (Exception e) {
                int n2 = -2;
                return n2;
            }
            finally {
                if (pingProcess != null) {
                    try {
                        pingProcess.destroy();
                    }
                    catch (Exception exception) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (bufferReader != null) {
                    try {
                        bufferReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return n;
        }
        return avgDelay;
    }

    private static String getTraceIpWithHop(String host, int hop) {
        if (host == null || host.length() <= 0 || host.equals("0.0.0.0")) {
            return "";
        }
        StringBuilder hopStr = new StringBuilder();
        String command = "ping -w 1 -c 1 -t " + hop + " " + host;
        Process process = null;
        BufferedReader reader = null;
        try {
            String line;
            process = Runtime.getRuntime().exec(command);
            reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                hopStr.append(line);
            }
            reader.close();
            int exitValue = process.waitFor();
            if (exitValue != 0 && exitValue != 1 && exitValue != 2) {
                return "";
            }
            Matcher m = TRACE_IP_PATTERN.matcher(hopStr.toString());
            if (m.find()) {
                String hopIp = m.group();
                ZLog.d((String)("getTraceIp: " + hopIp + ", with hop:" + hop));
                return hopIp;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private static String getRouterNextHop(String host) {
        return PingUtil.getTraceIpWithHop(host, 2);
    }

    public static int pingRouterNextHop(String host, int count) {
        try {
            String hopIp = PingUtil.getRouterNextHop(host);
            if (hopIp == null || hopIp.length() <= 0) {
                return -5;
            }
            if (!IpUtils.isInnerIP(hopIp)) {
                return -6;
            }
            return PingUtil.ping(hopIp, count);
        }
        catch (Throwable t) {
            return -7;
        }
    }

    public static String getWlanNextHop(String host) {
        int curHop = 2;
        try {
            while (curHop <= 30) {
                String hopIp;
                if (!IpUtils.isInnerIP(hopIp = PingUtil.getTraceIpWithHop(host, curHop++))) {
                    return hopIp;
                }
                Matcher matcherDstHost = DST_HOST_IP_PATTERN.matcher(hopIp);
                if (!matcherDstHost.find()) continue;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static int pingWlanNextHop(String host, int count) {
        try {
            String hopIp = PingUtil.getWlanNextHop(host);
            ZLog.d((String)("pingWlanNextHop: ip:" + hopIp));
            if (hopIp == null || hopIp.length() <= 0) {
                return -5;
            }
            return PingUtil.ping(hopIp, count);
        }
        catch (Throwable t) {
            return -7;
        }
    }

    public static boolean isPingRouter(Context context, String pingIp) {
        return pingIp != null && pingIp.equals(WifiUtil.getGatewayIp(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ping(String hostname, int count, IPingResultListener pingResultListener) {
        Process pingProcess = null;
        BufferedReader resultReader = null;
        try {
            String line;
            pingProcess = Runtime.getRuntime().exec("ping -c " + count + " -W 1 -i 0.2 " + hostname);
            resultReader = new BufferedReader(new InputStreamReader(pingProcess.getInputStream(), "GBK"));
            while ((line = resultReader.readLine()) != null) {
                pingResultListener.onPingResult(line);
            }
            int exitVal = pingProcess.waitFor();
            if (exitVal == 1) {
                ZLog.d((String)"ping gateway failed.");
            } else if (exitVal != 0) {
                ZLog.d((String)("ping gateway not support " + exitVal));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (resultReader != null) {
                try {
                    resultReader.close();
                }
                catch (Exception exception) {}
            }
            if (pingProcess != null) {
                try {
                    pingProcess.destroy();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getPingTime(String address, int count, float interval) {
        int pingTime = 1000;
        Process mPingProcess = null;
        String result = null;
        InputStream instream = null;
        BufferedReader bufferReader = null;
        try {
            int mExitValue;
            int i;
            String readline;
            mPingProcess = Runtime.getRuntime().exec("/system/bin/ping -c " + count + " -W 1 -i " + interval + " " + address);
            instream = mPingProcess.getInputStream();
            bufferReader = new BufferedReader(new InputStreamReader(instream, "GBK"));
            while ((readline = bufferReader.readLine()) != null) {
                result = readline;
            }
            if (result != null) {
                String mTimes = result.substring(result.indexOf("=") + 1, result.indexOf("ms")).trim();
                i = mTimes.indexOf("/") + 1;
                int j = mTimes.indexOf(47, i);
                String mPingTime = mTimes.substring(i, j).trim();
                float ft = Float.valueOf(mPingTime).floatValue();
                pingTime = (int)ft + 1;
            }
            if ((mExitValue = mPingProcess.waitFor()) == 1) {
                ZLog.d((String)"ping gateway failed.");
                i = -2;
                return i;
            }
            if (mExitValue != 0) {
                ZLog.d((String)("ping gateway not support " + mExitValue));
                i = -1;
                return i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = -2;
            return n;
        }
        finally {
            if (mPingProcess != null) {
                try {
                    mPingProcess.destroy();
                }
                catch (Exception e1) {
                    ZLog.e((String)("ping instream, error:" + e1.getMessage()));
                }
            }
        }
        return pingTime;
    }

    public static PingResult getPingResult(PingListener pl, String address, int count, int interval, boolean isPingRouter, PingThreshold pingThreshold) {
        listener = pl;
        PingResult res = new PingResult(address, -2, 0.0, 0.0, isPingRouter);
        int i = 0;
        long lastTime = System.currentTimeMillis();
        long curTime = 0L;
        int pingTime = -2;
        while (i < count) {
            curTime = System.currentTimeMillis();
            if (curTime - lastTime < (long)interval) continue;
            ++i;
            lastTime = curTime;
            if (listener == null) break;
            pingTime = PingUtil.getPingTime(address, 1, 0.2f);
            ++res.numSent;
            if (-1 == pingTime) {
                ZLog.d((String)"ping gateway not support.");
                res.avgDelay = -1;
            } else if (-2 == pingTime) {
                ZLog.d((String)"ping gateway failed.");
                res.avgDelay = -2;
            } else {
                ++res.numReceived;
                res.sumDelay += pingTime;
                if (pingTime >= pingThreshold.getHighDelay()) {
                    ++res.numHighDelay;
                }
                if (pingTime > res.max) {
                    res.max = pingTime;
                }
                if (pingTime < res.min) {
                    res.min = pingTime;
                }
            }
            if (listener == null) continue;
            listener.onPingTime(address, pingTime);
        }
        res.freshStat(pingThreshold);
        if (listener != null) {
            listener.onPingResult(res);
        }
        return res;
    }

    public static void endPing() {
        listener = null;
    }

    public static int compareDouble(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.compareTo(b2);
    }

    public static int pingGateway(Context context, int count) {
        try {
            String gatewayStr = WifiUtil.getGatewayIp(context);
            int avgDelay = PingUtil.ping(gatewayStr, count);
            ZLog.d((String)("pingGateway, ip: " + gatewayStr + ", avgDelay: " + avgDelay));
            return avgDelay;
        }
        catch (Exception e) {
            ZLog.d((String)("pingGateway, exception:" + e.getMessage()));
            return -2;
        }
    }

    public static interface IPingResultListener {
        public void onPingResult(String var1);
    }
}

