/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.device;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;

public class DeviceIDUtils {
    private static String sAndroidId = "";
    public static final int BUFFERED_SIZE = 1024;
    public static final String MARSHMALLOW_MAC = "02:00:00:00:00:00";

    public static String getImei(Context context) {
        String imei = "UNKNOWN";
        try {
            TelephonyManager telephonyManager;
            if (context != null && (telephonyManager = (TelephonyManager)context.getApplicationContext().getSystemService("phone")) != null) {
                imei = telephonyManager.getDeviceId();
            }
        }
        catch (SecurityException telephonyManager) {
        }
        catch (Throwable e) {
            ZLog.d((String)("getImei error:" + e.getMessage()));
        }
        return imei;
    }

    public static String getIMEIList(Context context) {
        try {
            TelephonyManager teleMgr = (TelephonyManager)context.getSystemService("phone");
            int cnt = teleMgr.getPhoneCount();
            String imei = "";
            for (int i = 0; i < cnt; ++i) {
                ZLog.i((String)("TelephonyManager id " + i + " of " + cnt + " is  getImei(): " + teleMgr.getImei(i)));
                imei = i == 0 ? teleMgr.getImei(i) : imei + "_" + teleMgr.getImei(i);
            }
            ZLog.i((String)("imei =  " + imei));
            return imei;
        }
        catch (Exception e) {
            return "";
        }
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getMacAddress(Context context) {
        String mac = "";
        try {
            WifiManager wm = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            if (wm != null) {
                WifiInfo wifiInfo = wm.getConnectionInfo();
                if (wifiInfo != null) {
                    mac = wifiInfo.getMacAddress();
                }
                if (MARSHMALLOW_MAC.equals(mac)) {
                    String result = null;
                    result = DeviceIDUtils.getMacAddressByInterface();
                    if (result != null && result.length() > 0) {
                        return result.toUpperCase();
                    }
                    result = DeviceIDUtils.getAddressMacByFile();
                    if (result != null && result.length() > 0) {
                        return result.toUpperCase();
                    }
                } else if (mac != null) {
                    return mac.toUpperCase();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAddressMacByFile() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream("/sys/class/net/wlan0/address")), 1024);
            String line = reader.readLine();
            if (line != null) {
                String string = line.toUpperCase();
                return string;
            }
        }
        catch (Exception e) {
            ZLog.d((String)("getMacAddress ByFile failed, exception:" + e.getMessage()));
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        return "";
    }

    private static String getMacAddressByInterface() {
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] macBytes = new byte[]{};
                if (BuildUtils.INSTANCE.getSDK_INT() >= 9) {
                    macBytes = nif.getHardwareAddress();
                }
                if (macBytes == null || macBytes.length <= 0) {
                    return "";
                }
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02X:", b));
                }
                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString();
            }
        }
        catch (Exception e) {
            ZLog.d((String)("getMacAddress ByInterface failed, exception:" + e.getMessage()));
        }
        return "";
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getAndroidId(Context context) {
        if (sAndroidId == null || sAndroidId.length() <= 0) {
            String androidId = "0";
            try {
                if (context != null) {
                    androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                    ZLog.d((String)("getDeviceId androidId:" + androidId + ",hashCode:" + androidId.hashCode()));
                }
            }
            catch (Exception e) {
                ZLog.d((String)("getDeviceId error:" + e.getMessage()));
            }
            sAndroidId = androidId;
        }
        return sAndroidId;
    }

    public static String getCId(Context mContext) {
        String internalSdcardId = "0";
        try {
            String cidString = "/sys/block/mmcblk0/device/cid";
            FileReader localOb = new FileReader(cidString);
            if (localOb != null) {
                internalSdcardId = new BufferedReader(localOb).readLine();
            }
        }
        catch (Exception e) {
            ZLog.d((String)("getDeviceId error:" + e.getMessage()));
        }
        return internalSdcardId;
    }

    public static boolean isValidMac(String macStr) {
        if (macStr == null || macStr.length() <= 0) {
            return false;
        }
        String macAddressRule = "([A-Fa-f0-9]{2}[-,:]){5}[A-Fa-f0-9]{2}";
        if (macStr.matches(macAddressRule)) {
            return true;
        }
        ZLog.i((String)"it is not a valid MAC address!!!");
        return false;
    }
}

