/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.view;

import android.content.Context;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bihe0832.android.lib.ui.view.R;
import com.bihe0832.android.lib.utils.os.BuildUtils;

public class BottomBarTab
extends FrameLayout {
    private ImageView mIcon;
    private TextView mTvTitle;
    private Context mContext;
    private int mTabPosition = -1;
    private ImageView mUnreadDot;

    public BottomBarTab(Context context, @DrawableRes int icon, CharSequence title) {
        this(context, null, icon, title);
    }

    public BottomBarTab(Context context, AttributeSet attrs, int icon, CharSequence title) {
        this(context, attrs, 0, icon, title);
    }

    public BottomBarTab(Context context, AttributeSet attrs, int defStyleAttr, int icon, CharSequence title) {
        super(context, attrs, defStyleAttr);
        this.init(context, icon, title);
    }

    private void init(Context context, int icon, CharSequence title) {
        this.mContext = context;
        this.setBackgroundDrawable(null);
        LinearLayout lLContainer = new LinearLayout(context);
        lLContainer.setOrientation(1);
        lLContainer.setGravity(17);
        FrameLayout.LayoutParams paramsContainer = new FrameLayout.LayoutParams(-2, -2);
        paramsContainer.gravity = 17;
        lLContainer.setLayoutParams((ViewGroup.LayoutParams)paramsContainer);
        this.mIcon = new ImageView(context);
        int size = (int)TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(size, size);
        this.mIcon.setImageResource(icon);
        this.mIcon.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mIcon.setAlpha(0.5f);
        this.mIcon.setColorFilter(ContextCompat.getColor((Context)context, (int)R.color.com_bihe0832_tab_unselect));
        lLContainer.addView((View)this.mIcon);
        this.mTvTitle = new TextView(context);
        this.mTvTitle.setText(title);
        LinearLayout.LayoutParams paramsTv = new LinearLayout.LayoutParams(-2, -2);
        paramsTv.topMargin = (int)TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mTvTitle.setTextSize(9.0f);
        this.mTvTitle.setAlpha(0.5f);
        if (BuildUtils.INSTANCE.getSDK_INT() >= 21) {
            this.mTvTitle.setLetterSpacing(0.19f);
        }
        this.mTvTitle.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.com_bihe0832_tab_unselect));
        this.mTvTitle.setLayoutParams((ViewGroup.LayoutParams)paramsTv);
        lLContainer.addView((View)this.mTvTitle);
        this.addView((View)lLContainer);
        this.mUnreadDot = new ImageView(context);
        this.mUnreadDot.setBackgroundResource(R.drawable.botton_bar_tab_red_dot);
        FrameLayout.LayoutParams UnreadDotParams = new FrameLayout.LayoutParams(this.dip2px(context, 8.0f), this.dip2px(context, 8.0f));
        UnreadDotParams.gravity = 17;
        UnreadDotParams.leftMargin = this.dip2px(context, 17.0f);
        UnreadDotParams.bottomMargin = this.dip2px(context, 14.0f);
        this.mUnreadDot.setLayoutParams((ViewGroup.LayoutParams)UnreadDotParams);
        this.mUnreadDot.setVisibility(8);
        this.addView((View)this.mUnreadDot);
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (selected) {
            this.mIcon.setAlpha(1.0f);
            this.mIcon.setColorFilter(ContextCompat.getColor((Context)this.mContext, (int)R.color.com_bihe0832_tab_selected));
            this.mTvTitle.setAlpha(1.0f);
            this.mTvTitle.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.com_bihe0832_tab_selected));
        } else {
            this.mIcon.setAlpha(0.5f);
            this.mIcon.setColorFilter(ContextCompat.getColor((Context)this.mContext, (int)R.color.com_bihe0832_tab_unselect));
            this.mTvTitle.setAlpha(0.5f);
            this.mTvTitle.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.com_bihe0832_tab_unselect));
        }
    }

    public void setTabPosition(int position) {
        this.mTabPosition = position;
        if (position == 0) {
            this.setSelected(true);
        }
    }

    public int getTabPosition() {
        return this.mTabPosition;
    }

    public void setUnreadDot(boolean visible) {
        if (visible) {
            this.mUnreadDot.setVisibility(0);
        } else {
            this.mUnreadDot.setVisibility(8);
        }
    }

    private int dip2px(Context context, float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

