/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.utils.os;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import java.lang.reflect.Method;

public class DisplayUtil {
    public static final int NAV_GESTURE = 0;
    public static final int NAV_VIRTUAL = 1;
    public static final int NAV_BUTTON = 2;
    private static float sNoncompatDensity;
    private static float sNoncompatScaledDensity;

    public static void hideSoftInput(Activity act) {
        InputMethodManager manager;
        boolean isOpen;
        View v = act.getCurrentFocus();
        if (v != null && v.getWindowToken() != null && (isOpen = (manager = (InputMethodManager)act.getSystemService("input_method")).isActive())) {
            manager.hideSoftInputFromWindow(v.getWindowToken(), 2);
        }
    }

    public static boolean checkNavigationBarShow(Context context, Window window) {
        boolean show;
        Display display = window.getWindowManager().getDefaultDisplay();
        Point point = new Point();
        display.getRealSize(point);
        View decorView = window.getDecorView();
        Configuration conf = context.getResources().getConfiguration();
        if (2 == conf.orientation) {
            View contentView = decorView.findViewById(0x1020002);
            ZLog.d((String)("checkNavigationBarShow point.x:" + point.x + ",contentView.getWidth():" + contentView.getWidth()));
            show = point.x != contentView.getWidth();
        } else {
            Rect rect = new Rect();
            decorView.getWindowVisibleDisplayFrame(rect);
            ZLog.d((String)("checkNavigationBarShow point.y:" + point.y + ",rect.bottom:" + rect.bottom));
            show = rect.bottom != point.y;
        }
        return show;
    }

    public static boolean checkDeviceHasNavigationBar(Context context, Window window) {
        if (BuildUtils.INSTANCE.getSDK_INT() >= 17) {
            Display display = window.getWindowManager().getDefaultDisplay();
            Point size = new Point();
            Point realSize = new Point();
            display.getSize(size);
            display.getRealSize(realSize);
            ZLog.d((String)("checkDeviceHasNavigationBar realSize.y:" + realSize.y + ",size.y:" + size.y));
            return realSize.y != size.y;
        }
        boolean menu = ViewConfiguration.get((Context)context).hasPermanentMenuKey();
        boolean back = KeyCharacterMap.deviceHasKey((int)4);
        return !menu && !back;
    }

    public static int getNavigationBarHeight(Context context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static int getStatusBarHeight(Context context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static int getScreenHeight(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(dm);
        return dm.heightPixels;
    }

    @Deprecated
    public static int getScreenWidth(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(dm);
        return dm.widthPixels;
    }

    public static int getScreenAvailabe(Activity act) {
        WindowManager.LayoutParams attrs = act.getWindow().getAttributes();
        if (attrs.flags == 1024) {
            return DisplayUtil.getScreenHeight((Context)act);
        }
        return DisplayUtil.getScreenHeight((Context)act) - DisplayUtil.getStatusBarHeight((Context)act);
    }

    public static int getRealScreenSizeX(Context context) {
        if (BuildUtils.INSTANCE.getSDK_INT() > 17) {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            Display display = windowManager.getDefaultDisplay();
            Point outSize = new Point();
            display.getRealSize(outSize);
            return outSize.x;
        }
        return DisplayUtil.getScreenWidth(context);
    }

    public static int getRealScreenSizeY(Context context) {
        if (BuildUtils.INSTANCE.getSDK_INT() > 17) {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            Display display = windowManager.getDefaultDisplay();
            Point outSize = new Point();
            display.getRealSize(outSize);
            return outSize.y;
        }
        return DisplayUtil.getScreenHeight(context);
    }

    public static int dip2px(Context context, float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int sp2px(Context context, float spValue) {
        return (int)TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int px2sp(Context context, int px) {
        float scale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)((float)px / scale + 0.5f);
    }

    public static int getDimension(Context context, int resourceId) {
        return context.getResources().getDimensionPixelSize(resourceId);
    }

    public static int getNavigationBarType(Context context, Window window) {
        if (DisplayUtil.hasNavigationBar()) {
            if (DisplayUtil.detectNavigationBarIsShow(context, window)) {
                return 1;
            }
            return 0;
        }
        return 2;
    }

    @SuppressLint(value={"PrivateApi", "DiscouragedPrivateApi"})
    public static boolean hasNavigationBar() {
        boolean haveNav = false;
        try {
            Class<?> windowManagerGlobalClass = Class.forName("android.view.WindowManagerGlobal");
            Method getWmServiceMethod = windowManagerGlobalClass.getDeclaredMethod("getWindowManagerService", new Class[0]);
            getWmServiceMethod.setAccessible(true);
            Object iWindowManager = getWmServiceMethod.invoke(null, new Object[0]);
            Class<?> iWindowManagerClass = iWindowManager.getClass();
            Method hasNavBarMethod = iWindowManagerClass.getDeclaredMethod("hasNavigationBar", new Class[0]);
            hasNavBarMethod.setAccessible(true);
            haveNav = (Boolean)hasNavBarMethod.invoke(iWindowManager, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return haveNav;
    }

    public static boolean detectNavigationBarIsShow(Context context, Window window) {
        ViewGroup vp = (ViewGroup)window.getDecorView();
        Resources resources = context.getResources();
        for (int i = 0; i < vp.getChildCount(); ++i) {
            vp.getChildAt(i).getContext().getPackageName();
            if (vp.getChildAt(i).getId() == -1 || !"navigationBarBackground".equals(resources.getResourceEntryName(vp.getChildAt(i).getId()))) continue;
            return true;
        }
        return false;
    }

    public static void resetDensity(final Activity activity, final float density) {
        if (activity == null) {
            ZLog.w((String)"resetDensity activity is null");
            return;
        }
        ZLog.w((String)("resetDensity density\uff1a" + density));
        if (density < 1.0f) {
            return;
        }
        final Application application = activity.getApplication();
        DisplayMetrics appDisplayMetrics = application.getResources().getDisplayMetrics();
        ZLog.d((String)("sNoncompatDensity: " + sNoncompatDensity));
        ZLog.d((String)("sNoncompatScaledDensity: " + sNoncompatScaledDensity));
        if (sNoncompatDensity == 0.0f) {
            sNoncompatDensity = appDisplayMetrics.density;
            sNoncompatScaledDensity = appDisplayMetrics.scaledDensity;
            application.registerComponentCallbacks(new ComponentCallbacks(){

                public void onConfigurationChanged(Configuration newConfig) {
                    if (newConfig != null && newConfig.fontScale > 0.0f) {
                        ZLog.d((String)("onConfigurationChanged sNoncompatScaledDensity: " + sNoncompatScaledDensity));
                        sNoncompatScaledDensity = application.getResources().getDisplayMetrics().scaledDensity;
                        ZLog.d((String)("onConfigurationChanged sNoncompatScaledDensity: " + sNoncompatScaledDensity));
                        DisplayUtil.resetDensity(activity, density);
                    }
                }

                public void onLowMemory() {
                }
            });
        }
        int width = appDisplayMetrics.widthPixels;
        int height = appDisplayMetrics.heightPixels;
        int target = width;
        if (width > height) {
            target = height;
        }
        float targetDensity = (float)target / density;
        DisplayMetrics activityDisplayMetrics = activity.getResources().getDisplayMetrics();
        ZLog.d((String)"--------------------------------");
        ZLog.d((String)("target: " + target));
        ZLog.d((String)("targetDensity: " + targetDensity));
        ZLog.d((String)"--------------------------------");
        ZLog.d((String)("appDisplayMetrics.density: " + appDisplayMetrics.density));
        ZLog.d((String)("appDisplayMetrics.scaledDensity: " + appDisplayMetrics.scaledDensity));
        ZLog.d((String)("appDisplayMetrics.densityDpi: " + appDisplayMetrics.densityDpi));
        ZLog.d((String)("appDisplayMetrics.widthPixels: " + appDisplayMetrics.widthPixels));
        ZLog.d((String)("appDisplayMetrics.heightPixels: " + appDisplayMetrics.heightPixels + "\n"));
        ZLog.d((String)("activityDisplayMetrics.density: " + activityDisplayMetrics.density));
        ZLog.d((String)("activityDisplayMetrics.scaledDensity: " + activityDisplayMetrics.scaledDensity));
        ZLog.d((String)("activityDisplayMetrics.densityDpi: " + activityDisplayMetrics.densityDpi));
        ZLog.d((String)"--------------------------------");
        if (targetDensity < 1.0f) {
            targetDensity = 1.0f;
        }
        float targetScaledDensity = targetDensity * (sNoncompatScaledDensity / sNoncompatDensity);
        int targetDensityDpi = (int)(160.0f * targetDensity);
        ZLog.d((String)"--------------------------------");
        ZLog.d((String)("targetDensity: " + targetDensity));
        ZLog.d((String)("targetScaledDensity: " + targetScaledDensity));
        ZLog.d((String)("targetDensityDpi: " + targetDensityDpi));
        ZLog.d((String)"--------------------------------");
        appDisplayMetrics.density = targetDensity;
        appDisplayMetrics.scaledDensity = targetScaledDensity;
        appDisplayMetrics.densityDpi = targetDensityDpi;
        activityDisplayMetrics.density = targetDensity;
        activityDisplayMetrics.scaledDensity = targetScaledDensity;
        activityDisplayMetrics.densityDpi = targetDensityDpi;
    }
}

