/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ace.editor;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Base64;
import android.util.Pair;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import com.bihe0832.android.lib.ace.editor.AceWebView;
import com.bihe0832.android.lib.ace.editor.R;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

public class AceEditorView
extends FrameLayout {
    private static final int MAX_EXCHANGE_SIZE = 25000;
    private AceWebView mWebView;
    private final Random mRandom = new Random();
    private final Pattern mPattern = Pattern.compile("edt:(\\d)+:[pfm]:");
    private boolean mReadOnly = true;
    private boolean mWrap = true;
    private int mTextSize = 12;
    private boolean mNotifyMimeTypeChanges;
    private boolean mIsDirty;
    private boolean mInitialLoad = true;
    private boolean mReady;
    private boolean mIgnoreNextUnsavedEvent;
    private String mPendingFileName;
    private byte[] mPendingContent;
    private String mResolveMimetType = null;
    private OnContentChangedListener mContentChangedListener;
    private OnMessageListener mMessageListener;
    private SparseArray<Pair<StringBuilder, OnReadContentReadyListener>> mMap = new SparseArray();

    public AceEditorView(Context context) {
        this(context, null);
    }

    public AceEditorView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AceEditorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources.Theme theme = context.getTheme();
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.AceEditorView, defStyleAttr, 0);
        int n = a.getIndexCount();
        for (int i = 0; i < n; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.AceEditorView_locked) {
                this.mReadOnly = a.getBoolean(attr, this.mReadOnly);
            }
            if (attr != R.styleable.AceEditorView_wrap) continue;
            this.mWrap = a.getBoolean(attr, this.mWrap);
        }
        a.recycle();
        this.mWebView = this.createWebView();
        this.addView((View)this.mWebView);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private AceWebView createWebView() {
        AceWebView webview = new AceWebView(this.getContext());
        webview.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        webview.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                AceEditorView.this.mReady = true;
                AceEditorView.this.setReadOnly(AceEditorView.this.mReadOnly);
                AceEditorView.this.setWrap(AceEditorView.this.mWrap);
                AceEditorView.this.setTextSize(AceEditorView.this.mTextSize);
                AceEditorView.this.setNotifyMimeTypeChanges(AceEditorView.this.mNotifyMimeTypeChanges);
                if (AceEditorView.this.mPendingContent != null) {
                    AceEditorView.this.loadEncodedContent(AceEditorView.this.mPendingFileName, AceEditorView.this.mPendingContent);
                    AceEditorView.this.mPendingFileName = null;
                    AceEditorView.access$502(AceEditorView.this, null);
                }
            }
        });
        webview.setWebChromeClient(new WebChromeClient(){

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                String msg = consoleMessage.message();
                if (msg.equals("edt:crc")) {
                    if (AceEditorView.this.mMessageListener != null) {
                        AceEditorView.this.mMessageListener.onErrorMessage(R.string.ace_editor_load_failed);
                    }
                    return true;
                }
                if (msg.equals("edt:big")) {
                    if (AceEditorView.this.mMessageListener != null) {
                        AceEditorView.this.mMessageListener.onWarnMessage(R.string.ace_editor_file_to_big);
                    }
                    return true;
                }
                if (msg.equals("edt:u")) {
                    if (!AceEditorView.this.mIgnoreNextUnsavedEvent) {
                        AceEditorView.this.mIsDirty = true;
                        if (AceEditorView.this.mContentChangedListener != null) {
                            AceEditorView.this.mContentChangedListener.onContentChanged();
                        }
                    }
                    AceEditorView.this.mIgnoreNextUnsavedEvent = false;
                    return true;
                }
                if (msg.startsWith("edt:mtc:")) {
                    String mimeType = msg.substring(msg.lastIndexOf(":") + 1);
                    if (TextUtils.isEmpty((CharSequence)mimeType)) {
                        mimeType = "text/plain";
                    }
                    String ext = AceEditorView.resolveExtensionFromMimeType(mimeType);
                    if (AceEditorView.this.mReady) {
                        AceEditorView.this.mWebView.loadUrl("javascript: setFileName('unnamed." + ext + "');");
                    }
                }
                if (AceEditorView.this.mPattern.matcher(msg).find()) {
                    String[] v = msg.split(":");
                    int key = Integer.parseInt(v[1]);
                    Pair o = (Pair)AceEditorView.this.mMap.get(key);
                    if (o == null) {
                        super.onConsoleMessage(consoleMessage);
                        return false;
                    }
                    switch (v[2]) {
                        case "p": {
                            ((StringBuilder)o.first).append(v[3]);
                            break;
                        }
                        case "m": {
                            AceEditorView.this.mResolveMimetType = v[3];
                            break;
                        }
                        case "f": {
                            byte[] content = ((StringBuilder)o.first).length() == 0 ? new byte[]{} : ((StringBuilder)o.first).toString().getBytes();
                            int crc = Integer.parseInt(v[3]);
                            int computedCrc = AceEditorView.crc(content);
                            if (crc != -1 && crc != computedCrc) {
                                if (AceEditorView.this.mMessageListener != null) {
                                    AceEditorView.this.mMessageListener.onErrorMessage(R.string.ace_editor_save_failed);
                                }
                                return true;
                            }
                            ((OnReadContentReadyListener)o.second).onReadContentReady(content, AceEditorView.this.mResolveMimetType);
                            AceEditorView.this.mMap.remove(key);
                        }
                    }
                    return true;
                }
                super.onConsoleMessage(consoleMessage);
                return false;
            }
        });
        WebSettings webSettings = webview.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setUseWideViewPort(true);
        String url = String.format(Locale.US, "file:///android_asset/editor/editor.html?cache=%d&enable-selection-handles=%s", System.currentTimeMillis(), Build.VERSION.SDK_INT >= 16);
        webview.loadUrl(url);
        return webview;
    }

    public void setDebug(boolean isDebug) {
        if (BuildUtils.INSTANCE.getSDK_INT() > 19) {
            AceWebView.setWebContentsDebuggingEnabled((boolean)isDebug);
        }
    }

    public boolean isWrap() {
        return this.mWrap;
    }

    public AceEditorView setWrap(boolean wrap) {
        this.mWrap = wrap;
        if (this.mReady) {
            this.mWebView.loadUrl("javascript: setWrapMode(" + this.mWrap + ");");
        }
        return this;
    }

    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    public AceEditorView setReadOnly(boolean readOnly) {
        this.mReadOnly = readOnly;
        this.mWebView.setReadOnly(readOnly);
        if (this.mReady) {
            this.mWebView.loadUrl("javascript: setReadOnly(" + this.mReadOnly + ");");
        }
        return this;
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public AceEditorView setTextSize(int textSize) {
        this.mTextSize = textSize;
        if (this.mReady) {
            this.mWebView.loadUrl("javascript: setTextSize(" + this.mTextSize + ");");
        }
        return this;
    }

    public boolean isNotifyMimeTypeChanges() {
        return this.mNotifyMimeTypeChanges;
    }

    public AceEditorView setNotifyMimeTypeChanges(boolean notify) {
        this.mNotifyMimeTypeChanges = notify;
        if (this.mReady) {
            this.mWebView.loadUrl("javascript: setNotifyMimeTypeChanges(" + notify + ");");
        }
        return this;
    }

    public boolean isDirty() {
        return this.mIsDirty;
    }

    public AceEditorView listenOn(OnContentChangedListener cb) {
        this.mContentChangedListener = cb;
        return this;
    }

    public AceEditorView listenOn(OnMessageListener cb) {
        this.mMessageListener = cb;
        return this;
    }

    public void loadContent(String fileName, byte[] content) {
        this.loadEncodedContent(fileName, Base64.encode((byte[])content, (int)2));
    }

    public void loadEncodedContent(String fileName, byte[] encoded) {
        if (!this.mReady) {
            this.mPendingFileName = fileName;
            this.mPendingContent = encoded;
            return;
        }
        int crc = 0;
        if (encoded.length > 0) {
            int e;
            int s = 0;
            do {
                e = Math.min(encoded.length - s, 25000);
                String msg = new String(encoded, s, e);
                this.mWebView.loadUrl("javascript: addPartialContent('" + msg + "');");
            } while ((s += e) < encoded.length);
            crc = AceEditorView.crc(encoded);
        }
        this.mIgnoreNextUnsavedEvent = true;
        if (!this.mInitialLoad) {
            this.mIsDirty = false;
        }
        this.mInitialLoad = false;
        this.mWebView.loadUrl("javascript: loadContent('" + fileName + "','" + crc + "');");
    }

    public void readContent(OnReadContentReadyListener cb) {
        this.readContent(cb, false);
    }

    public void readContent(OnReadContentReadyListener cb, boolean resolveMimeType) {
        if (this.mIsDirty) {
            int key = this.mRandom.nextInt(Short.MAX_VALUE);
            this.mMap.put(key, (Object)new Pair((Object)new StringBuilder(), (Object)cb));
            this.mWebView.loadUrl("javascript: readContent(" + resolveMimeType + "," + key + ");");
        } else {
            cb.onContentUnchanged();
        }
    }

    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.mReadOnly = this.mReadOnly;
        savedState.mWrap = this.mWrap;
        savedState.mTextSize = this.mTextSize;
        savedState.mIsDirty = this.mIsDirty;
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mReadOnly = savedState.mReadOnly;
        this.mWrap = savedState.mWrap;
        this.mTextSize = savedState.mTextSize;
        this.mIsDirty = savedState.mIsDirty;
    }

    private static int crc(byte[] data) {
        CRC32 crc = new CRC32();
        crc.update(data);
        return (int)crc.getValue();
    }

    public static String resolveExtensionFromMimeType(String mimeType) {
        if (mimeType != null) {
            switch (mimeType) {
                case "text/javascript": {
                    return "js";
                }
                case "text/x-c": {
                    return "c";
                }
                case "text/x-c++": {
                    return "cpp";
                }
                case "text/x-python": {
                    return "py";
                }
                case "text/x-java": {
                    return "java";
                }
                case "text/html": {
                    return "html";
                }
                case "text/css": {
                    return "css";
                }
                case "text/x-ruby": {
                    return "rb";
                }
                case "text/x-go": {
                    return "go";
                }
                case "text/x-php": {
                    return "php";
                }
            }
        }
        return "txt";
    }

    static /* synthetic */ byte[] access$502(AceEditorView x0, byte[] x1) {
        x0.mPendingContent = x1;
        return x1;
    }

    private static class SavedState
    extends View.BaseSavedState {
        boolean mReadOnly;
        boolean mWrap;
        int mTextSize;
        boolean mIsDirty;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mReadOnly = in.readInt() == 1;
            this.mWrap = in.readInt() == 1;
            this.mTextSize = in.readInt();
            this.mIsDirty = in.readInt() == 1;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mReadOnly ? 1 : 0);
            out.writeInt(this.mWrap ? 1 : 0);
            out.writeInt(this.mTextSize);
            out.writeInt(this.mIsDirty ? 1 : 0);
        }
    }

    public static interface OnMessageListener {
        public void onErrorMessage(@StringRes int var1);

        public void onWarnMessage(@StringRes int var1);
    }

    public static interface OnContentChangedListener {
        public void onContentChanged();
    }

    public static interface OnReadContentReadyListener {
        public void onReadContentReady(byte[] var1, String var2);

        public void onContentUnchanged();
    }
}

