/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.framework.ui;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Process;
import android.support.multidex.MultiDex;
import android.util.Log;
import android.webkit.WebView;
import com.bihe0832.android.framework.ZixieContext;
import com.bihe0832.android.framework.ZixieCoreInit;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import com.bumptech.glide.Glide;
import java.util.List;

public abstract class BaseApplication
extends Application {
    protected abstract boolean isDebug();

    protected abstract boolean isOfficial();

    protected abstract boolean skipPrivacy();

    protected abstract String versionTag();

    public void onCreate() {
        super.onCreate();
        Log.d((String)"Application", (String)"base BaseApplication onCreate start");
        ZixieCoreInit.INSTANCE.initCore(this, this.isDebug(), this.isOfficial(), this.skipPrivacy(), this.versionTag());
        ActivityManager am = (ActivityManager)this.getSystemService("activity");
        List runningApps = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo it : runningApps) {
            if (it.pid != Process.myPid() || it.processName == null || !it.processName.contains(this.getPackageName())) continue;
            ZLog.e((String)("Application initCore process: name:" + it.processName + " and id:" + it.pid));
            if (it.processName.equalsIgnoreCase(this.getPackageName())) {
                ZixieContext.INSTANCE.showDebugEditionToast();
                continue;
            }
            if (BuildUtils.INSTANCE.getSDK_INT() >= 28) {
                WebView.setDataDirectorySuffix((String)it.processName);
            }
            ZixieContext.INSTANCE.showDebug("\u72ec\u7acb\u8fdb\u7a0b\u521d\u59cb\u5316\uff1a" + it.processName);
            ZLog.e((String)("Application process: name:" + it.processName + " and id:" + it.pid));
        }
        Log.d((String)"Application", (String)"base BaseApplication onCreate end");
    }

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        MultiDex.install((Context)this);
    }

    public void onLowMemory() {
        super.onLowMemory();
        ZLog.e((String)"Application", (String)"Application onLowMemory");
        Glide.get((Context)this).clearMemory();
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        ZLog.e((String)"Application", (String)"Application onTrimMemory");
        if (level > 20) {
            Glide.get((Context)this).clearMemory();
        }
        Glide.get((Context)this).trimMemory(level);
    }
}

