/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.webview.base;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.support.constraint.ConstraintLayout;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.FragmentActivity;
import android.support.v4.widget.SwipeRefreshLayout;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.bihe0832.android.common.webview.R;
import com.bihe0832.android.common.webview.base.CookieManagerForZixie;
import com.bihe0832.android.common.webview.base.WebViewViewModel;
import com.bihe0832.android.common.webview.log.MyBaseJsBridgeProxy;
import com.bihe0832.android.common.webview.log.WebviewLoggerFile;
import com.bihe0832.android.framework.ZixieContext;
import com.bihe0832.android.framework.ui.BaseFragment;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.request.URLUtils;
import com.bihe0832.android.lib.utils.intent.IntentUtils;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import com.bihe0832.android.lib.webview.BaseWebView;
import com.bihe0832.android.lib.webview.jsbridge.BaseJsBridgeProxy;
import com.tencent.smtt.export.external.interfaces.ConsoleMessage;
import com.tencent.smtt.export.external.interfaces.IX5WebChromeClient;
import com.tencent.smtt.export.external.interfaces.JsPromptResult;
import com.tencent.smtt.export.external.interfaces.JsResult;
import com.tencent.smtt.export.external.interfaces.SslError;
import com.tencent.smtt.export.external.interfaces.SslErrorHandler;
import com.tencent.smtt.export.external.interfaces.WebResourceRequest;
import com.tencent.smtt.export.external.interfaces.WebResourceResponse;
import com.tencent.smtt.sdk.MimeTypeMap;
import com.tencent.smtt.sdk.ValueCallback;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebSettings;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseWebviewFragment
extends BaseFragment
implements ActivityCompat.OnRequestPermissionsResultCallback {
    protected static final String TAG = "WebPageFragment -> :";
    public static final String INTENT_KEY_URL = "url";
    public static final String INTENT_KEY_REFRESH = "refresh";
    public static final String INTENT_KEY_DATA = "WebviewFragment.data";
    public static final String INTENT_KEY_THIRD_PART = "http://localhost";
    private static final String HEADER_NAME_REFERER = "Referer";
    private HashMap<String, String> globalLocalRes = new HashMap<String, String>(){
        {
            this.put("https://cdn.bihe0832.com/js/jsbridge.js", "web/js/jsbridge.min.new.js");
        }
    };
    private WebViewRefreshCallback mRefreshCallback = null;
    private View mCustomView;
    public BaseWebView mWebView;
    private IX5WebChromeClient.CustomViewCallback mCustomViewCallback;
    private ConstraintLayout mErrorPage;
    private SwipeRefreshLayout mNormalPage;
    private TextView mRetry;
    private TextView mRedirect;
    private ViewGroup mViewParent;
    protected ProgressBar mProgressBar;
    private SwipeRefreshLayout mSwipeLayout;
    private Boolean isLoadSuccess = true;
    private TextView mErrorUrl;
    private WebViewViewModel mWebViewViewModel;
    protected BaseJsBridgeProxy mJSBridgeProxy = null;
    private ValueCallback<Uri[]> mPicUploadCallback;
    protected String mIntentUrl;
    protected String mPostData;
    protected boolean mRefreshable;
    private int mOriginalSystemUiVisibility;
    private int mOriginalOrientation;
    private MutableLiveData<Integer> _webViewScrollTopLiveData = new MutableLiveData();
    private LiveData<Integer> mWebViewScrollTopLiveData = this._webViewScrollTopLiveData;
    private long lastResumeTime = 0L;
    private long lastPauseTime = 0L;

    public static Bundle getWebviewDataBundle(String url, String data) {
        Bundle bundle = new Bundle();
        bundle.putString(INTENT_KEY_URL, URLUtils.encode((String)url));
        if (!TextUtils.isEmpty((CharSequence)data)) {
            bundle.putString(INTENT_KEY_DATA, data);
        }
        return bundle;
    }

    protected abstract String getFinalURL(String var1);

    protected abstract void actionBeforeLoadURL(String var1);

    protected abstract boolean loadUseIntent(String var1);

    protected abstract String getUserAgentString();

    protected abstract MyBaseJsBridgeProxy getJsBridgeProxy();

    public LiveData<Integer> getWebViewScrollTopLiveData() {
        return this.mWebViewScrollTopLiveData;
    }

    public void setOnWebViewRefreshCallback(WebViewRefreshCallback callback) {
        this.mRefreshCallback = callback;
    }

    public HashMap<String, String> getGlobalLocalRes() {
        return this.globalLocalRes;
    }

    protected void actionOnPageFinished(WebView view, String url) {
    }

    protected WebViewClient getWebViewClient() {
        return new MyWebViewClient(this.getJsBridgeProxy());
    }

    protected WebChromeClient getWebChromeClient() {
        return new MyWebChromeClient();
    }

    protected BaseWebView createWebView() {
        return new BaseWebView(this.getContext(), null);
    }

    protected void initView(@NonNull View view) {
        super.initView(view);
        this.mWebViewViewModel = (WebViewViewModel)ViewModelProviders.of((FragmentActivity)this.getActivity()).get(WebViewViewModel.class);
        this.mWebView = this.createWebView();
        this.mViewParent = (ViewGroup)view.findViewById(R.id.app_webview_x5webView);
        this.mRetry = (TextView)view.findViewById(R.id.web_retry);
        this.mRedirect = (TextView)view.findViewById(R.id.web_native_browser);
        this.mErrorUrl = (TextView)view.findViewById(R.id.web_error_url);
        this.mRetry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BaseWebviewFragment.this.loadUrl(BaseWebviewFragment.this.mIntentUrl, BaseWebviewFragment.this.mPostData);
            }
        });
        this.mRedirect.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IntentUtils.openWebPage((String)BaseWebviewFragment.this.mIntentUrl, (Context)BaseWebviewFragment.this.getContext());
            }
        });
        this.getActivity().getWindow().setFormat(-3);
        this.initWebview(view, this.getWebViewClient(), this.getWebChromeClient());
    }

    protected void parseBundle(Bundle bundle, boolean isOnCreate) {
        this.mIntentUrl = URLDecoder.decode(bundle.getString(INTENT_KEY_URL));
        this.mRefreshable = bundle.getBoolean(INTENT_KEY_REFRESH, false);
        this.mPostData = bundle.getString(INTENT_KEY_DATA);
    }

    protected int getLayoutID() {
        return R.layout.common_zixie_fragment_webview;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1 && (data != null || resultCode == -1)) {
            Uri[] uris = new Uri[]{data.getData()};
            if (this.mPicUploadCallback != null) {
                this.mPicUploadCallback.onReceiveValue((Object)uris);
                this.mPicUploadCallback = null;
            }
        }
    }

    protected void initWebview(View view, WebViewClient webViewClient, WebChromeClient webChromeClient) {
        this.mNormalPage = (SwipeRefreshLayout)view.findViewById(R.id.app_webview_swipe_container);
        this.mViewParent.addView((View)this.mWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mErrorPage = (ConstraintLayout)view.findViewById(R.id.error_page);
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.app_webview_progressbar);
        this.mProgressBar.setMax(100);
        this.mSwipeLayout = (SwipeRefreshLayout)view.findViewById(R.id.app_webview_swipe_container);
        this.mSwipeLayout.setEnabled(this.mRefreshable);
        this.mSwipeLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                BaseWebviewFragment.this.mSwipeLayout.setRefreshing(false);
                if (BaseWebviewFragment.this.mJSBridgeProxy != null && BaseWebviewFragment.this.mJSBridgeProxy.canPullToRefresh()) {
                    if (BaseWebviewFragment.this.mRefreshCallback != null) {
                        BaseWebviewFragment.this.mRefreshCallback.onRefresh((WebView)BaseWebviewFragment.this.mWebView);
                    } else {
                        BaseWebviewFragment.this.mWebView.reload();
                    }
                    BaseWebviewFragment.this.mSwipeLayout.setEnabled(true);
                }
            }
        });
        this.mWebView.setOnScrollChangedCallback(new BaseWebView.OnScrollChangedCallback(){

            public void onScroll(int l, int t) {
                ZLog.d((String)BaseWebviewFragment.TAG, (String)("We Scrolled etc..." + l + " t =" + t));
                BaseWebviewFragment.this._webViewScrollTopLiveData.postValue((Object)t);
                if (t > 0) {
                    BaseWebviewFragment.this.mSwipeLayout.setEnabled(false);
                } else if (BaseWebviewFragment.this.mJSBridgeProxy != null && BaseWebviewFragment.this.mJSBridgeProxy.canPullToRefresh()) {
                    BaseWebviewFragment.this.mSwipeLayout.setEnabled(true);
                } else {
                    BaseWebviewFragment.this.mSwipeLayout.setEnabled(false);
                }
            }
        });
        if (BuildUtils.INSTANCE.getSDK_INT() > 19) {
            if (!ZixieContext.INSTANCE.isOfficial()) {
                BaseWebView.setWebContentsDebuggingEnabled((boolean)true);
            } else {
                BaseWebView.setWebContentsDebuggingEnabled((boolean)false);
            }
        }
        this.mWebView.setWebViewClient(webViewClient);
        this.mWebView.setWebChromeClient(webChromeClient);
        this.setUserAgentSupport(this.mWebView.getSettings());
        CookieManagerForZixie.INSTANCE.init((WebView)this.mWebView);
        long time = System.currentTimeMillis();
        if (this.mIntentUrl == null) {
            this.mIntentUrl = "about:blank;";
        } else {
            this.loadUrl(this.mIntentUrl, this.mPostData);
        }
        ZLog.d((String)TAG, (String)("time-cost cost time: " + (System.currentTimeMillis() - time)));
    }

    public void loadUrl(String url, String data) {
        this.isLoadSuccess = true;
        this.mIntentUrl = url;
        this.mPostData = data;
        this.actionBeforeLoadURL(url);
        if (TextUtils.isEmpty((CharSequence)data)) {
            this.mWebView.loadUrl(this.getFinalURL(url));
        } else {
            this.mWebView.postUrl(this.getFinalURL(url), data.getBytes());
        }
    }

    protected WebResourceResponse interceptRequestResult(String url) {
        if (null != this.getGlobalLocalRes() && this.getGlobalLocalRes().containsKey(url)) {
            try {
                String type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl((String)url));
                return new WebResourceResponse(type, "UTF-8", this.getContext().getAssets().open(this.getGlobalLocalRes().get(url)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void openImageChooserActivity() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.addCategory("android.intent.category.OPENABLE");
        intent.setType("image/*");
        this.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Image Chooser"), 1);
    }

    private void setUserAgentSupport(WebSettings webSettings) {
        String userAgent = webSettings.getUserAgentString();
        String myAgent = " " + this.getUserAgentString();
        userAgent = TextUtils.isEmpty((CharSequence)userAgent) ? myAgent : (userAgent.endsWith("/") ? userAgent + myAgent : userAgent + "/" + myAgent);
        webSettings.setUserAgentString(userAgent);
    }

    public void onResume() {
        ZLog.d((String)TAG, (String)"onResume ");
        super.onResume();
        this.onJSBridgeResume();
    }

    public void onPause() {
        ZLog.d((String)TAG, (String)"onPause ");
        super.onPause();
        this.onJSBridgePause();
    }

    private void onJSBridgeResume() {
        if (null != this.mJSBridgeProxy) {
            ZLog.d((String)TAG, (String)"onJSBridgeResume");
            if (System.currentTimeMillis() - this.lastResumeTime < 5000L) {
                ZLog.d((String)TAG, (String)"onJSBridgeResume to quick");
                return;
            }
            this.lastResumeTime = System.currentTimeMillis();
            this.lastPauseTime = 0L;
            this.mJSBridgeProxy.onResume();
        }
    }

    private void onJSBridgePause() {
        if (null != this.mJSBridgeProxy) {
            ZLog.d((String)TAG, (String)"onJSBridgePause");
            if (System.currentTimeMillis() - this.lastPauseTime < 5000L) {
                ZLog.d((String)TAG, (String)"onJSBridgePause to quick");
                return;
            }
            this.lastPauseTime = System.currentTimeMillis();
            this.lastResumeTime = 0L;
            this.mJSBridgeProxy.onPause();
        }
    }

    public void setUserVisibleHint(boolean isVisibleToUser, boolean hasCreateView) {
        ZLog.d((String)TAG, (String)("setUserVisibleHint " + isVisibleToUser));
        if (isVisibleToUser) {
            this.onJSBridgeResume();
        } else {
            this.onJSBridgePause();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mWebView != null) {
            this.mWebView.stopLoading();
            this.mWebView.clearHistory();
            this.mWebView.destroy();
        }
        if (BuildUtils.INSTANCE.getSDK_INT() < 16) {
            try {
                Field field = WebView.class.getDeclaredField("mWebViewCore");
                field = field.getType().getDeclaredField("mBrowserFrame");
                field = field.getType().getDeclaredField("sConfigCallback");
                field.setAccessible(true);
                field.set(null, null);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Field sConfigCallback = Class.forName("android.webkit.BrowserFrame").getDeclaredField("sConfigCallback");
                if (sConfigCallback != null) {
                    sConfigCallback.setAccessible(true);
                    sConfigCallback.set(null, null);
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean onBackPressedSupport() {
        if (this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            return true;
        }
        return false;
    }

    public void setCookie(String url, String name, String value) {
        CookieManagerForZixie.INSTANCE.setCookie(url, name, value);
    }

    public void syncCookie() {
        CookieManagerForZixie.INSTANCE.syncCookie();
    }

    public void removeCookiesForDomain(String url) {
        CookieManagerForZixie.INSTANCE.removeCookiesForDomain(url);
    }

    public static interface WebViewRefreshCallback {
        public void onRefresh(WebView var1);
    }

    protected class MyWebChromeClient
    extends WebChromeClient {
        protected MyWebChromeClient() {
        }

        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            BaseWebviewFragment.this.mPicUploadCallback = filePathCallback;
            BaseWebviewFragment.this.openImageChooserActivity();
            return true;
        }

        public void onProgressChanged(WebView view, int newProgress) {
            ZLog.d((String)BaseWebviewFragment.TAG, (String)("onProgressChanged " + newProgress));
            BaseWebviewFragment.this.mProgressBar.setProgress(newProgress);
            if (newProgress == 100) {
                BaseWebviewFragment.this.mProgressBar.setVisibility(8);
            } else {
                BaseWebviewFragment.this.mProgressBar.setVisibility(0);
            }
            if (newProgress == 100) {
                BaseWebviewFragment.this.mSwipeLayout.setRefreshing(false);
            } else if (!BaseWebviewFragment.this.mSwipeLayout.isRefreshing()) {
                BaseWebviewFragment.this.mSwipeLayout.setRefreshing(true);
            }
            super.onProgressChanged(view, newProgress);
        }

        public void onReceivedTitle(WebView view, String title) {
            super.onReceivedTitle(view, title);
            BaseWebviewFragment.this.mWebViewViewModel.setTitleString(title);
            WebviewLoggerFile.INSTANCE.log("BaseWebviewFragment title\uff1a" + title);
            WebviewLoggerFile.INSTANCE.log("BaseWebviewFragment mWebViewViewModel: " + ((Object)((Object)BaseWebviewFragment.this.mWebViewViewModel)).hashCode());
        }

        public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
            return true;
        }

        public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
            ZLog.d((String)BaseWebviewFragment.TAG, (String)("onJsPrompt " + url));
            return super.onJsPrompt(view, url, message, defaultValue, result);
        }

        public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
            ZLog.d((String)BaseWebviewFragment.TAG, (String)("onJsConfirm " + message));
            return super.onJsConfirm(view, url, message, result);
        }

        public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
            ZLog.d((String)BaseWebviewFragment.TAG, (String)("onJsAlert " + message));
            result.confirm();
            return true;
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            ZLog.d((String)BaseWebviewFragment.TAG, (String)("onConsoleMessage  From line " + consoleMessage.lineNumber() + " of " + consoleMessage.sourceId() + " \n\t" + consoleMessage.message()));
            return super.onConsoleMessage(consoleMessage);
        }

        public void onShowCustomView(View view, IX5WebChromeClient.CustomViewCallback callback) {
            if (BaseWebviewFragment.this.mCustomView != null) {
                this.onHideCustomView();
                return;
            }
            BaseWebviewFragment.this.mCustomView = view;
            BaseWebviewFragment.this.mOriginalSystemUiVisibility = BaseWebviewFragment.this.getActivity().getWindow().getDecorView().getSystemUiVisibility();
            BaseWebviewFragment.this.mOriginalOrientation = BaseWebviewFragment.this.getActivity().getRequestedOrientation();
            BaseWebviewFragment.this.mCustomViewCallback = callback;
            FrameLayout decor = (FrameLayout)BaseWebviewFragment.this.getActivity().getWindow().getDecorView();
            decor.addView(BaseWebviewFragment.this.mCustomView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            BaseWebviewFragment.this.getActivity().getWindow().getDecorView().setSystemUiVisibility(3846);
            BaseWebviewFragment.this.getActivity().setRequestedOrientation(0);
        }

        public void onHideCustomView() {
            FrameLayout decor = (FrameLayout)BaseWebviewFragment.this.getActivity().getWindow().getDecorView();
            decor.removeView(BaseWebviewFragment.this.mCustomView);
            BaseWebviewFragment.this.mCustomView = null;
            BaseWebviewFragment.this.getActivity().getWindow().getDecorView().setSystemUiVisibility(BaseWebviewFragment.this.mOriginalSystemUiVisibility);
            BaseWebviewFragment.this.getActivity().setRequestedOrientation(BaseWebviewFragment.this.mOriginalOrientation);
            BaseWebviewFragment.this.mCustomViewCallback.onCustomViewHidden();
            BaseWebviewFragment.this.mCustomViewCallback = null;
        }
    }

    protected class MyWebViewClient
    extends WebViewClient {
        public MyBaseJsBridgeProxy mJSBridgeProxy = null;
        private String mRefererString = "";

        public MyWebViewClient(MyBaseJsBridgeProxy jsBridge) {
            BaseWebviewFragment.this.mJSBridgeProxy = jsBridge;
            this.mJSBridgeProxy = jsBridge;
        }

        public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
            WebResourceResponse res;
            ZLog.d((String)("WebPageFragment -> :shouldInterceptRequest url:" + url));
            if (BuildUtils.INSTANCE.getSDK_INT() < 21 && null != (res = BaseWebviewFragment.this.interceptRequestResult(url))) {
                return res;
            }
            return super.shouldInterceptRequest(view, url);
        }

        public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
            ZLog.d((String)("WebPageFragment -> :shouldInterceptRequest url:" + request.getUrl().toString()));
            if (BuildUtils.INSTANCE.getSDK_INT() >= 21) {
                WebResourceResponse res;
                String url = request.getUrl().toString();
                Map headerHashMap = request.getRequestHeaders();
                if (headerHashMap.containsKey(BaseWebviewFragment.HEADER_NAME_REFERER)) {
                    this.mRefererString = (String)headerHashMap.get(BaseWebviewFragment.HEADER_NAME_REFERER);
                }
                if (null != (res = BaseWebviewFragment.this.interceptRequestResult(url))) {
                    return res;
                }
            }
            return super.shouldInterceptRequest(view, request);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            WebviewLoggerFile.INSTANCE.log("WebPageFragment -> :shouldOverrideUrlLoading url:" + url);
            if (TextUtils.isEmpty((CharSequence)url)) {
                return super.shouldOverrideUrlLoading(view, url);
            }
            if (url.startsWith(BaseWebviewFragment.INTENT_KEY_THIRD_PART)) {
                String value = URLUtils.getValueByName((String)url, (String)"value");
                try {
                    return this.processOverrideUrlLoading(view, URLDecoder.decode(value, "UTF-8"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return super.shouldOverrideUrlLoading(view, url);
                }
            }
            return this.processOverrideUrlLoading(view, url);
        }

        protected boolean processOverrideUrlLoading(WebView view, String url) {
            try {
                if (url.startsWith("jsb://")) {
                    if (this.mJSBridgeProxy != null) {
                        this.mJSBridgeProxy.invoke(url);
                    }
                    return true;
                }
                if (url.equals("about:blank;") || url.equals("about:blank")) {
                    return BuildUtils.INSTANCE.getSDK_INT() < 11;
                }
                if (url.startsWith("http") || url.startsWith("https")) {
                    if (BaseWebviewFragment.this.loadUseIntent(url)) {
                        return this.jumpToOtherApp(url, (Context)BaseWebviewFragment.this.getActivity());
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.mRefererString)) {
                        HashMap<String, String> headerHashMap = new HashMap<String, String>();
                        headerHashMap.put(BaseWebviewFragment.HEADER_NAME_REFERER, this.mRefererString);
                        BaseWebviewFragment.this.mWebView.loadUrl(url, headerHashMap);
                    } else {
                        BaseWebviewFragment.this.mWebView.loadUrl(url);
                    }
                    return true;
                }
                return this.jumpToOtherApp(url, (Context)BaseWebviewFragment.this.getActivity());
            }
            catch (Exception e) {
                e.printStackTrace();
                return super.shouldOverrideUrlLoading(view, url);
            }
        }

        public boolean jumpToOtherApp(String url, Context context) {
            if (context != null && !TextUtils.isEmpty((CharSequence)url)) {
                try {
                    ZLog.e((String)BaseWebviewFragment.TAG, (String)("jumpToOtherApp url:" + url));
                    context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
                    return true;
                }
                catch (Exception var4) {
                    ZLog.e((String)BaseWebviewFragment.TAG, (String)("jumpToOtherApp failed:" + var4.getMessage()));
                    return false;
                }
            }
            return false;
        }

        protected Map<String, String> getWechatCertifiedomainList() {
            return new HashMap<String, String>();
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (BaseWebviewFragment.this.isLoadSuccess.booleanValue()) {
                BaseWebviewFragment.this.mNormalPage.setVisibility(0);
                BaseWebviewFragment.this.mErrorPage.setVisibility(8);
            } else {
                BaseWebviewFragment.this.mNormalPage.setVisibility(8);
                BaseWebviewFragment.this.mErrorPage.setVisibility(0);
            }
            BaseWebviewFragment.this.actionOnPageFinished(view, url);
        }

        public void onPageStarted(WebView webView, String s, Bitmap bitmap) {
            super.onPageStarted(webView, s, bitmap);
            BaseWebviewFragment.this.mNormalPage.setVisibility(0);
            BaseWebviewFragment.this.mErrorPage.setVisibility(8);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            BaseWebviewFragment.this.isLoadSuccess = false;
            BaseWebviewFragment.this.mErrorUrl.setText((CharSequence)BaseWebviewFragment.this.mIntentUrl);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            handler.proceed();
        }
    }
}

