/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.network.okhttp.interceptor;

import com.bihe0832.android.common.network.okhttp.OkHttpClientExtKt;
import com.bihe0832.android.common.network.okhttp.OkHttpWrapper;
import com.bihe0832.android.common.network.okhttp.interceptor.data.AAFRequestDataRepository;
import com.bihe0832.android.common.network.okhttp.interceptor.data.NetworkContentDataRecord;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\fH\u0004J\u001a\u0010\u000f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/bihe0832/android/common/network/okhttp/interceptor/AAFOKHttpInterceptor;", "Lokhttp3/Interceptor;", "enableIntercept", "", "(Z)V", "HTTP_REQ_PROPERTY_CONTENT_ENCODING", "", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "interceptRequest", "Lokhttp3/Request;", "requestId", "request", "interceptResponse", "response", "CommonNetwork_release"})
public class AAFOKHttpInterceptor
implements Interceptor {
    private final String HTTP_REQ_PROPERTY_CONTENT_ENCODING = "Content-Encoding";
    private boolean enableIntercept;

    @NotNull
    protected final Response interceptResponse(@Nullable String requestId, @NotNull Response response) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        return response;
    }

    @NotNull
    protected final Request interceptRequest(@Nullable String requestId, @NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return request;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Response response;
        block17: {
            Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
            String requestId = OkHttpWrapper.INSTANCE.generateRequestID();
            NetworkContentDataRecord networkContentDataRecord = null;
            Request request = chain.request().newBuilder().header("AAF-Content-Request-Id", requestId).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"chain.request().newBuild\u2026ST_ID, requestId).build()");
            Request request2 = this.interceptRequest(requestId, request);
            if (this.enableIntercept) {
                networkContentDataRecord = AAFRequestDataRepository.INSTANCE.getNetworkContentDataRecordByContentID(requestId);
                Connection connection = chain.connection();
                Connection connection2 = connection;
                if (connection2 == null || (connection2 = connection2.protocol()) == null) {
                    connection2 = Protocol.HTTP_1_1;
                }
                Connection protocol = connection2;
                String string = request2.url().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.url().toString()");
                networkContentDataRecord.setUrl(string);
                String string2 = request2.method();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"request.method()");
                networkContentDataRecord.setMethod(string2);
                networkContentDataRecord.setProtocol((Protocol)protocol);
                networkContentDataRecord.setRequestHeadersMap(request2.headers());
                RequestBody requestBody = request2.body();
                if (requestBody != null) {
                    long contentLength = requestBody.contentLength();
                    networkContentDataRecord.setRequestBodyLength(contentLength != -1L ? contentLength + "-byte" : "unknown-length");
                    if (requestBody.contentType() != null) {
                        networkContentDataRecord.setRequestContentType(requestBody.contentType());
                    }
                    networkContentDataRecord.setRequestBody(OkHttpClientExtKt.getRequestParams(request2));
                }
            }
            response = null;
            try {
                Response response2 = chain.proceed(request2);
                Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"chain.proceed(request)");
                response = this.interceptResponse(requestId, response2);
            }
            catch (Exception var25) {
                if (this.enableIntercept) {
                    NetworkContentDataRecord networkContentDataRecord2 = networkContentDataRecord;
                    if (networkContentDataRecord2 != null) {
                        networkContentDataRecord2.setErrorMsg(var25.toString());
                    }
                }
                throw (Throwable)var25;
            }
            if (!this.enableIntercept) break block17;
            NetworkContentDataRecord networkContentDataRecord3 = networkContentDataRecord;
            if (networkContentDataRecord3 != null) {
                networkContentDataRecord3.setResponseHeadersMap(response.headers());
            }
            NetworkContentDataRecord networkContentDataRecord4 = networkContentDataRecord;
            if (networkContentDataRecord4 != null) {
                networkContentDataRecord4.setStatus(response.code());
            }
            NetworkContentDataRecord networkContentDataRecord5 = networkContentDataRecord;
            if (networkContentDataRecord5 != null) {
                String string = response.message();
                if (string == null) {
                    string = "";
                }
                networkContentDataRecord5.setErrorMsg(string);
            }
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                long contentLength = responseBody.contentLength();
                NetworkContentDataRecord networkContentDataRecord6 = networkContentDataRecord;
                if (networkContentDataRecord6 != null) {
                    networkContentDataRecord6.setResponseBodyLength(contentLength != -1L ? contentLength + "-byte" : "unknown-length");
                }
                if (responseBody.contentType() != null) {
                    NetworkContentDataRecord networkContentDataRecord7 = networkContentDataRecord;
                    if (networkContentDataRecord7 != null) {
                        networkContentDataRecord7.setResponseContentType(responseBody.contentType());
                    }
                }
                NetworkContentDataRecord networkContentDataRecord8 = networkContentDataRecord;
                if (networkContentDataRecord8 != null) {
                    networkContentDataRecord8.setResponseBody(OkHttpClientExtKt.getResponseData(response));
                }
            }
        }
        return response;
    }

    public AAFOKHttpInterceptor(boolean enableIntercept) {
        this.enableIntercept = enableIntercept;
        this.HTTP_REQ_PROPERTY_CONTENT_ENCODING = "Content-Encoding";
    }

    public /* synthetic */ AAFOKHttpInterceptor(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public AAFOKHttpInterceptor() {
        this(false, 1, null);
    }
}

