/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.network.okhttp;

import android.os.SystemClock;
import com.bihe0832.android.common.network.okhttp.OkHttpWrapper;
import com.bihe0832.android.common.network.okhttp.interceptor.AAFNetworkEventListener;
import com.bihe0832.android.common.network.okhttp.interceptor.AAFOKHttpInterceptor;
import com.bihe0832.android.common.network.okhttp.interceptor.data.AAFRequestDataRepository;
import com.bihe0832.android.common.network.okhttp.interceptor.data.NetworkRecord;
import com.bihe0832.android.lib.utils.IdGenerator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001dJ\u0006\u0010$\u001a\u00020\u0004J\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u001dJ\u001e\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0004J\u0012\u0010)\u001a\u0004\u0018\u00010\r2\b\u0010*\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\n\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006-"}, d2={"Lcom/bihe0832/android/common/network/okhttp/OkHttpWrapper;", "", "()V", "HTTP_REQ_PROPERTY_AAF_CONTENT_REQUEST_ID", "", "mRequestIdGenerator", "Lcom/bihe0832/android/lib/utils/IdGenerator;", "getMRequestIdGenerator", "()Lcom/bihe0832/android/lib/utils/IdGenerator;", "mRequestIdGenerator$delegate", "Lkotlin/Lazy;", "mRequestRecords", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/bihe0832/android/common/network/okhttp/interceptor/data/NetworkRecord;", "getMRequestRecords", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "mRequestRecords$delegate", "maxRequestListSize", "", "getMaxRequestListSize", "()I", "setMaxRequestListSize", "(I)V", "addRecord", "", "record", "generateNetworkEventListener", "Lokhttp3/EventListener$Factory;", "enableTrace", "", "enableLog", "listener", "Lokhttp3/EventListener;", "generateNetworkInterceptor", "Lokhttp3/Interceptor;", "enableIntercept", "generateRequestID", "getOkHttpClientBuilder", "Lokhttp3/OkHttpClient$Builder;", "getOkHttpClientBuilderWithInterceptor", "enableTraceAndIntercept", "getRecord", "requestId", "url", "method", "CommonNetwork_release"})
public final class OkHttpWrapper {
    @NotNull
    public static final String HTTP_REQ_PROPERTY_AAF_CONTENT_REQUEST_ID = "AAF-Content-Request-Id";
    private static final Lazy mRequestIdGenerator$delegate;
    private static final Lazy mRequestRecords$delegate;
    private static int maxRequestListSize;
    public static final OkHttpWrapper INSTANCE;

    private final IdGenerator getMRequestIdGenerator() {
        Lazy lazy = mRequestIdGenerator$delegate;
        OkHttpWrapper okHttpWrapper = this;
        Object var3_3 = null;
        boolean bl = false;
        return (IdGenerator)lazy.getValue();
    }

    private final CopyOnWriteArrayList<NetworkRecord> getMRequestRecords() {
        Lazy lazy = mRequestRecords$delegate;
        OkHttpWrapper okHttpWrapper = this;
        Object var3_3 = null;
        boolean bl = false;
        return (CopyOnWriteArrayList)lazy.getValue();
    }

    private final void addRecord(NetworkRecord record) {
        if (this.getMRequestRecords().size() > maxRequestListSize) {
            AAFRequestDataRepository.INSTANCE.removeData(this.getMRequestRecords().get(0).getTraceRequestId());
            this.getMRequestRecords().remove(0);
        }
        this.getMRequestRecords().add(record);
    }

    public final int getMaxRequestListSize() {
        return maxRequestListSize;
    }

    public final void setMaxRequestListSize(int n) {
        maxRequestListSize = n;
    }

    @NotNull
    public final OkHttpClient.Builder getOkHttpClientBuilder() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        boolean bl = false;
        boolean bl2 = false;
        OkHttpClient.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.connectTimeout(5000L, TimeUnit.MILLISECONDS);
        $this$apply.readTimeout(5000L, TimeUnit.MILLISECONDS);
        $this$apply.writeTimeout(5000L, TimeUnit.MILLISECONDS);
        $this$apply.retryOnConnectionFailure(true);
        return builder;
    }

    @NotNull
    public final OkHttpClient.Builder getOkHttpClientBuilderWithInterceptor(boolean enableTraceAndIntercept) {
        OkHttpClient.Builder builder = this.getOkHttpClientBuilder();
        boolean bl = false;
        boolean bl2 = false;
        OkHttpClient.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.addNetworkInterceptor((Interceptor)new AAFOKHttpInterceptor(enableTraceAndIntercept));
        $this$apply.eventListenerFactory(INSTANCE.generateNetworkEventListener(enableTraceAndIntercept, enableTraceAndIntercept, null));
        return builder;
    }

    @NotNull
    public final Interceptor generateNetworkInterceptor(boolean enableIntercept) {
        return new AAFOKHttpInterceptor(enableIntercept);
    }

    @NotNull
    public final EventListener.Factory generateNetworkEventListener(boolean enableTrace) {
        return this.generateNetworkEventListener(enableTrace, enableTrace, null);
    }

    @NotNull
    public final EventListener.Factory generateNetworkEventListener(boolean enableTrace, boolean enableLog, @Nullable EventListener listener) {
        return new EventListener.Factory(enableTrace, enableLog, listener){
            final /* synthetic */ boolean $enableTrace;
            final /* synthetic */ boolean $enableLog;
            final /* synthetic */ EventListener $listener;

            @NotNull
            public final AAFNetworkEventListener create(Call it) {
                return new AAFNetworkEventListener(this.$enableTrace, this.$enableLog, this.$listener);
            }
            {
                this.$enableTrace = bl;
                this.$enableLog = bl2;
                this.$listener = eventListener;
            }
        };
    }

    @NotNull
    public final String generateRequestID() {
        return String.valueOf(this.getMRequestIdGenerator().generate());
    }

    @Nullable
    public final NetworkRecord getRecord(@Nullable String requestId) {
        Object v0;
        block1: {
            Iterable iterable = this.getMRequestRecords();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                NetworkRecord it = (NetworkRecord)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getTraceRequestId(), (Object)requestId)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final NetworkRecord getRecord(@NotNull String requestId, @NotNull String url, @NotNull String method) {
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)requestId, (String)"requestId");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Iterable iterable = this.getMRequestRecords();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                NetworkRecord it = (NetworkRecord)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getTraceRequestId(), (Object)requestId)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        NetworkRecord record = v0;
        if (record == null) {
            record = new NetworkRecord(requestId, url, method, SystemClock.elapsedRealtime());
            this.addRecord(record);
        }
        return record;
    }

    private OkHttpWrapper() {
    }

    static {
        OkHttpWrapper okHttpWrapper;
        INSTANCE = okHttpWrapper = new OkHttpWrapper();
        mRequestIdGenerator$delegate = LazyKt.lazy((Function0)mRequestIdGenerator.2.INSTANCE);
        mRequestRecords$delegate = LazyKt.lazy((Function0)mRequestRecords.2.INSTANCE);
        maxRequestListSize = 100;
    }
}

