/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.debug.item;

import android.content.Context;
import android.view.View;
import android.widget.TextView;
import com.bihe0832.android.common.debug.R;
import com.bihe0832.android.common.debug.item.DebugItemData;
import com.bihe0832.android.lib.adapter.CardBaseHolder;
import com.bihe0832.android.lib.adapter.CardBaseModule;
import com.bihe0832.android.lib.text.TextFactoryUtils;
import com.bihe0832.android.lib.theme.ThemeResourcesManager;

public class DebugItemHolder
extends CardBaseHolder {
    public TextView mHeader;
    public View mBottomLine;

    public DebugItemHolder(View itemView, Context context) {
        super(itemView, context);
    }

    public void initView() {
        this.mHeader = (TextView)this.getView(R.id.bad_card_title);
        this.mBottomLine = this.getView(R.id.test_bottom_line);
    }

    public void initData(CardBaseModule item) {
        DebugItemData data = (DebugItemData)item;
        this.mHeader.setText((CharSequence)TextFactoryUtils.getSpannedTextByHtml((String)data.mContentText));
        if (null != data.mListener) {
            this.itemView.setOnClickListener(data.mListener);
        }
        if (null != data.mLongClickListener) {
            this.itemView.setOnLongClickListener(data.mLongClickListener);
        }
        if (!data.hasBackground) {
            ((View)this.mHeader.getParent()).setBackgroundColor(ThemeResourcesManager.INSTANCE.getColor(R.color.transparent).intValue());
        }
        if (data.showBottomLine && null != this.mBottomLine) {
            this.mBottomLine.setVisibility(0);
        } else {
            this.mBottomLine.setVisibility(8);
        }
    }
}

