/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.debug;

import android.os.Bundle;
import android.os.StrictMode;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.bihe0832.android.common.debug.R;
import com.bihe0832.android.framework.ZixieContext;
import com.bihe0832.android.framework.ui.BaseFragment;
import com.bihe0832.android.framework.ui.main.CommonActivity;
import com.bihe0832.android.lib.adapter.CardInfoHelper;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.ReflecterHelper;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import me.yokeyword.fragmentation.ISupportFragment;

public class DebugMainActivity
extends CommonActivity {
    final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    public static final String DEBUG_MODULE_CLASS_NAME = "com.bihe0832.android.common.debug.module.class.name";
    public static final String DEBUG_MODULE_TITLE_NAME = "com.bihe0832.android.common.debug.module.title.name";
    private String rootFragmentClassName = "";
    private String rootFragmentTitleName = "";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.rootFragmentClassName = this.getIntent().getStringExtra(DEBUG_MODULE_CLASS_NAME);
        this.rootFragmentTitleName = this.getIntent().getStringExtra(DEBUG_MODULE_TITLE_NAME);
        ZLog.d((String)this.TAG, (String)("rootFragmentClassName: " + this.rootFragmentClassName));
        ZLog.d((String)this.TAG, (String)("rootFragmentTitleName: " + this.rootFragmentTitleName));
        this.initToolbar(this.getTitleName(), true, R.mipmap.btn_back);
        if (BuildUtils.INSTANCE.getSDK_INT() > 9) {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().permitAll().build());
        }
        CardInfoHelper.getInstance().setAutoAddItem(true);
        this.loadFragment();
    }

    protected String getRootFragmentClassName() {
        return this.rootFragmentClassName;
    }

    protected String getTitleName() {
        if (TextUtils.isEmpty((CharSequence)this.rootFragmentTitleName)) {
            try {
                if (this.getRootFragmentClassName() != null) {
                    return this.getRootFragmentClassName().substring(this.getRootFragmentClassName().lastIndexOf(".") + 1);
                }
                return ((Object)((Object)this)).getClass().getSimpleName();
            }
            catch (Exception e) {
                e.printStackTrace();
                return ((Object)((Object)this)).getClass().getSimpleName();
            }
        }
        return this.rootFragmentTitleName;
    }

    protected void onResume() {
        super.onResume();
        try {
            Class<?> rootFragmentClass = Class.forName(this.getRootFragmentClassName());
            if (this.findFragment(rootFragmentClass) != null) {
                ((BaseFragment)this.findFragment(rootFragmentClass)).setUserVisibleHint(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void loadFragment() {
        String rootFragmentClassName = this.getRootFragmentClassName();
        try {
            Class<?> rootFragmentClass;
            if (TextUtils.isEmpty((CharSequence)rootFragmentClassName)) {
                ZixieContext.INSTANCE.showDebug("\u7c7b\u540d\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
                this.finish();
            }
            if ((rootFragmentClass = Class.forName(rootFragmentClassName)).getClass().isAssignableFrom(BaseFragment.class.getClass())) {
                if (this.findFragment(rootFragmentClass) == null) {
                    this.loadRootFragment((ISupportFragment)ReflecterHelper.newInstance((String)rootFragmentClassName, null));
                }
            } else {
                ZixieContext.INSTANCE.showDebug(rootFragmentClassName + "\u4e0d\u662f\u7ee7\u627f BaseFragment");
                this.finish();
            }
        }
        catch (ClassNotFoundException e) {
            ZixieContext.INSTANCE.showDebug("\u6ca1\u6709\u627e\u5230" + rootFragmentClassName);
            this.finish();
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

