/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.accessibility.action;

import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.GestureDescription;
import android.content.Context;
import android.graphics.Path;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.RequiresApi;
import com.bihe0832.android.lib.utils.intent.IntentUtils;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\nJ\u0006\u0010\u001c\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/bihe0832/android/common/accessibility/action/AAFAccessibilityManager;", "", "()V", "TAG", "", "isStart", "", "mAAFAccessibilityActionDispatcher", "Lcom/bihe0832/android/common/accessibility/action/AAFAccessibilityManager$AAFAccessibilityActionDispatcher;", "addAccessibilityActionDispatcher", "", "dispatcher", "isOk", "openSettings", "context", "Landroid/content/Context;", "performAction", "path", "Landroid/graphics/Path;", "callback", "Landroid/accessibilityservice/AccessibilityService$GestureResultCallback;", "performGlobalAction", "action", "", "performViewAction", "info", "Landroid/view/accessibility/AccessibilityNodeInfo;", "start", "stop", "AAFAccessibilityActionDispatcher", "CommonAccessibility_release"})
public final class AAFAccessibilityManager {
    @NotNull
    public static final AAFAccessibilityManager INSTANCE = new AAFAccessibilityManager();
    @NotNull
    public static final String TAG = "AAFAccessibilityManager";
    private static boolean isStart;
    @Nullable
    private static AAFAccessibilityActionDispatcher mAAFAccessibilityActionDispatcher;

    private AAFAccessibilityManager() {
    }

    public final void addAccessibilityActionDispatcher(@NotNull AAFAccessibilityActionDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        mAAFAccessibilityActionDispatcher = dispatcher;
    }

    public final boolean isOk() {
        return isStart;
    }

    public final void start() {
        isStart = true;
    }

    public final void stop() {
        isStart = false;
    }

    public final void openSettings(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IntentUtils.startSettings((Context)context, (String)"android.settings.ACCESSIBILITY_SETTINGS");
    }

    public final boolean performGlobalAction(int action) {
        AAFAccessibilityActionDispatcher aAFAccessibilityActionDispatcher = mAAFAccessibilityActionDispatcher;
        return aAFAccessibilityActionDispatcher != null ? aAFAccessibilityActionDispatcher.performGlobalAction(action) : false;
    }

    public final boolean performViewAction(@NotNull AccessibilityNodeInfo info, int action) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return info.performAction(action);
    }

    @RequiresApi(value=24)
    public final void performAction(@NotNull Path path, @Nullable AccessibilityService.GestureResultCallback callback) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (BuildUtils.INSTANCE.getSDK_INT() < 24) break block1;
            GestureDescription.Builder gesture = new GestureDescription.Builder();
            gesture.addStroke(new GestureDescription.StrokeDescription(path, 0L, (long)ViewConfiguration.getTapTimeout()));
            AAFAccessibilityActionDispatcher aAFAccessibilityActionDispatcher = mAAFAccessibilityActionDispatcher;
            if (aAFAccessibilityActionDispatcher != null) {
                GestureDescription gestureDescription = gesture.build();
                Intrinsics.checkNotNullExpressionValue((Object)gestureDescription, (String)"gesture.build()");
                aAFAccessibilityActionDispatcher.dispatchGesture(gestureDescription, callback);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b"}, d2={"Lcom/bihe0832/android/common/accessibility/action/AAFAccessibilityManager$AAFAccessibilityActionDispatcher;", "", "dispatchGesture", "", "gesture", "Landroid/accessibilityservice/GestureDescription;", "callback", "Landroid/accessibilityservice/AccessibilityService$GestureResultCallback;", "performGlobalAction", "action", "", "CommonAccessibility_release"})
    public static interface AAFAccessibilityActionDispatcher {
        public boolean performGlobalAction(int var1);

        public boolean dispatchGesture(@NotNull GestureDescription var1, @Nullable AccessibilityService.GestureResultCallback var2);
    }
}

