/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.accessibility.action;

import android.accessibilityservice.AccessibilityService;
import android.graphics.Path;
import android.view.accessibility.AccessibilityNodeInfo;
import com.bihe0832.android.common.accessibility.action.AAFAccessibilityManager;
import com.bihe0832.android.common.accessibility.view.PositionConfig;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.ConvertUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u0016\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"Lcom/bihe0832/android/common/accessibility/action/AAFAccessibilityDispatcher;", "", "()V", "doClickAction", "", "locX", "", "locY", "callback", "Landroid/accessibilityservice/AccessibilityService$GestureResultCallback;", "key", "", "performGlobalAction", "", "action", "performViewAction", "info", "Landroid/view/accessibility/AccessibilityNodeInfo;", "CommonAccessibility_release"})
public final class AAFAccessibilityDispatcher {
    @NotNull
    public static final AAFAccessibilityDispatcher INSTANCE = new AAFAccessibilityDispatcher();

    private AAFAccessibilityDispatcher() {
    }

    public final void doClickAction(@NotNull String key, @Nullable AccessibilityService.GestureResultCallback callback) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        List<String> it = PositionConfig.INSTANCE.getPositionList(key);
        boolean bl = false;
        int centerX = ConvertUtils.parseInt((String)ConvertUtils.getSafeValueFromList(it, (int)2, (String)""), (int)-1);
        int centerY = ConvertUtils.parseInt((String)ConvertUtils.getSafeValueFromList(it, (int)3, (String)""), (int)-1);
        if (centerX > 0 || centerY > 0) {
            ZLog.d((String)"AAFAccessibilityManager", (String)('[' + key + "] doClickAction  (centerX, centeY):" + centerX + ' ' + centerY));
            INSTANCE.doClickAction(centerX, centerY, callback);
        } else {
            ZLog.d((String)"AAFAccessibilityManager", (String)('[' + key + "] doClickAction bad (centerX, centeY):" + centerX + ' ' + centerY));
        }
    }

    public final void doClickAction(int locX, int locY, @Nullable AccessibilityService.GestureResultCallback callback) {
        if (locX < 0 || locY < -1) {
            return;
        }
        Path path = new Path();
        path.reset();
        path.moveTo((float)locX, (float)locY);
        path.lineTo((float)locX, (float)locY);
        AAFAccessibilityManager.INSTANCE.performAction(path, callback);
    }

    public final boolean performGlobalAction(int action) {
        return AAFAccessibilityManager.INSTANCE.performGlobalAction(action);
    }

    public final boolean performViewAction(@NotNull AccessibilityNodeInfo info, int action) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return info.performAction(action);
    }
}

