/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ResourceBundle;
import com.beust.jcommander.converters.NoConverter;
import com.beust.jcommander.converters.StringConverter;
import com.beust.jcommander.internal.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterDescription {
    private Object m_object;
    private Parameter m_parameterAnnotation;
    private Field m_field;
    private boolean m_assigned = false;
    private java.util.ResourceBundle m_bundle;
    private String m_description;
    private JCommander m_jCommander;

    public ParameterDescription(Object object, Parameter annotation, Field field, java.util.ResourceBundle bundle, JCommander jc) {
        this.init(object, annotation, field, bundle, jc);
    }

    private java.util.ResourceBundle findResourceBundle(Object o) {
        java.util.ResourceBundle result = null;
        Parameters p = o.getClass().getAnnotation(Parameters.class);
        if (p != null && !this.isEmpty(p.resourceBundle())) {
            result = java.util.ResourceBundle.getBundle(p.resourceBundle(), Locale.getDefault());
        } else {
            ResourceBundle a = o.getClass().getAnnotation(ResourceBundle.class);
            if (a != null && !this.isEmpty(a.value())) {
                result = java.util.ResourceBundle.getBundle(a.value(), Locale.getDefault());
            }
        }
        return result;
    }

    private boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }

    private void init(Object object, Parameter annotation, Field field, java.util.ResourceBundle bundle, JCommander jCommander) {
        this.m_object = object;
        this.m_parameterAnnotation = annotation;
        this.m_field = field;
        this.m_bundle = bundle;
        if (this.m_bundle == null) {
            this.m_bundle = this.findResourceBundle(object);
        }
        this.m_jCommander = jCommander;
        this.m_description = annotation.description();
        if (!"".equals(annotation.descriptionKey()) && this.m_bundle != null) {
            this.m_description = this.m_bundle.getString(annotation.descriptionKey());
        }
    }

    public String getDescription() {
        return this.m_description;
    }

    public Object getObject() {
        return this.m_object;
    }

    public String getNames() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.m_parameterAnnotation.names().length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.m_parameterAnnotation.names()[i]);
        }
        return sb.toString();
    }

    public Parameter getParameter() {
        return this.m_parameterAnnotation;
    }

    public Field getField() {
        return this.m_field;
    }

    private boolean isMultiOption() {
        Class<?> fieldType = this.m_field.getType();
        return fieldType.equals(List.class) || fieldType.equals(Set.class);
    }

    public void addValue(String value) {
        this.addValue(value, false);
    }

    public void addValue(String value, boolean isDefault) {
        this.p("Adding " + (isDefault ? "default " : "") + "value:" + value + " to parameter:" + this.m_field.getName());
        boolean isCollection = false;
        if (this.m_assigned && !this.isMultiOption()) {
            throw new ParameterException("Can only specify option " + this.m_parameterAnnotation.names()[0] + " once.");
        }
        Class<?> type = this.m_field.getType();
        Class<IStringConverter<Object>> converterClass = null;
        converterClass = this.m_parameterAnnotation.converter();
        if (converterClass == NoConverter.class) {
            converterClass = this.m_jCommander.findConverter(type);
        }
        if (converterClass == null && this.m_parameterAnnotation.arity() >= 2) {
            converterClass = StringConverter.class;
            isCollection = true;
        }
        if (converterClass == null && Collection.class.isAssignableFrom(type)) {
            converterClass = StringConverter.class;
            isCollection = true;
        }
        if (converterClass == null) {
            throw new ParameterException("Don't know how to convert " + value + " to type " + type + " (field: " + this.m_field.getName() + ")");
        }
        if (!isDefault) {
            this.m_assigned = true;
        }
        try {
            IStringConverter<?> converter = this.instantiateConverter(converterClass);
            Object convertedValue = converter.convert(value);
            if (isCollection) {
                List l = (List)this.m_field.get(this.m_object);
                if (l == null) {
                    l = Lists.newArrayList();
                    this.m_field.set(this.m_object, l);
                }
                l.add(convertedValue);
            } else {
                this.m_field.set(this.m_object, convertedValue);
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public boolean isNumber() {
        Class<?> type = this.m_field.getType();
        return type.equals(Integer.class) || type.equals(Integer.TYPE) || type.equals(Long.class) || type.equals(Long.TYPE);
    }

    private IStringConverter<?> instantiateConverter(Class<? extends IStringConverter<?>> converterClass) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] ctors;
        Constructor<?> ctor = null;
        Constructor<?> stringCtor = null;
        for (Constructor<?> c : ctors = converterClass.getDeclaredConstructors()) {
            Class<?>[] types = c.getParameterTypes();
            if (types.length == 1 && types[0].equals(String.class)) {
                stringCtor = c;
                continue;
            }
            if (types.length != 0) continue;
            ctor = c;
        }
        IStringConverter result = stringCtor != null ? (IStringConverter)stringCtor.newInstance(this.m_parameterAnnotation.names()[0]) : (IStringConverter)ctor.newInstance(new Object[0]);
        return result;
    }

    private void p(String string) {
        if (System.getProperty("jcommander.debug") != null) {
            System.out.println("[ParameterDescription] " + string);
        }
    }
}

