/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import java.io.BufferedReader;
import java.io.Console;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCommander {
    public static final String DEBUG_PROPERTY = "jcommander.debug";
    private Map<String, ParameterDescription> m_descriptions;
    private List<Object> m_objects;
    private Field m_mainParameterField = null;
    private Object m_mainParameterObject;
    private Parameter m_mainParameterAnnotation;
    private Map<Field, ParameterDescription> m_requiredFields = Maps.newHashMap();
    private Map<Field, ParameterDescription> m_fields = Maps.newHashMap();
    private ResourceBundle m_bundle;

    public JCommander(Object object) {
        this.init(object, null);
    }

    public JCommander(Object object, ResourceBundle bundle, String ... args) {
        this.init(object, bundle);
        this.parse(args);
    }

    public JCommander(Object object, String ... args) {
        this.init(object, null);
        this.parse(args);
    }

    private void init(Object object, ResourceBundle bundle) {
        this.m_bundle = bundle;
        this.m_objects = Lists.newArrayList();
        if (object instanceof Iterable) {
            for (Object o : (Iterable)object) {
                this.m_objects.add(o);
            }
        } else if (object.getClass().isArray()) {
            for (Object o : (Object[])object) {
                this.m_objects.add(o);
            }
        } else {
            this.m_objects.add(object);
        }
        this.createDescriptions();
    }

    public void parse(String ... args) {
        this.parseValues(this.expandArgs(args));
        this.validateOptions();
    }

    private void validateOptions() {
        if (!this.m_requiredFields.isEmpty()) {
            StringBuilder missingFields = new StringBuilder();
            for (ParameterDescription pd : this.m_requiredFields.values()) {
                missingFields.append(pd.getNames()).append(" ");
            }
            throw new ParameterException("The following options are required: " + missingFields);
        }
    }

    private String[] expandArgs(String[] originalArgv) {
        List vResult1 = Lists.newArrayList();
        for (String arg : originalArgv) {
            if (arg.startsWith("@")) {
                String fileName = arg.substring(1);
                vResult1.addAll(JCommander.readFile(fileName));
                continue;
            }
            vResult1.add(arg);
        }
        List vResult2 = Lists.newArrayList();
        for (int i = 0; i < vResult1.size(); ++i) {
            String arg = (String)vResult1.get(i);
            if (arg.startsWith("-")) {
                String sep = this.getSeparatorFor(arg);
                if (!" ".equals(sep)) {
                    String[] sp;
                    for (String ssp : sp = arg.split("[" + sep + "]")) {
                        vResult2.add(ssp);
                    }
                    continue;
                }
                vResult2.add(arg);
                continue;
            }
            vResult2.add(arg);
        }
        return vResult2.toArray(new String[vResult2.size()]);
    }

    private ParameterDescription getDescriptionFor(String arg) {
        for (ParameterDescription p : this.m_descriptions.values()) {
            for (String n : p.getParameter().names()) {
                if (!arg.startsWith(n)) continue;
                return p;
            }
        }
        throw new ParameterException("Couldn't find a description for " + arg);
    }

    private String getSeparatorFor(String arg) {
        ParameterDescription pd = this.getDescriptionFor(arg);
        Parameters p = pd.getObject().getClass().getAnnotation(Parameters.class);
        if (p != null) {
            return p.separators();
        }
        return " ";
    }

    public static List<String> readFile(String fileName) {
        List<String> result = Lists.newArrayList();
        try {
            String line;
            BufferedReader bufRead = new BufferedReader(new FileReader(fileName));
            while ((line = bufRead.readLine()) != null) {
                result.add(line);
            }
            bufRead.close();
        }
        catch (IOException e) {
            throw new ParameterException("Could not read file " + fileName + ": " + e);
        }
        return result;
    }

    private static String trim(String string) {
        String result = string.trim();
        if (result.startsWith("\"")) {
            if (result.endsWith("\"")) {
                return result.substring(1, result.length() - 1);
            }
            return result.substring(1);
        }
        return result;
    }

    private void createDescriptions() {
        this.m_descriptions = Maps.newHashMap();
        for (Object object : this.m_objects) {
            Class<?> cls = object.getClass();
            for (Field f : cls.getDeclaredFields()) {
                this.p("Field:" + f.getName());
                f.setAccessible(true);
                Parameter annotation = f.getAnnotation(Parameter.class);
                if (annotation == null) continue;
                Parameter p = annotation;
                if (p.names().length == 0) {
                    this.p("Found main parameter:" + f);
                    if (this.m_mainParameterField != null) {
                        throw new ParameterException("Only one @Parameter with no names attribute is allowed, found:" + this.m_mainParameterField + " and " + f);
                    }
                    this.m_mainParameterField = f;
                    this.m_mainParameterObject = object;
                    this.m_mainParameterAnnotation = p;
                    continue;
                }
                for (String name : p.names()) {
                    if (this.m_descriptions.containsKey(name)) {
                        throw new ParameterException("Found the option " + name + " multiple times");
                    }
                    this.p("Adding description for " + name);
                    ParameterDescription pd = new ParameterDescription(object, p, f, this.m_bundle);
                    this.m_fields.put(f, pd);
                    this.m_descriptions.put(name, pd);
                    if (!p.required()) continue;
                    this.m_requiredFields.put(f, pd);
                }
            }
        }
    }

    private void parseValues(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String a = JCommander.trim(args[i]);
            this.p("Parsing arg:" + a);
            if (a.startsWith("-")) {
                ParameterDescription pd = this.m_descriptions.get(a);
                if (pd != null) {
                    int n;
                    if (pd.getParameter().password()) {
                        Console console = System.console();
                        if (console == null) {
                            throw new ParameterException("No console is available to get parameter " + a);
                        }
                        System.out.print("Value for " + a + " (" + pd.getDescription() + "):");
                        char[] password = console.readPassword();
                        pd.addValue(new String(password));
                        continue;
                    }
                    Class<?> fieldType = pd.getField().getType();
                    if ((fieldType == Boolean.TYPE || fieldType == Boolean.class) && pd.getParameter().arity() == -1) {
                        pd.addValue("true");
                        this.m_requiredFields.remove(pd.getField());
                        continue;
                    }
                    int arity = pd.getParameter().arity();
                    int n2 = n = arity != -1 ? arity : 1;
                    if (i + n < args.length) {
                        for (int j = 1; j <= n; ++j) {
                            pd.addValue(JCommander.trim(args[i + j]));
                            this.m_requiredFields.remove(pd.getField());
                        }
                        i += n;
                        continue;
                    }
                    throw new ParameterException(n + " parameters expected after " + args[i]);
                }
                throw new ParameterException("Unknown option: " + a);
            }
            if (JCommander.isStringEmpty(args[i])) continue;
            this.getMainParameter(args[i]).add(args[i]);
        }
    }

    private static boolean isStringEmpty(String s) {
        return s == null || "".equals(s);
    }

    private List<String> getMainParameter(String arg) {
        if (this.m_mainParameterField == null) {
            throw new ParameterException("Was passed main parameter '" + arg + "' but no main parameter was defined");
        }
        try {
            List<String> result = (List<String>)this.m_mainParameterField.get(this.m_mainParameterObject);
            if (result == null) {
                result = Lists.newArrayList();
                this.m_mainParameterField.set(this.m_mainParameterObject, result);
            }
            return result;
        }
        catch (IllegalAccessException ex) {
            throw new ParameterException("Couldn't access main parameter: " + ex.getMessage());
        }
    }

    public void usage() {
        StringBuilder sb = new StringBuilder("Usage: <main class> [options]");
        if (this.m_mainParameterAnnotation != null) {
            sb.append(" " + this.m_mainParameterAnnotation.description());
        }
        sb.append("\n  Options:");
        System.out.println(sb.toString());
        int longestName = 0;
        List<ParameterDescription> sorted = Lists.newArrayList();
        for (ParameterDescription pd : this.m_fields.values()) {
            if (pd.getParameter().hidden()) continue;
            sorted.add(pd);
            int length = pd.getNames().length() + 2;
            if (length <= longestName) continue;
            longestName = length;
        }
        Collections.sort(sorted, new Comparator<ParameterDescription>(){

            @Override
            public int compare(ParameterDescription arg0, ParameterDescription arg1) {
                return arg0.getNames().toLowerCase().compareTo(arg1.getNames().toLowerCase());
            }
        });
        for (ParameterDescription pd : sorted) {
            int l = pd.getNames().length();
            int spaceCount = longestName - l;
            StringBuilder tabs = new StringBuilder();
            for (int i = 0; i < spaceCount; ++i) {
                tabs.append(" ");
            }
            System.out.println("    " + pd.getNames() + tabs + pd.getDescription());
        }
    }

    public List<ParameterDescription> getParameters() {
        return new ArrayList<ParameterDescription>(this.m_fields.values());
    }

    private void p(String string) {
        if (System.getProperty(DEBUG_PROPERTY) != null) {
            System.out.println("[JCommander] " + string);
        }
    }
}

