/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ResourceBundle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterDescription {
    private Object m_object;
    private Parameter m_parameterAnnotation;
    private Field m_field;
    private boolean m_assigned = false;
    private java.util.ResourceBundle m_bundle;
    private String m_description;
    private JCommander m_jCommander;
    private Object m_default;
    private String m_longestName = "";

    public ParameterDescription(Object object, Parameter annotation, Field field, java.util.ResourceBundle bundle, JCommander jc) {
        this.init(object, annotation, field, bundle, jc);
    }

    private java.util.ResourceBundle findResourceBundle(Object o) {
        java.util.ResourceBundle result = null;
        Parameters p = o.getClass().getAnnotation(Parameters.class);
        if (p != null && !this.isEmpty(p.resourceBundle())) {
            result = java.util.ResourceBundle.getBundle(p.resourceBundle(), Locale.getDefault());
        } else {
            ResourceBundle a = o.getClass().getAnnotation(ResourceBundle.class);
            if (a != null && !this.isEmpty(a.value())) {
                result = java.util.ResourceBundle.getBundle(a.value(), Locale.getDefault());
            }
        }
        return result;
    }

    private boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }

    private void init(Object object, Parameter annotation, Field field, java.util.ResourceBundle bundle, JCommander jCommander) {
        this.m_object = object;
        this.m_parameterAnnotation = annotation;
        this.m_field = field;
        this.m_bundle = bundle;
        if (this.m_bundle == null) {
            this.m_bundle = this.findResourceBundle(object);
        }
        this.m_jCommander = jCommander;
        this.m_description = annotation.description();
        if (!"".equals(annotation.descriptionKey()) && this.m_bundle != null) {
            this.m_description = this.m_bundle.getString(annotation.descriptionKey());
        }
        for (String name : annotation.names()) {
            if (name.length() <= this.m_longestName.length()) continue;
            this.m_longestName = name;
        }
        try {
            this.m_default = this.m_field.get(this.m_object);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.m_default != null) {
            String[] names = this.m_parameterAnnotation.names();
            String name = names.length > 0 ? names[0] : "";
            this.validateParameter(name, this.m_default.toString());
        }
    }

    public String getLongestName() {
        return this.m_longestName;
    }

    public Object getDefault() {
        return this.m_default;
    }

    public String getDescription() {
        return this.m_description;
    }

    public Object getObject() {
        return this.m_object;
    }

    public String getNames() {
        StringBuilder sb = new StringBuilder();
        String[] names = this.m_parameterAnnotation.names();
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (names.length == 1 && names[i].startsWith("--")) {
                sb.append("    ");
            }
            sb.append(names[i]);
        }
        return sb.toString();
    }

    public Parameter getParameter() {
        return this.m_parameterAnnotation;
    }

    public Field getField() {
        return this.m_field;
    }

    private boolean isMultiOption() {
        Class<?> fieldType = this.m_field.getType();
        return fieldType.equals(List.class) || fieldType.equals(Set.class);
    }

    public void addValue(String value) {
        this.addValue(value, false);
    }

    public boolean isAssigned() {
        return this.m_assigned;
    }

    public void setAssigned(boolean b) {
        this.m_assigned = b;
    }

    public void addValue(String value, boolean isDefault) {
        ParameterDescription.p("Adding " + (isDefault ? "default " : "") + "value:" + value + " to parameter:" + this.m_field.getName());
        String name = this.m_parameterAnnotation.names()[0];
        if (this.m_assigned && !this.isMultiOption()) {
            throw new ParameterException("Can only specify option " + name + " once.");
        }
        this.validateParameter(name, value);
        Class<?> type = this.m_field.getType();
        Object convertedValue = this.m_jCommander.convertValue(this, value);
        boolean isCollection = Collection.class.isAssignableFrom(type);
        try {
            if (isCollection) {
                Collection<Object> l = (Collection<Object>)this.m_field.get(this.m_object);
                if (l == null || this.fieldIsSetForTheFirstTime(isDefault)) {
                    l = this.newCollection(type);
                    this.m_field.set(this.m_object, l);
                }
                if (convertedValue instanceof Collection) {
                    l.addAll((Collection)convertedValue);
                } else {
                    l.add(convertedValue);
                }
            } else {
                this.m_field.set(this.m_object, convertedValue);
            }
            if (!isDefault) {
                this.m_assigned = true;
            }
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
    }

    private void validateParameter(String name, String value) {
        ParameterDescription.validateParameter(this.m_parameterAnnotation, name, value);
    }

    public static void validateParameter(Parameter annotation, String name, String value) {
        Class<? extends IParameterValidator> validator = annotation.validateWith();
        try {
            ParameterDescription.p("Validating parameter:" + name + " value:" + value + " validator:" + validator);
            validator.newInstance().validate(name, value);
        }
        catch (InstantiationException e) {
            throw new ParameterException("Can't instantiate validator:" + e);
        }
        catch (IllegalAccessException e) {
            throw new ParameterException("Can't instantiate validator:" + e);
        }
    }

    private Collection<Object> newCollection(Class<?> type) {
        if (SortedSet.class.isAssignableFrom(type)) {
            return new TreeSet<Object>();
        }
        if (LinkedHashSet.class.isAssignableFrom(type)) {
            return new LinkedHashSet<Object>();
        }
        if (Set.class.isAssignableFrom(type)) {
            return new HashSet<Object>();
        }
        if (List.class.isAssignableFrom(type)) {
            return new ArrayList<Object>();
        }
        throw new ParameterException("Parameters of Collection type '" + type.getSimpleName() + "' are not supported. Please use List or Set instead.");
    }

    private boolean fieldIsSetForTheFirstTime(boolean isDefault) {
        return !isDefault && !this.m_assigned;
    }

    private static void p(String string) {
        if (System.getProperty("jcommander.debug") != null) {
            System.out.println("[ParameterDescription] " + string);
        }
    }

    public String toString() {
        return "[ParameterDescription " + this.m_field.getName() + "]";
    }
}

