/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.ResourceBundle;
import com.beust.jcommander.converters.BooleanConverter;
import com.beust.jcommander.converters.IntegerConverter;
import com.beust.jcommander.converters.LongConverter;
import com.beust.jcommander.converters.NoConverter;
import com.beust.jcommander.converters.StringConverter;
import com.beust.jcommander.internal.Lists;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ParameterDescription {
    private static Map<Class<?>, Class<? extends IStringConverter>> m_classConverters = new HashMap(){
        {
            this.put(String.class, StringConverter.class);
            this.put(Integer.class, IntegerConverter.class);
            this.put(Integer.TYPE, IntegerConverter.class);
            this.put(Long.class, LongConverter.class);
            this.put(Long.TYPE, LongConverter.class);
            this.put(Boolean.class, BooleanConverter.class);
            this.put(Boolean.TYPE, BooleanConverter.class);
        }
    };
    private Object m_object;
    private Parameter m_parameterAnnotation;
    private Field m_field;
    private boolean m_added = false;
    private java.util.ResourceBundle m_bundle;
    private String m_description;

    public ParameterDescription(Object object, Parameter annotation, Field field, java.util.ResourceBundle bundle) {
        this.init(object, annotation, field, bundle);
    }

    private void init(Object object, Parameter annotation, Field field, java.util.ResourceBundle bundle) {
        ResourceBundle a;
        this.m_object = object;
        this.m_parameterAnnotation = annotation;
        this.m_field = field;
        this.m_bundle = bundle;
        if (this.m_bundle == null && (a = object.getClass().getAnnotation(ResourceBundle.class)) != null) {
            this.m_bundle = java.util.ResourceBundle.getBundle(a.value(), Locale.getDefault());
        }
        this.m_description = annotation.description();
        if (!"".equals(annotation.descriptionKey()) && this.m_bundle != null) {
            this.m_description = this.m_bundle.getString(annotation.descriptionKey());
        }
    }

    public String[] getNames() {
        return this.m_parameterAnnotation.names();
    }

    public String getDescription() {
        return this.m_description;
    }

    public Parameter getParameter() {
        return this.m_parameterAnnotation;
    }

    public Field getField() {
        return this.m_field;
    }

    private boolean isMultiOption() {
        Class<?> fieldType = this.m_field.getType();
        return fieldType.equals(List.class) || fieldType.equals(Set.class);
    }

    public void addValue(String value) {
        this.log("Adding value:" + value + " to parameter:" + this.m_field);
        boolean arity = false;
        if (this.m_added && !this.isMultiOption()) {
            throw new ParameterException("Can only specify option " + this.getNames()[0] + " once.");
        }
        Class<? extends IStringConverter> converterClass = this.m_parameterAnnotation.converter();
        if (converterClass == NoConverter.class) {
            converterClass = m_classConverters.get(this.m_field.getType());
        }
        if (converterClass == null && this.m_parameterAnnotation.arity() >= 2) {
            converterClass = StringConverter.class;
            arity = true;
        }
        if (converterClass == null) {
            throw new ParameterException("Don't know how to convert " + value + " to type " + this.m_field.getType() + " (field: " + this.m_field.getName() + ")");
        }
        this.m_added = true;
        try {
            IStringConverter converter = converterClass.newInstance();
            Object convertedValue = converter.convert(value);
            if (arity) {
                List l = (List)this.m_field.get(this.m_object);
                if (l == null) {
                    l = Lists.newArrayList();
                    this.m_field.set(this.m_object, l);
                }
                l.add(convertedValue);
            } else {
                this.m_field.set(this.m_object, convertedValue);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private void log(String string) {
        if (System.getProperty("jcommander.debug") != null) {
            System.out.println("[ParameterDescription] " + string);
        }
    }
}

