/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.web.util;

import com.frameworkset.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlPathHelper {
    public static final String INCLUDE_URI_REQUEST_ATTRIBUTE = "bboss.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH_REQUEST_ATTRIBUTE = "javax.servlet.include.context_path";
    public static final String INCLUDE_SERVLET_PATH_REQUEST_ATTRIBUTE = "javax.servlet.include.servlet_path";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean alwaysUseFullPath = true;
    private boolean urlDecode = false;
    private String defaultEncoding = "ISO-8859-1";
    private static final String requestPathWithinApplicationcachkey = "request.pathWithinApplication.cachkey";

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.alwaysUseFullPath = alwaysUseFullPath;
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlDecode = urlDecode;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    protected String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getLookupPathForRequest(HttpServletRequest request) {
        if (this.alwaysUseFullPath) {
            return this.getPathWithinApplication(request);
        }
        String rest = this.getPathWithinServletMapping(request);
        if (!"".equals(rest)) {
            return rest;
        }
        return this.getPathWithinApplication(request);
    }

    public String getPathWithinServletMapping(HttpServletRequest request) {
        String servletPath;
        String pathWithinApp = this.getPathWithinApplication(request);
        if (pathWithinApp.startsWith(servletPath = this.getServletPath(request))) {
            return pathWithinApp.substring(servletPath.length());
        }
        return servletPath;
    }

    public String getPathWithinApplication(HttpServletRequest request) {
        String ret = (String)request.getAttribute(requestPathWithinApplicationcachkey);
        String servletpath = request.getServletPath();
        if (ret != null && ret.equals(servletpath)) {
            return ret;
        }
        String contextPath = this.getContextPath(request);
        String requestUri = this.getRequestUri(request);
        if (StringUtil.startsWithIgnoreCase((String)requestUri, (String)contextPath)) {
            String path;
            requestUri = path = requestUri.substring(contextPath.length());
        }
        if (requestUri.equals("/") && servletpath != null && !servletpath.equals("")) {
            requestUri = servletpath;
        }
        request.setAttribute(requestPathWithinApplicationcachkey, (Object)requestUri);
        return requestUri;
    }

    public String getRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute(INCLUDE_URI_REQUEST_ATTRIBUTE);
        if (uri != null) {
            return uri;
        }
        uri = request.getRequestURI();
        uri = this.decodeAndCleanUriString(request, uri);
        return uri;
    }

    public String getContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        return contextPath;
    }

    public String getServletPath(HttpServletRequest request) {
        return request.getServletPath();
    }

    public String getOriginatingRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute(INCLUDE_URI_REQUEST_ATTRIBUTE);
        if (uri != null) {
            return uri;
        }
        uri = request.getRequestURI();
        uri = this.decodeAndCleanUriString(request, uri);
        return uri;
    }

    public String getOriginatingContextPath(HttpServletRequest request) {
        return request.getContextPath();
    }

    public String getOriginatingQueryString(HttpServletRequest request) {
        String queryString = (String)request.getAttribute("javax.servlet.forward.query_string");
        if (queryString == null) {
            queryString = request.getQueryString();
        }
        return queryString;
    }

    private String decodeAndCleanUriString(HttpServletRequest request, String uri) {
        int semicolonIndex = (uri = this.decodeRequestString(request, uri)).indexOf(59);
        return semicolonIndex != -1 ? uri.substring(0, semicolonIndex) : uri;
    }

    public String decodeRequestString(HttpServletRequest request, String source) {
        if (this.urlDecode) {
            String enc = this.determineEncoding(request);
            try {
                return URLDecoder.decode(source, enc);
            }
            catch (UnsupportedEncodingException ex) {
                this.logger.warn("Could not decode request string [" + source + "] with encoding '" + enc + "': falling back to platform default encoding; exception message: " + ex.getMessage());
                return URLDecoder.decode(source);
            }
        }
        return source;
    }

    protected String determineEncoding(HttpServletRequest request) {
        String enc = request.getCharacterEncoding();
        if (enc == null) {
            enc = this.getDefaultEncoding();
        }
        return enc;
    }
}

