/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.bean;

import com.frameworkset.common.bean.ValueObject;
import com.frameworkset.util.CompareUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompositeVO
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(AbstractCompositeVO.class);
    private Map binMap = new HashMap();

    protected Map getMap(Class clazz) {
        return this.getMap(clazz, true);
    }

    protected Map getMap(Class clazz, boolean createBin) {
        HashMap voBin = (HashMap)this.binMap.get(clazz);
        if (voBin == null) {
            if (createBin) {
                voBin = new HashMap();
                this.binMap.put(clazz, voBin);
            } else {
                return null;
            }
        }
        return voBin;
    }

    protected Object getId(Iterator iterator) {
        long maxId = 0L;
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            long temp = (Long)obj;
            maxId = Math.max(temp, maxId);
        }
        return new Long(++maxId);
    }

    private Object getKey(DecoratorVO dcVO) throws IllegalArgumentException {
        if (dcVO == null) {
            throw new IllegalArgumentException("DecoratorVO dcVO \u4e3a\u7a7a!");
        }
        if (dcVO.vo == null) {
            throw new IllegalArgumentException("\u503c\u5bf9\u8c61\u4e3a\u7a7a!");
        }
        return ((ValueObject)dcVO.vo).getKey();
    }

    private void sort(List list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                DecoratorVO dcO1 = (DecoratorVO)o1;
                DecoratorVO dcO2 = (DecoratorVO)o2;
                try {
                    CompareUtil cUtil = new CompareUtil();
                    return CompareUtil.compareValue((Object)AbstractCompositeVO.this.getKey(dcO1), (Object)AbstractCompositeVO.this.getKey(dcO2));
                }
                catch (Exception e) {
                    log.info(e.getMessage());
                    return 0;
                }
            }
        });
    }

    protected Iterator getVO(Class clazz, int[] operations) {
        ArrayList list = new ArrayList(this.getMap(clazz).values());
        this.sort(list);
        return new UtilIterator(list.iterator(), operations);
    }

    protected void setVO(ValueObject obj, int operation) {
        this.getMap(obj.getClass()).put(obj.getKey(), new DecoratorVO(obj, operation));
    }

    public ValueObject getSingleVO(Class clazz, long key) {
        Map map = this.getMap(clazz);
        if (map == null) {
            return null;
        }
        DecoratorVO dec = (DecoratorVO)map.get(new Long(key));
        if (dec != null) {
            return (ValueObject)dec.vo;
        }
        return null;
    }

    protected boolean synchroDelete(ValueObject obj, int add) {
        Object key;
        if (obj == null) {
            return false;
        }
        Map newBin = this.getMap(obj.getClass());
        if (newBin.containsKey(key = obj.getKey())) {
            DecoratorVO dec = (DecoratorVO)newBin.get(key);
            if (dec.status == add) {
                newBin.remove(key);
                return true;
            }
        }
        return false;
    }

    protected boolean synchroAdd(ValueObject obj, int delete) {
        Object key;
        if (obj == null) {
            return false;
        }
        Map newBin = this.getMap(obj.getClass());
        if (newBin.containsKey(key = obj.getKey())) {
            DecoratorVO dec = (DecoratorVO)newBin.get(key);
            if (dec.status == delete) {
                dec.status = 3;
                return true;
            }
        }
        return false;
    }

    protected boolean synchroUpdate(ValueObject obj, int add) {
        Object key;
        if (obj == null) {
            return false;
        }
        Map newBin = this.getMap(obj.getClass());
        if (newBin.containsKey(key = obj.getKey())) {
            DecoratorVO dec = (DecoratorVO)newBin.get(key);
            if (dec.status == add) {
                dec.vo = obj;
                return true;
            }
        }
        return false;
    }

    public Iterator getVOByStatus(Class clazz, int[] status) {
        return this.getVO(clazz, status);
    }

    public boolean contain(ValueObject obj) {
        if (obj == null) {
            return false;
        }
        Map newBin = this.getMap(obj.getClass(), false);
        if (newBin == null) {
            return false;
        }
        Object key = obj.getKey();
        return newBin.containsKey(key);
    }

    public boolean contain(ValueObject obj, int status) {
        if (obj == null) {
            return false;
        }
        Map newBin = this.getMap(obj.getClass(), false);
        if (newBin == null) {
            return false;
        }
        Object key = obj.getKey();
        DecoratorVO dec = (DecoratorVO)newBin.get(key);
        return dec != null && dec.status == status;
    }

    public boolean contain(Class clazz, String field, Object fieldValue) {
        return this.contain(clazz, field, fieldValue, null);
    }

    public boolean contain(Class clazz, String field, Object fieldValue, int[] status) {
        Map newBin = this.getMap(clazz, false);
        if (newBin == null) {
            return false;
        }
        MapIterator iterator = new MapIterator(newBin, field, fieldValue, status);
        return iterator.hasNext();
    }

    public boolean contain(Class clazz, String field, Object fieldValue, int status) {
        return this.contain(clazz, field, fieldValue, new int[]{status});
    }

    public Iterator getVoBy(Class clazz, String field, Object fieldValue) {
        return this.getVoBy(clazz, field, fieldValue, null);
    }

    public Iterator getVoBy(Class clazz, String field, Object fieldValue, int[] status) {
        Map newBin = this.getMap(clazz, false);
        if (newBin == null) {
            return null;
        }
        return new MapIterator(newBin, field, fieldValue, status);
    }

    public Iterator getVoBy(Class clazz, String field, Object fieldValue, int status) {
        return this.getVoBy(clazz, field, fieldValue, new int[]{status});
    }

    public ValueObject getSingleVO(Class clazz, Object key, int status) {
        Map map = this.getMap(clazz);
        if (map == null) {
            return null;
        }
        DecoratorVO dec = (DecoratorVO)map.get(key);
        if (dec != null && dec.status == status) {
            return (ValueObject)dec.vo;
        }
        return null;
    }

    private int matchStatus(DecoratorVO decorator, int[] filter) {
        int status = decorator.status;
        for (int i = 0; i < filter.length; ++i) {
            if (status != filter[i]) continue;
            return i;
        }
        return -1;
    }

    public void removeVO(Class clazz) {
        Map bin = this.getMap(clazz);
        if (bin == null) {
            return;
        }
        bin.clear();
    }

    public void removeVO(Class clazz, int[] status) {
        Map bin = this.getMap(clazz);
        if (bin == null) {
            return;
        }
        bin.clear();
    }

    protected void updateStatus(Class clazz, int status) {
        Map bin = this.getMap(clazz);
        if (bin == null) {
            return;
        }
        Iterator keys = bin.keySet().iterator();
        while (keys.hasNext()) {
            DecoratorVO dec = (DecoratorVO)bin.get(keys.next());
            dec.status = status;
        }
    }

    protected class MapIterator
    implements Iterator,
    Serializable {
        Iterator allData;
        DecoratorVO decorator;
        int[] filter;
        String field;
        Object fieldValue;

        public MapIterator(Map bin, String field, Object fieldValue) {
            this(bin, field, fieldValue, null);
        }

        public MapIterator(Map bin, String field, Object fieldValue, int[] filter) {
            ArrayList list = new ArrayList(bin.values());
            AbstractCompositeVO.this.sort(list);
            this.allData = list.iterator();
            this.filter = filter;
            this.field = field;
            this.fieldValue = fieldValue;
            this.decorator = null;
        }

        @Override
        public boolean hasNext() {
            boolean found = false;
            while (this.allData.hasNext() && !found) {
                this.decorator = (DecoratorVO)this.allData.next();
                found = this.found();
            }
            if (!found) {
                this.decorator = null;
            }
            return found;
        }

        private boolean found() {
            if (this.filter == null) {
                return this.fieldMatch();
            }
            return AbstractCompositeVO.this.matchStatus(this.decorator, this.filter) != -1 && this.fieldMatch();
        }

        private boolean fieldMatch() {
            CompareUtil util = new CompareUtil();
            return CompareUtil.compareField((Object)this.decorator.vo, (String)this.field, (Object)this.fieldValue) == 0;
        }

        public Object next() {
            if (this.decorator != null) {
                return this.decorator.vo;
            }
            log.info("no such element!!!");
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove(),\u672a\u652f\u6301\u7684\u64cd\u4f5c");
        }
    }

    protected class UtilIterator
    implements Iterator,
    Serializable {
        Iterator allData;
        DecoratorVO decorator;
        int[] filter;

        public UtilIterator(Iterator allData, int[] filter) {
            this.allData = allData;
            this.filter = filter;
            this.decorator = null;
        }

        @Override
        public boolean hasNext() {
            boolean found = false;
            while (this.allData.hasNext() && !found) {
                this.decorator = (DecoratorVO)this.allData.next();
                if (this.filter == null) {
                    found = true;
                    continue;
                }
                int match = AbstractCompositeVO.this.matchStatus(this.decorator, this.filter);
                found = match != -1;
            }
            if (!found) {
                this.decorator = null;
            }
            return found;
        }

        public Object next() {
            if (this.decorator != null) {
                return this.decorator.vo;
            }
            log.info("no such element!!!");
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove(),\u672a\u652f\u6301\u7684\u64cd\u4f5c");
        }
    }

    protected static class DecoratorVO
    implements Serializable {
        public Object vo;
        public int status;

        public DecoratorVO(Object vo, int status) {
            this.vo = vo;
            this.status = status;
        }

        public boolean equals(Object obj) {
            if (obj != null) {
                return this.vo.equals(obj);
            }
            return false;
        }

        public String toString() {
            return "[status = " + this.status + "][vo = " + this.vo + "]";
        }
    }
}

