/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.commons.dbcp2;

import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.commons.dbcp2.ConnectionFactory;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;

public class DriverConnectionFactory
implements ConnectionFactory {
    private final String connectionString;
    private final Driver driver;
    private final Properties properties;

    public DriverConnectionFactory(Driver driver, String connectString, Properties properties) {
        this.driver = driver;
        this.connectionString = connectString;
        this.properties = properties;
    }

    @Override
    public Connection createConnection() throws SQLException {
        try {
            return this.driver.connect(this.connectionString, this.properties);
        }
        catch (SQLException sqlException) {
            throw new NestedSQLException(this.connectionString, (Throwable)sqlException);
        }
        catch (Exception sqlException) {
            throw new NestedSQLException(this.connectionString, (Throwable)sqlException);
        }
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.getClass().getName() + " [" + String.valueOf(this.driver) + ";" + String.valueOf(this.connectionString) + ";" + String.valueOf(this.properties) + "]";
    }
}

