/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.util;

import com.frameworkset.common.poolman.DBUtil;
import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.NewSQLInfo;
import com.frameworkset.common.poolman.PreparedDBUtil;
import com.frameworkset.common.poolman.Record;
import com.frameworkset.common.poolman.ResultMap;
import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.common.poolman.handle.RowHandler;
import com.frameworkset.common.poolman.interceptor.InterceptorInf;
import com.frameworkset.common.poolman.management.PoolManBootstrap;
import com.frameworkset.common.poolman.monitor.AbandonedTraceExt;
import com.frameworkset.common.poolman.sql.ColumnMetaData;
import com.frameworkset.common.poolman.sql.ForeignKeyMetaData;
import com.frameworkset.common.poolman.sql.PoolManDataSource;
import com.frameworkset.common.poolman.sql.PoolManResultSetMetaData;
import com.frameworkset.common.poolman.sql.PrimaryKeyMetaData;
import com.frameworkset.common.poolman.sql.TableMetaData;
import com.frameworkset.common.poolman.sql.UpdateSQL;
import com.frameworkset.common.poolman.util.DBConf;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.common.poolman.util.JDBCPoolMetaData;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.common.poolman.util.SQLResult;
import com.frameworkset.orm.adapter.DB;
import com.frameworkset.orm.adapter.DBFactory;
import com.frameworkset.orm.engine.model.SchemaType;
import com.frameworkset.orm.transaction.JDBCTransaction;
import com.frameworkset.orm.transaction.TXConnection;
import com.frameworkset.orm.transaction.TransactionException;
import com.frameworkset.orm.transaction.TransactionManager;
import java.io.File;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLUtil {
    private static final Logger log = LoggerFactory.getLogger(SQLUtil.class);
    protected int size = 0;
    protected boolean autocommit = true;
    protected boolean batchautocommit = false;
    public static final int MAX_ATTEMPTS = 3;
    public String propsfilename;
    private Properties props;
    protected PoolManResultSetMetaData meta;
    protected static DB oracleDB;
    private static Object lock;
    private static ThreadLocal threadLocal;

    public static void main(String[] args) {
        System.out.println("\n");
        if (args.length < 2) {
            System.out.println("SYNTAX:\njava com.frameworkset.common.poolman.SQLUtil \"[name of database as specified in poolman.props]\"\"[SQL statement to be executed]\"\n");
            System.exit(0);
        }
        System.out.println("\n");
        System.exit(1);
    }

    public SQLResult execute(String sql) throws SQLException {
        return this.execute(null, sql);
    }

    public SQLResult execute(String dbname, String sql) throws SQLException {
        return this.makeResult(this.executeSql(dbname, sql, null));
    }

    public SQLResult execute(String dbname, String sql, Connection con) throws SQLException {
        return this.makeResult(this.executeSql(dbname, sql, con));
    }

    public HashMap[] executeSql(String sql) throws SQLException {
        return this.executeSql(null, sql, null);
    }

    public HashMap[] executeSql(String sql, Connection con) throws SQLException {
        return this.executeSql(null, sql, con);
    }

    protected SQLResult makeResult(HashMap[] h) throws SQLException {
        return new SQLResult(h);
    }

    public static SQLManager getSQLManager() {
        SQLManager datab = null;
        try {
            datab = SQLManager.getInstance();
        }
        catch (Exception pe) {
            throw new RuntimeException("Couldn't get a reference to the SQLManager: " + pe.toString());
        }
        return datab;
    }

    public static DB getDBAdapter() {
        return SQLUtil.getDBAdapter(null);
    }

    public static DB getDBAdapter(String dbName) {
        return SQLUtil.getSQLManager().getDBAdapter(dbName);
    }

    public static ColumnMetaData getColumnMetaData(String dbName, String tableName, String columnName) {
        return SQLUtil.getPool(dbName).getColumnMetaData(tableName, columnName);
    }

    public static ColumnMetaData getColumnMetaData(String dbName, String tableName, String columnName, Connection con) {
        return SQLUtil.getPool(dbName).getColumnMetaData(con, tableName, columnName);
    }

    public static Set getTableMetaDatas(String dbName) {
        return SQLUtil.getPool(dbName).getTableMetaDatas();
    }

    public static TableMetaData getTableMetaData(String dbName, String tableName) {
        return SQLUtil.getPool(dbName).getTableMetaData(tableName);
    }

    public static Set getColumnMetaDatas(String dbName, String tableName) {
        return SQLUtil.getPool(dbName).getColumnMetaDatas(tableName);
    }

    public static ForeignKeyMetaData getForeignKeyMetaData(String dbName, String tableName, String columnName) {
        return SQLUtil.getPool(dbName).getForeignKeyMetaData(tableName, columnName);
    }

    public static Set getForeignKeyMetaDatas(String dbName, String tableName) {
        return SQLUtil.getPool(dbName).getForeignKeyMetaDatas(tableName);
    }

    public static PrimaryKeyMetaData getPrimaryKeyMetaData(String dbName, String tableName, String columnName) {
        return SQLUtil.getPool(dbName).getPrimaryKeyMetaData(tableName, columnName);
    }

    public static Set getPrimaryKeyMetaDatas(String dbName, String tableName) {
        return SQLUtil.getPool(dbName).getPrimaryKeyMetaDatas(tableName);
    }

    public static ColumnMetaData getColumnMetaData(String tableName, String columnName) {
        return SQLUtil.getPool(null).getColumnMetaData(tableName, columnName);
    }

    public static ColumnMetaData getColumnMetaData(String tableName, String columnName, Connection con) {
        return SQLUtil.getPool(null).getColumnMetaData(con, tableName, columnName);
    }

    public static Set getTableMetaDatas() {
        return SQLUtil.getPool(null).getTableMetaDatas();
    }

    public static TableMetaData getTableMetaData(String tableName) {
        return SQLUtil.getPool(null).getTableMetaData(tableName);
    }

    public static TableMetaData getTableMetaDataFromDataBase(String tableName) {
        return SQLUtil.getPool(null).getTableMetaDataFromDatabase(tableName);
    }

    public static TableMetaData getTableMetaDataFromDataBase(String dbname, String tableName) {
        return SQLUtil.getPool(dbname).getTableMetaDataFromDatabase(tableName);
    }

    public static Set getColumnMetaDatas(String tableName) {
        return SQLUtil.getPool(null).getColumnMetaDatas(tableName);
    }

    public static ForeignKeyMetaData getForeignKeyMetaData(String tableName, String columnName) {
        return SQLUtil.getPool(null).getForeignKeyMetaData(tableName, columnName);
    }

    public static Set getForeignKeyMetaDatas(String tableName) {
        return SQLUtil.getPool(null).getForeignKeyMetaDatas(tableName);
    }

    public static PrimaryKeyMetaData getPrimaryKeyMetaData(String tableName, String columnName) {
        return SQLUtil.getPool(null).getPrimaryKeyMetaData(tableName, columnName);
    }

    public static Set getPrimaryKeyMetaDatas(String tableName) {
        return SQLUtil.getPool(null).getPrimaryKeyMetaDatas(tableName);
    }

    public Enumeration getAllPoolnames() {
        SQLManager datab = SQLUtil.getSQLManager();
        if (datab == null) {
            return null;
        }
        List<String> ps = datab.getAllPoolNames();
        if (ps == null) {
            return null;
        }
        return new PEnumeration<String>(ps.iterator());
    }

    public static List<String> getAllPoolNames() {
        SQLManager datab = SQLUtil.getSQLManager();
        if (datab == null) {
            return null;
        }
        return datab.getAllPoolNames();
    }

    public static JDBCPool getPool(String dbname) {
        SQLManager datab = SQLUtil.getSQLManager();
        return datab.getPool(dbname);
    }

    public static boolean exist(String dbname) {
        SQLManager datab = SQLUtil.getSQLManager();
        return datab.exist(dbname);
    }

    public static JDBCPool getPool() {
        SQLManager datab = SQLUtil.getSQLManager();
        return datab.getPool(null);
    }

    public static void updateTableMetaData(String tableName) {
        SQLUtil.updateTableMetaData(tableName, null);
    }

    public static void updateTableMetaData(String tableName, String dbName) {
        SQLUtil.getPool(dbName).updateTableMetaData(tableName);
    }

    public Record[] executeSql(String dbname, String sql, Connection con) throws SQLException {
        Record[] hashResults = null;
        try {
            hashResults = this.doJDBC(dbname, sql, con);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
        return hashResults;
    }

    protected Record[] doJDBC(String dbname, String sql, Connection con) throws SQLException {
        return this.doJDBC(dbname, sql, false, con);
    }

    protected static JDBCTransaction getTransaction() {
        return TransactionManager.getTransaction();
    }

    public static boolean showsql(String dbname) {
        try {
            return DBUtil.getSQLManager().getPool(dbname).getJDBCPoolMetadata().isShowsql();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected ResultMap innerExecuteJDBC(StatementInfo stmtInfo, Class objectType, RowHandler rowhandler, int result_type) throws SQLException {
        try {
            boolean hasResult;
            ResultMap resultMap = new ResultMap();
            Record[] results = null;
            ResultSet res = null;
            Statement s = null;
            if (stmtInfo != null) {
                stmtInfo.init();
            }
            s = stmtInfo.createStatement();
            if (log.isInfoEnabled() && SQLUtil.showsql(stmtInfo.getDbname())) {
                log.info("Execute JDBC statement:{}", (Object)stmtInfo.getSql());
            }
            if (hasResult = s.execute(stmtInfo.getSql())) {
                res = s.getResultSet();
                stmtInfo.addResultSet(res);
                stmtInfo.cacheResultSetMetaData(res, false);
                this.meta = stmtInfo.getMeta();
                resultMap = stmtInfo.buildResultMap(res, objectType, rowhandler, 10, false, result_type);
                if (resultMap != null) {
                    this.size = resultMap.getSize();
                }
            } else {
                results = stmtInfo.buildCommonResult(s);
                resultMap.setCommonresult(results);
                if (results != null) {
                    resultMap.setSize(1);
                    this.size = resultMap.getSize();
                }
            }
            stmtInfo.commit();
            ResultMap resultMap2 = resultMap;
            return resultMap2;
        }
        catch (SQLException sqle) {
            try {
                log.error(stmtInfo.getSql(), (Throwable)sqle);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stmtInfo != null) {
                stmtInfo.errorHandle(sqle);
            }
            throw sqle;
        }
        catch (Exception e) {
            try {
                log.error(stmtInfo.getSql(), (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stmtInfo != null) {
                stmtInfo.errorHandle(e);
            }
            throw new NestedSQLException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
            }
            stmtInfo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initOracleDB() throws InstantiationException {
        if (oracleDB != null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (oracleDB != null) {
                return;
            }
            oracleDB = DBFactory.create("oracle");
        }
    }

    public static void updateBLOB(Blob blob, File file) throws SQLException {
        try {
            SQLUtil.initOracleDB();
            oracleDB.updateBLOB(blob, file);
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
    }

    public static void updateBLOB(Blob blob, InputStream instream) throws SQLException {
        try {
            SQLUtil.initOracleDB();
            oracleDB.updateBLOB(blob, instream);
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
    }

    public static void updateCLOB(Clob clob, Object content) throws SQLException {
        try {
            SQLUtil.initOracleDB();
            oracleDB.updateCLOB(clob, content);
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
    }

    protected Record[] doJDBC(String dbname_, String sql_, boolean goNative_, Connection con_) throws SQLException {
        StatementInfo stmtInfo = null;
        try {
            stmtInfo = new StatementInfo(dbname_, new NewSQLInfo(sql_), goNative_, con_, !this.isAutoCommit());
            ResultMap resultMap = this.innerExecuteJDBC(stmtInfo, null, null, ResultMap.type_maparray);
            Record[] recordArray = (Record[])resultMap.getCommonresult();
            return recordArray;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
                stmtInfo = null;
            }
        }
    }

    public void setAutoCommit(boolean autocommit) {
        this.autocommit = autocommit;
        this.batchautocommit = autocommit;
    }

    protected boolean isAutoCommit() {
        return this.autocommit;
    }

    protected boolean isBatchAutoCommit() {
        return this.batchautocommit;
    }

    public static Connection getConection() throws SQLException {
        return SQLUtil.getConection(null);
    }

    public static Connection getConection(String dbName) throws SQLException {
        JDBCTransaction tx = SQLUtil.getTransaction();
        if (tx == null) {
            SQLManager datab = SQLUtil.getSQLManager();
            return datab.requestConnection(dbName);
        }
        try {
            return new TXConnection(tx.getConnection(dbName));
        }
        catch (TransactionException e) {
            try {
                tx.setRollbackOnly();
            }
            catch (IllegalStateException e1) {
                e1.printStackTrace();
            }
            catch (SystemException e1) {
                e1.printStackTrace();
            }
            throw new SQLException(e.getMessage());
        }
    }

    public static Connection getConectionFromDatasource(DataSource datasource) throws SQLException {
        JDBCTransaction tx = SQLUtil.getTransaction();
        if (tx == null) {
            return datasource.getConnection();
        }
        try {
            if (datasource instanceof PoolManDataSource) {
                return new TXConnection(tx.getConnection(((PoolManDataSource)datasource).getPoolName()));
            }
            Connection con = tx.getConnectionFromDS(datasource);
            if (con instanceof TXConnection) {
                return con;
            }
            return new TXConnection(con);
        }
        catch (TransactionException e) {
            try {
                tx.setRollbackOnly();
            }
            catch (IllegalStateException e1) {
                e1.printStackTrace();
            }
            catch (SystemException e1) {
                e1.printStackTrace();
            }
            throw new SQLException(e.getMessage());
        }
    }

    public static boolean joinTX() {
        return SQLUtil.getTransaction() != null;
    }

    public ResultSetMetaData getMeta() {
        return this.meta;
    }

    public static String getDBDate(java.util.Date date) {
        return SQLManager.getInstance().getDBAdapter().getDateString(date);
    }

    public static String getDBDate(java.util.Date date, String dbName) {
        return SQLManager.getInstance().getDBAdapter(dbName).getDateString(date);
    }

    public static String getDBDate(String date, String dbName) {
        return SQLManager.getInstance().getDBAdapter(dbName).getDateString(date);
    }

    public static String getDBDate(String date) {
        return SQLManager.getInstance().getDBAdapter().getDateString(date);
    }

    public static String getDBDateWithFormat(java.util.Date date, String format) {
        return SQLManager.getInstance().getDBAdapter().getDateString(date, format);
    }

    public static String getDBDateWithFormat(java.util.Date date, String format, String dbName) {
        return SQLManager.getInstance().getDBAdapter(dbName).getDateString(date, format);
    }

    public static String getDBDateWithFormat(String date, String format, String dbName) {
        return SQLManager.getInstance().getDBAdapter(dbName).getDateString(date, format);
    }

    public static String getDBDateWithFormat(String date, String format) {
        return SQLManager.getInstance().getDBAdapter().getDateString(date, format);
    }

    public static DB.PagineSql getDBPagineSql(String sql, long offset, int maxsize, boolean prepared) {
        return SQLManager.getInstance().getDBAdapter().getDBPagineSql(sql, offset, maxsize, prepared);
    }

    public static boolean isRobotQuery(String dbName) {
        return SQLManager.getInstance().getPool(dbName).isRobotQuery();
    }

    public static DB.PagineSql getDBPagineSqlForOracle(String dbName, String sql, long offset, int maxsize, String rownum, boolean prepared) {
        return SQLManager.getInstance().getDBAdapter(dbName).getOracleDBPagineSql(sql, offset, maxsize, rownum, prepared);
    }

    protected String clobToString(Clob clob) throws SQLException {
        int leg = (int)clob.length();
        if (leg > 0) {
            return clob.getSubString(1L, leg);
        }
        return "";
    }

    protected String blobToString(Blob blob) throws SQLException {
        int length = (int)blob.length();
        if (length > 0) {
            byte[] ret = new byte[(int)blob.length()];
            ret = blob.getBytes(1L, length);
            return new String(ret);
        }
        return "";
    }

    protected byte[] blobToByteArray(Blob blob) throws SQLException {
        int length = (int)blob.length();
        if (length > 0) {
            byte[] ret = new byte[(int)blob.length()];
            ret = blob.getBytes(1L, length);
            return ret;
        }
        return new byte[0];
    }

    public String[] getFields() {
        return this.meta.get_columnLabel_upper();
    }

    public void beginTransaction() throws SQLException {
    }

    public void beginTransaction(int created) throws SQLException {
    }

    public void commitTransaction() throws SQLException {
    }

    public void rollbackTransaction() throws SQLException {
    }

    public static void setValue(PreparedStatement stmt, int index, String table, String column, String value, String dbName, Connection con) throws SQLException {
        ColumnMetaData columnmeta = DBUtil.getColumnMetaData(dbName, table, column, con);
        if (columnmeta.getSchemaType() == SchemaType.BIGINT || columnmeta.getSchemaType() == SchemaType.INTEGER || columnmeta.getSchemaType() == SchemaType.NUMERIC || columnmeta.getSchemaType() == SchemaType.SMALLINT || columnmeta.getSchemaType() == SchemaType.DECIMAL || columnmeta.getSchemaType() == SchemaType.TINYINT) {
            try {
                if (value == null) {
                    stmt.setNull(index, 2);
                }
                stmt.setInt(index, Integer.parseInt(value));
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
        } else if (value == null) {
            stmt.setNull(index, 12);
        } else {
            stmt.setString(index, value);
        }
    }

    public static void execute(Connection con, UpdateSQL sql) throws SQLException {
    }

    public static void setValue(PreparedDBUtil predbUtil, int index, Object value) throws SQLException {
        if (value == null) {
            predbUtil.setNull(index, 0);
        } else if (value instanceof Integer) {
            predbUtil.setInt(index, (Integer)value);
        } else if (value instanceof String) {
            predbUtil.setString(index, value.toString());
        } else if (value instanceof Timestamp) {
            predbUtil.setTimestamp(index, (Timestamp)value);
        } else if (value instanceof Date) {
            predbUtil.setDate(index, (Date)value);
        } else {
            predbUtil.setObject(index, value);
        }
    }

    public static int getNumActive(String dbName) {
        JDBCPool pool = SQLManager.getInstance().getPool(dbName);
        if (pool != null) {
            return pool.getNumActive();
        }
        return -1;
    }

    public static int getNumIdle(String dbName) {
        JDBCPool pool = SQLManager.getInstance().getPool(dbName);
        if (pool != null) {
            return pool.getNumIdle();
        }
        return -1;
    }

    public static long getStartTime(String dbName) {
        JDBCPool pool = SQLManager.getInstance().getPool(dbName);
        if (pool != null) {
            return pool.getStartTime();
        }
        return -1L;
    }

    public static String getStatus(String dbName) {
        JDBCPool pool = SQLManager.getInstance().getPool(dbName);
        if (pool != null) {
            return pool.getStatus();
        }
        return "unloaded";
    }

    public static long getStopTime(String dbName) {
        JDBCPool pool = SQLManager.getInstance().getPool(dbName);
        if (pool != null) {
            return pool.getStopTime();
        }
        return -1L;
    }

    public static int getNumActive() {
        return SQLUtil.getNumActive(null);
    }

    public static int getMaxNumActive() {
        return SQLUtil.getMaxNumActive(null);
    }

    public static List<AbandonedTraceExt> getTraceObjects() {
        return SQLUtil.getTraceObjects(null);
    }

    public static List<AbandonedTraceExt> getTraceObjects(String dbname) {
        return SQLUtil.getGoodTraceObjects(dbname);
    }

    public static List<AbandonedTraceExt> getGoodTraceObjects() {
        return SQLUtil.getGoodTraceObjects(null);
    }

    public static List<AbandonedTraceExt> getGoodTraceObjects(String dbname) {
        JDBCPool pool = SQLManager.getInstance().getPool(dbname);
        if (pool != null) {
            return pool.getGoodTraceObjects();
        }
        return null;
    }

    public static int getMaxNumActive(String dbName) {
        JDBCPool pool = SQLManager.getInstance().getPool(dbName);
        if (pool != null) {
            return pool.getMaxNumActive();
        }
        return -1;
    }

    public static long getMaxActiveNumTime() {
        return SQLUtil.getMaxActiveNumTime(null);
    }

    public static long getMaxActiveNumTime(String dbName) {
        JDBCPool pool = SQLManager.getInstance().getPool(dbName);
        if (pool != null) {
            return pool.getMaxActiveNumTime();
        }
        return -1L;
    }

    public static String getMaxActiveNumFormatTime() {
        return SQLUtil.getMaxActiveNumFormatTime(null);
    }

    public static String getMaxActiveNumFormatTime(String dbName) {
        JDBCPool pool = SQLManager.getInstance().getPool(dbName);
        if (pool != null) {
            long time = pool.getMaxActiveNumTime();
            String datestr = "";
            if (time > 0L) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                datestr = format.format(new java.util.Date(time));
            }
            return datestr;
        }
        return "";
    }

    public static int getNumIdle() {
        return SQLUtil.getNumIdle(null);
    }

    public static JDBCPoolMetaData getJDBCPoolMetaData() {
        return SQLUtil.getJDBCPoolMetaData(null);
    }

    public static void debugMemory() {
        System.out.println("FreeMemory:" + Runtime.getRuntime().freeMemory() / 1024L / 1024L + "M");
        System.out.println("MaxMemory:" + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "M");
        System.out.println("TotalMemory:" + Runtime.getRuntime().totalMemory() / 1024L / 1024L + "M");
    }

    public static void debugStatus() {
        SQLUtil.debugStatus(SQLUtil.getPool().getDBName());
    }

    public static void refreshDatabaseMetaData() {
        List<String> pools = SQLUtil.getAllPoolNames();
        for (int i = 0; pools != null && i < pools.size(); ++i) {
            String name = pools.get(i);
            try {
                SQLUtil.getPool(name).refreshDatabaseMetaData();
                continue;
            }
            catch (Exception e) {
                log.error("\u5237\u65b0\u6570\u636e\u5e93\u8fde\u63a5\u6c60" + name + "\u5bf9\u5e94\u7684db\u5143\u6570\u636e\u5931\u8d25:", (Throwable)e);
            }
        }
    }

    public static void debugStatus(String DBName) {
        if (log.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("[").append(DBName).append("] idle connenctions:").append(SQLUtil.getNumIdle(DBName)).append("--------------------------\r\n").append("[").append(DBName).append("] active connenctions:").append(SQLUtil.getNumActive(DBName)).append("--------------------------\r\n").append("[").append(DBName).append("] max active connenctions:").append(SQLUtil.getMaxNumActive(DBName)).append("--------------------------\r\n").append("[").append(DBName).append("] max active connenctions time:").append(SQLUtil.getMaxActiveNumFormatTime(DBName)).append("--------------------------\r\n");
            log.info(builder.toString());
        }
    }

    public static SchemaType getSchemaType(String dbname, int sqltype, String typename) {
        return SQLUtil.getPool(dbname).getDbAdapter().getSchemaTypeFromSqlType(sqltype, typename);
    }

    public static String getJavaType(String dbname, int sqltype, String typename) {
        return SQLUtil.getSchemaType(dbname, sqltype, typename).getJavaType();
    }

    public static DataSource getDataSource() {
        return SQLUtil.getDataSource(null);
    }

    public static DataSource getDataSource(String dbname) {
        return SQLUtil.getSQLManager().getPool(dbname).getDataSource();
    }

    public static DataSource getDataSourceByJNDI(String jndiname) throws NamingException {
        DataSource datasource = JDBCPool.find(jndiname, null);
        if (datasource == null) {
            SQLUtil.getSQLManager().getPool(null);
            return JDBCPool.find(jndiname, null);
        }
        return datasource;
    }

    public static JDBCPool getJDBCPoolByJNDIName(String jndiname) {
        JDBCPool pool = SQLUtil.getSQLManager().getPoolByJNDIName(jndiname, true);
        return pool;
    }

    public static JDBCPool getJDBCPoolByJNDIName(String jndiname, boolean needcheckStart) {
        JDBCPool pool = SQLUtil.getSQLManager().getPoolByJNDIName(jndiname, needcheckStart);
        return pool;
    }

    public static String getDBNameByJNDIName(String jndiname) throws NamingException {
        try {
            return SQLUtil.getJDBCPoolByJNDIName(jndiname).getDBName();
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static void stopPool(String dbname) throws Exception {
        SQLUtil.getSQLManager().stopPool(dbname);
    }

    public static void startPool(String dbname) throws Exception {
        SQLManager.startPool(dbname);
    }

    public static void startPoolByDBconf(DBConf dbConf) throws Exception {
        SQLManager.startPool(dbConf);
    }

    public static String statusCheck(String dbname) {
        return SQLUtil.getSQLManager().statusCheck(dbname);
    }

    public static void startPool(String poolname, String driver, String jdbcurl, String username, String password, String validationQuery) {
        SQLManager.startPool(poolname, driver, jdbcurl, username, password, validationQuery);
    }

    public static void startPool(String poolname, String driver, String jdbcurl, String username, String password, String validationQuery, int fetchsize) {
        SQLManager.startPool(poolname, driver, jdbcurl, username, password, validationQuery, fetchsize);
    }

    public static void startNoPool(String poolname, String driver, String jdbcurl, String username, String password, String validationQuery, int fetchsize) {
        SQLManager.startNoPool(poolname, driver, jdbcurl, username, password, validationQuery, fetchsize);
    }

    public static void startNoPool(String poolname, String driver, String jdbcurl, String username, String password, String validationQuery) {
        SQLManager.startNoPool(poolname, driver, jdbcurl, username, password, validationQuery);
    }

    public static void startPool(String poolname, String driver, String jdbcurl, String username, String password, String readOnly, String validationQuery) {
        SQLManager.startPool(poolname, driver, jdbcurl, username, password, readOnly, validationQuery);
    }

    public static void startPool(String poolname, String driver, String jdbcurl, String username, String password, String readOnly, String validationQuery, boolean encryptdbinfo) {
        SQLManager.startPool(poolname, driver, jdbcurl, username, password, readOnly, validationQuery, encryptdbinfo);
    }

    public static void startPool(String poolname, String driver, String jdbcurl, String username, String password, String readOnly, String txIsolationLevel, String validationQuery, String jndiName, int initialConnections, int minimumSize, int maximumSize, boolean usepool, boolean external, String externaljndiName, boolean showsql, boolean encryptdbinfo) {
        SQLManager.startPool(poolname, driver, jdbcurl, username, password, readOnly, txIsolationLevel, validationQuery, jndiName, initialConnections, minimumSize, maximumSize, usepool, external, externaljndiName, showsql, encryptdbinfo);
    }

    public static void startPool(String poolname, String driver, String jdbcurl, String username, String password, String readOnly, String txIsolationLevel, String validationQuery, String jndiName, int initialConnections, int minimumSize, int maximumSize, boolean usepool, boolean external, String externaljndiName, boolean showsql, boolean encryptdbinfo, int fetchsize) {
        SQLManager.startPool(poolname, driver, jdbcurl, username, password, readOnly, txIsolationLevel, validationQuery, jndiName, initialConnections, minimumSize, maximumSize, usepool, external, externaljndiName, showsql, encryptdbinfo, fetchsize);
    }

    public static void startPool(String poolname, String driver, String jdbcurl, String username, String password, String readOnly, String txIsolationLevel, String validationQuery, String jndiName, int initialConnections, int minimumSize, int maximumSize, boolean usepool, boolean external, String externaljndiName, boolean showsql, boolean encryptdbinfo, int fetchsize, String dbtype, String dbAdaptor) {
        SQLManager.startPool(poolname, driver, jdbcurl, username, password, readOnly, txIsolationLevel, validationQuery, jndiName, initialConnections, minimumSize, maximumSize, usepool, external, externaljndiName, showsql, encryptdbinfo, fetchsize, dbtype, dbAdaptor);
    }

    public static void startPool(String poolname, String driver, String jdbcurl, String username, String password, String readOnly, String txIsolationLevel, String validationQuery, String jndiName, int initialConnections, int minimumSize, int maximumSize, boolean usepool, boolean external, String externaljndiName, boolean showsql) {
        SQLManager.startPool(poolname, driver, jdbcurl, username, password, readOnly, txIsolationLevel, validationQuery, jndiName, initialConnections, minimumSize, maximumSize, usepool, external, externaljndiName, showsql);
    }

    public static JDBCPoolMetaData getJDBCPoolMetaData(String dbname) {
        return SQLUtil.getSQLManager().getJDBCPoolMetaData(dbname);
    }

    public static InterceptorInf getInterceptorInf(String dbname) {
        return SQLUtil.getSQLManager().getPool(dbname).getInterceptor();
    }

    public static void startPoolFromConf(String configfile) {
        SQLUtil.startPoolFromConf(configfile, null, null);
    }

    public static void startPoolFromConf(String configfile, String dbnamespace) {
        SQLUtil.startPoolFromConf(configfile, dbnamespace, null);
    }

    public static void startPoolFromConf(String configfile, String dbnamespace, String[] dbnames) {
        PoolManBootstrap.startDBSFromConf(configfile, dbnamespace, dbnames);
    }

    public static void startPoolFromConf(String configfile, String[] dbnames) {
        SQLUtil.startPoolFromConf(configfile, null, dbnames);
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBase() {
        return SQLUtil.getPool(null).getTablesFromDatabase();
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBaseByPattern(String tableNamepattern) {
        return SQLUtil.getTableMetaDatasFromDataBaseByPattern(null, tableNamepattern);
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBase(String dbanme) {
        return SQLUtil.getPool(dbanme).getTablesFromDatabase();
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBaseByPattern(String dbanme, String tableNamepattern) {
        return SQLUtil.getPool(dbanme).getTablesFromDatabase(tableNamepattern);
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBase(String[] tableTypes) {
        return SQLUtil.getPool(null).getTablesFromDatabase(tableTypes);
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBaseByPattern(String tableNamepattern, String[] tableTypes) {
        return SQLUtil.getTableMetaDatasFromDataBaseByPattern(null, tableNamepattern, tableTypes);
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBase(String dbanme, String[] tableTypes) {
        return SQLUtil.getPool(dbanme).getTablesFromDatabase(tableTypes);
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBaseByPattern(String dbanme, String tableNamepattern, String[] tableTypes) {
        return SQLUtil.getPool(dbanme).getTablesFromDatabase(tableNamepattern, tableTypes);
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBase(boolean loadColumns) {
        return SQLUtil.getPool(null).getTablesFromDatabase(loadColumns);
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBaseByPattern(String tableNamepattern, boolean loadColumns) {
        return SQLUtil.getTableMetaDatasFromDataBaseByPattern(null, tableNamepattern, loadColumns);
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBase(String dbanme, boolean loadColumns) {
        return SQLUtil.getPool(dbanme).getTablesFromDatabase(loadColumns);
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBaseByPattern(String dbanme, String tableNamepattern, boolean loadColumns) {
        return SQLUtil.getPool(dbanme).getTablesFromDatabase(tableNamepattern, loadColumns);
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBase(String[] tableTypes, boolean loadColumns) {
        return SQLUtil.getPool(null).getTablesFromDatabase(tableTypes, loadColumns);
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBaseByPattern(String tableNamepattern, String[] tableTypes, boolean loadColumns) {
        return SQLUtil.getTableMetaDatasFromDataBaseByPattern(null, tableNamepattern, tableTypes, loadColumns);
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBase(String dbanme, String[] tableTypes, boolean loadColumns) {
        return SQLUtil.getPool(dbanme).getTablesFromDatabase(tableTypes, loadColumns);
    }

    public static List<TableMetaData> getTableMetaDatasFromDataBaseByPattern(String dbname, String tableNamepattern, String[] tableTypes, boolean loadColumns) {
        return SQLUtil.getPool(dbname).getTablesFromDatabase(tableNamepattern, tableTypes, loadColumns);
    }

    public static void increamentMaxTotalConnections(String dbname, int nums) {
        JDBCPool pool = SQLUtil.getPool(dbname);
        if (pool != null) {
            pool.increamentMaxTotalConnections(nums);
        }
    }

    public static void refreshDatabaseMetaData(String dbname) {
        try {
            SQLUtil.getPool(dbname).refreshDatabaseMetaData();
        }
        catch (Exception e) {
            log.error("\u5237\u65b0\u6570\u636e\u5e93\u8fde\u63a5\u6c60" + dbname + "\u5bf9\u5e94\u7684db\u5143\u6570\u636e\u5931\u8d25:", (Throwable)e);
        }
    }

    static {
        lock = new Object();
        threadLocal = new ThreadLocal();
    }

    public static class DBHashtable
    extends HashMap {
        public DBHashtable(int i) {
            super(i);
        }

        public DBHashtable() {
        }

        public DBHashtable(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        public DBHashtable(Map t) {
            super(t);
        }
    }

    public static class PEnumeration<E>
    implements Enumeration<E> {
        private Iterator<E> it;

        public PEnumeration(Iterator<E> it) {
            this.it = it;
        }

        @Override
        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        @Override
        public E nextElement() {
            return this.it.next();
        }
    }
}

