/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.support.validate;

import com.frameworkset.util.SimpleStringUtil;
import org.frameworkset.spi.support.validate.Errors;
import org.frameworkset.spi.support.validate.Validator;
import org.frameworkset.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ValidationUtils {
    private static Logger logger = LoggerFactory.getLogger(ValidationUtils.class);

    public static void invokeValidator(Validator validator, Object obj, Errors errors) {
        Assert.notNull((Object)validator, (String)"Validator must not be null");
        Assert.notNull((Object)errors, (String)"Errors object must not be null");
        if (logger.isDebugEnabled()) {
            logger.debug("Invoking validator [" + validator + "]");
        }
        if (obj != null && !validator.supports(obj.getClass())) {
            throw new IllegalArgumentException("Validator [" + validator.getClass() + "] does not support [" + obj.getClass() + "]");
        }
        validator.validate(obj, errors);
        if (logger.isDebugEnabled()) {
            if (errors.hasErrors()) {
                logger.debug("Validator found " + errors.getErrorCount() + " errors");
            } else {
                logger.debug("Validator found no errors");
            }
        }
    }

    public static void rejectIfEmpty(Errors errors, String field, String errorCode) {
        ValidationUtils.rejectIfEmpty(errors, field, errorCode, null);
    }

    public static void rejectIfEmpty(Errors errors, String field, String errorCode, String defaultMessage) {
        Assert.notNull((Object)errors, (String)"Errors object must not be null");
        Object value = errors.getFieldValue(field);
        if (value == null || !SimpleStringUtil.hasLength((CharSequence)value.toString())) {
            errors.rejectValue(field, errorCode, defaultMessage);
        }
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String field, String errorCode) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, field, errorCode, null, null);
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String field, String errorCode, String defaultMessage) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, field, errorCode, null, defaultMessage);
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String field, String errorCode, Object[] errorArgs) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, field, errorCode, errorArgs, null);
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        Assert.notNull((Object)errors, (String)"Errors object must not be null");
        Object value = errors.getFieldValue(field);
        if (value == null || !SimpleStringUtil.hasText((String)value.toString())) {
            errors.rejectValue(field, errorCode, defaultMessage);
        }
    }
}

