/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.support;

import com.frameworkset.util.DaemonThread;
import com.frameworkset.util.DefaultPropertiesPersister;
import com.frameworkset.util.ResourceInitial;
import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.ResourceLoaderAware;
import org.frameworkset.spi.support.AbstractMessageSource;
import org.frameworkset.spi.support.HotResourceLoader;
import org.frameworkset.spi.support.MessageSourceSupport;
import org.frameworkset.spi.support.ReloadableResourceBundleMessageSource;
import org.frameworkset.util.Assert;
import org.frameworkset.util.PropertiesPersister;
import org.frameworkset.util.io.DefaultResourceLoader;
import org.frameworkset.util.io.Resource;
import org.frameworkset.util.io.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotDeployResourceBundleMessageSource
extends AbstractMessageSource
implements ResourceLoaderAware {
    protected static final Logger log = LoggerFactory.getLogger(HotDeployResourceBundleMessageSource.class);
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String XML_SUFFIX = ".xml";
    private String[] basenames = new String[0];
    private String defaultEncoding;
    private Properties fileEncodings;
    private boolean fallbackToSystemLocale = true;
    private ClassLoader bundleClassLoader;
    private boolean changemonitor = true;
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();
    private ResourceLoader resourceLoader = new HotResourceLoader();
    private final Map cachedFilenames = new HashMap();
    private final Map cachedProperties = new HashMap();
    private final Map cachedMergedProperties = new HashMap();
    private static final PropertiesHolder NOTEXIST_propHolder = new PropertiesHolder();
    private static final PropertiesHolder ERROR_propHolder = new PropertiesHolder();
    private static long refresh_interval = 5000L;
    private static DaemonThread damon = null;
    private static Object lock = new Object();

    public void setBasename(String basename) {
        String[] basenames = basename.split(",");
        this.setBasenames(basenames);
    }

    public void setBasenames(String[] basenames) {
        if (basenames != null) {
            this.basenames = new String[basenames.length];
            for (int i = 0; i < basenames.length; ++i) {
                String basename = basenames[i];
                Assert.hasText((String)basename, (String)"Basename must not be empty");
                this.basenames[i] = basename.trim();
            }
        } else {
            this.basenames = new String[0];
        }
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setFileEncodings(Properties fileEncodings) {
        this.fileEncodings = fileEncodings;
    }

    public void setFallbackToSystemLocale(boolean fallbackToSystemLocale) {
        this.fallbackToSystemLocale = fallbackToSystemLocale;
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister != null ? propertiesPersister : new DefaultPropertiesPersister();
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    @Override
    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        if (refresh_interval <= 0L) {
            PropertiesHolder propHolder = this.getMergedProperties(locale);
            String result = propHolder.getProperty(code);
            if (result != null) {
                return result;
            }
        } else {
            for (int i = 0; i < this.basenames.length; ++i) {
                List filenames = this.calculateAllFilenames(this.basenames[i], locale);
                for (int j = 0; j < filenames.size(); ++j) {
                    String filename = (String)filenames.get(j);
                    PropertiesHolder propHolder = this.getProperties(filename);
                    String result = propHolder.getProperty(code);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    @Override
    protected MessageFormat resolveCode(String code, Locale locale) {
        if (refresh_interval < 0L) {
            PropertiesHolder propHolder = this.getMergedProperties(locale);
            MessageFormat result = propHolder.getMessageFormat(code, locale);
            if (result != null) {
                return result;
            }
        } else {
            for (int i = 0; i < this.basenames.length; ++i) {
                List filenames = this.calculateAllFilenames(this.basenames[i], locale);
                for (int j = 0; j < filenames.size(); ++j) {
                    String filename = (String)filenames.get(j);
                    PropertiesHolder propHolder = this.getProperties(filename);
                    MessageFormat result = propHolder.getMessageFormat(code, locale);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertiesHolder getMergedProperties(Locale locale) {
        PropertiesHolder mergedHolder = (PropertiesHolder)this.cachedMergedProperties.get(locale);
        if (mergedHolder != null) {
            return mergedHolder;
        }
        Map map = this.cachedMergedProperties;
        synchronized (map) {
            mergedHolder = (PropertiesHolder)this.cachedMergedProperties.get(locale);
            if (mergedHolder != null) {
                return mergedHolder;
            }
            Properties mergedProps = new Properties();
            mergedHolder = new PropertiesHolder(mergedProps);
            for (int i = this.basenames.length - 1; i >= 0; --i) {
                List filenames = this.calculateAllFilenames(this.basenames[i], locale);
                for (int j = filenames.size() - 1; j >= 0; --j) {
                    String filename = (String)filenames.get(j);
                    PropertiesHolder propHolder = this.getProperties(filename);
                    if (propHolder.getProperties() == null) continue;
                    mergedProps.putAll((Map<?, ?>)propHolder.getProperties());
                }
            }
            this.cachedMergedProperties.put(locale, mergedHolder);
            return mergedHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List calculateAllFilenames(String basename, Locale locale) {
        List filenames;
        HashMap localeMap = (HashMap)this.cachedFilenames.get(basename);
        if (localeMap != null && (filenames = (List)localeMap.get(locale)) != null) {
            return filenames;
        }
        Map map = this.cachedFilenames;
        synchronized (map) {
            ArrayList<String> filenames2;
            localeMap = (Map)this.cachedFilenames.get(basename);
            if (localeMap != null && (filenames2 = (ArrayList<String>)localeMap.get(locale)) != null) {
                return filenames2;
            }
            filenames2 = new ArrayList<String>(7);
            filenames2.addAll(this.calculateFilenamesForLocale(basename, locale));
            if (this.fallbackToSystemLocale && !locale.equals(Locale.getDefault())) {
                List fallbackFilenames = this.calculateFilenamesForLocale(basename, Locale.getDefault());
                for (String fallbackFilename : fallbackFilenames) {
                    if (filenames2.contains(fallbackFilename)) continue;
                    filenames2.add(fallbackFilename);
                }
            }
            filenames2.add(basename);
            if (localeMap != null) {
                localeMap.put(locale, filenames2);
            } else {
                localeMap = new HashMap();
                localeMap.put(locale, filenames2);
                this.cachedFilenames.put(basename, localeMap);
            }
            return filenames2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertiesHolder getProperties(String filename) {
        PropertiesHolder propHolder = (PropertiesHolder)this.cachedProperties.get(filename);
        if (propHolder != null) {
            return propHolder;
        }
        Map map = this.cachedProperties;
        synchronized (map) {
            propHolder = (PropertiesHolder)this.cachedProperties.get(filename);
            if (propHolder != null) {
                return propHolder;
            }
            propHolder = this.firstLoadProperties(filename);
            if (this.isChangemonitor()) {
                if (propHolder == NOTEXIST_propHolder || propHolder == ERROR_propHolder) {
                    log.info("LoadProperties from " + filename + " ignored:file NOT EXIST.");
                } else {
                    HotDeployResourceBundleMessageSource.checkResource(this, propHolder.getResourceURL(), propHolder.getResource(), propHolder.getBasename(), propHolder.getRelativefile());
                }
            }
            this.cachedProperties.put(filename, propHolder);
            return propHolder;
        }
    }

    protected PropertiesHolder refreshProperties(File filepath, String basename, String relativefile) {
        Resource resource = this.resourceLoader.getResource(relativefile);
        PropertiesHolder propHolder = null;
        try {
            Properties props = this.loadProperties(resource, relativefile);
            propHolder = new PropertiesHolder(props, filepath, basename, relativefile);
        }
        catch (IOException ex) {
            log.warn("Could not parse properties file [" + filepath + "]", (Throwable)ex);
            propHolder = ERROR_propHolder;
        }
        this.cachedProperties.put(basename, propHolder);
        return propHolder;
    }

    protected PropertiesHolder firstLoadProperties(String filename) {
        String name = filename + PROPERTIES_SUFFIX;
        Resource resource = this.resourceLoader.getResource(name);
        boolean reset = false;
        if (!resource.exists()) {
            name = filename + XML_SUFFIX;
            resource = this.resourceLoader.getResource(name);
            reset = true;
        }
        PropertiesHolder propHolder = null;
        if (reset && !resource.exists()) {
            propHolder = NOTEXIST_propHolder;
        } else {
            try {
                Properties props = this.loadProperties(resource, name);
                File f = null;
                try {
                    f = resource.getFile();
                }
                catch (Throwable e) {
                    log.warn("Get properties file from " + resource.getClass().getCanonicalName() + (" failed:" + e.getMessage()));
                }
                propHolder = new PropertiesHolder(props, resource.getURL(), f, filename, name);
            }
            catch (IOException ex) {
                try {
                    log.warn("Could not parse properties file [" + resource.getFile().getCanonicalPath() + "]", (Throwable)ex);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                propHolder = ERROR_propHolder;
            }
        }
        return propHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(Resource resource, String filename) throws IOException {
        InputStream is = resource.getInputStream();
        Properties props = new Properties();
        try {
            if (resource.getFilename().endsWith(XML_SUFFIX)) {
                if (log.isDebugEnabled()) {
                    log.debug("Loading properties [" + resource.getFilename() + "]");
                }
                this.propertiesPersister.loadFromXml(props, is);
            } else {
                String encoding = null;
                if (this.fileEncodings != null) {
                    encoding = this.fileEncodings.getProperty(filename);
                }
                if (encoding == null) {
                    encoding = this.defaultEncoding;
                }
                if (encoding != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Loading properties [" + resource.getFilename() + "] with encoding '" + encoding + "'");
                    }
                    this.propertiesPersister.load(props, (Reader)new InputStreamReader(is, encoding));
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Loading properties [" + resource.getFilename() + "]");
                    }
                    this.propertiesPersister.load(props, is);
                }
            }
            Properties properties = props;
            return properties;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        log.debug("Clearing entire resource bundle cache");
        Map map = this.cachedProperties;
        synchronized (map) {
            this.cachedProperties.clear();
        }
        map = this.cachedMergedProperties;
        synchronized (map) {
            this.cachedMergedProperties.clear();
        }
    }

    public void clearCacheIncludingAncestors() {
        this.clearCache();
        if (this.getParentMessageSource() instanceof ReloadableResourceBundleMessageSource) {
            ((ReloadableResourceBundleMessageSource)this.getParentMessageSource()).clearCacheIncludingAncestors();
        }
    }

    public String toString() {
        return this.getClass().getName() + ": basenames=[" + SimpleStringUtil.arrayToCommaDelimitedString((Object[])this.basenames) + "]";
    }

    protected List calculateFilenamesForLocale(String basename, Locale locale) {
        ArrayList<String> result = new ArrayList<String>(3);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder temp = new StringBuilder(basename);
        if (language.length() > 0) {
            temp.append('_').append(language);
            result.add(0, temp.toString());
        }
        if (country.length() > 0) {
            temp.append('_').append(country);
            result.add(0, temp.toString());
        }
        if (variant.length() > 0) {
            temp.append('_').append(variant);
            result.add(0, temp.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkResource(HotDeployResourceBundleMessageSource messagesource, URL resourceURL, File file, String basename, String filename) {
        refresh_interval = BaseApplicationContext.getResourceFileRefreshInterval();
        if (refresh_interval > 0L) {
            if (damon == null) {
                Object object = lock;
                synchronized (object) {
                    if (damon == null) {
                        damon = new DaemonThread(refresh_interval, "Message files Refresh Worker");
                        damon.start();
                    }
                }
            }
            if (file != null) {
                damon.addFile(file, (ResourceInitial)new ResourceFileRefresh(messagesource, file, basename, filename));
            } else {
                damon.addFile(resourceURL, filename, (ResourceInitial)new ResourceFileRefresh(messagesource, file, basename, filename));
            }
        }
    }

    public static void stopmonitor() {
        try {
            if (damon != null) {
                damon.stopped();
                damon = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ClassLoader getBundleClassLoader() {
        return this.bundleClassLoader;
    }

    public void setBundleClassLoader(ClassLoader bundleClassLoader) {
        this.bundleClassLoader = bundleClassLoader;
    }

    public boolean isChangemonitor() {
        return this.changemonitor;
    }

    public void setChangemonitor(boolean changemonitor) {
        this.changemonitor = changemonitor;
    }

    @Override
    public void destroy() {
        this.cachedFilenames.clear();
        this.cachedMergedProperties.clear();
        this.cachedProperties.clear();
        super.destroy();
    }

    static class ResourceFileRefresh
    implements ResourceInitial {
        private HotDeployResourceBundleMessageSource messagesource;
        private String filename;
        private String basename;
        private File file;

        public ResourceFileRefresh(HotDeployResourceBundleMessageSource messagesource, File file, String basename, String filename) {
            this.messagesource = messagesource;
            this.filename = filename;
            this.basename = basename;
            this.file = file;
        }

        public void reinit() {
            this.messagesource.refreshProperties(this.file, this.basename, this.filename);
        }
    }

    protected static class PropertiesHolder {
        private Properties properties;
        private File resource;
        private URL resourceURL;
        private String basename;
        private String relativefile;
        private final Map cachedMessageFormats = new HashMap();

        public PropertiesHolder(Properties properties, File resource, String basename, String relativefile) {
            this.properties = properties;
            this.resource = resource;
            this.basename = basename;
            this.relativefile = relativefile;
        }

        public PropertiesHolder(Properties properties, URL resourceURL, File resource, String basename, String relativefile) {
            this.properties = properties;
            this.resource = resource;
            this.basename = basename;
            this.relativefile = relativefile;
            this.resourceURL = resourceURL;
        }

        public PropertiesHolder(Properties properties) {
            this.properties = properties;
        }

        public PropertiesHolder() {
        }

        public Properties getProperties() {
            return this.properties;
        }

        public String getProperty(String code) {
            if (this.properties == null) {
                return null;
            }
            return this.properties.getProperty(code);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageFormat getMessageFormat(String code, Locale locale) {
            if (this.properties == null) {
                return null;
            }
            Map map = this.cachedMessageFormats;
            synchronized (map) {
                MessageFormat result;
                HashMap<Locale, MessageFormat> localeMap = (HashMap<Locale, MessageFormat>)this.cachedMessageFormats.get(code);
                if (localeMap != null && (result = (MessageFormat)localeMap.get(locale)) != null) {
                    return result;
                }
                String msg = this.properties.getProperty(code);
                if (msg != null) {
                    if (localeMap == null) {
                        localeMap = new HashMap<Locale, MessageFormat>();
                        this.cachedMessageFormats.put(code, localeMap);
                    }
                    MessageFormat result2 = MessageSourceSupport.createMessageFormat(msg, locale);
                    localeMap.put(locale, result2);
                    return result2;
                }
                return null;
            }
        }

        public File getResource() {
            return this.resource;
        }

        public String getBasename() {
            return this.basename;
        }

        public String getRelativefile() {
            return this.relativefile;
        }

        public URL getResourceURL() {
            return this.resourceURL;
        }

        public void setResourceURL(URL resourceURL) {
            this.resourceURL = resourceURL;
        }
    }
}

