/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.support;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.frameworkset.spi.support.ValueStyler;
import org.frameworkset.util.ClassUtils;
import org.frameworkset.util.ObjectUtils;

public class DefaultValueStyler
implements ValueStyler {
    private static final String EMPTY = "[empty]";
    private static final String NULL = "[null]";
    private static final String COLLECTION = "collection";
    private static final String SET = "set";
    private static final String LIST = "list";
    private static final String MAP = "map";
    private static final String ARRAY = "array";

    @Override
    public String style(Object value) {
        if (value == null) {
            return NULL;
        }
        if (value instanceof String) {
            return "'" + value + "'";
        }
        if (value instanceof Class) {
            return ClassUtils.getShortName((Class)((Class)value));
        }
        if (value instanceof Method) {
            Method method = (Method)value;
            return method.getName() + "@" + ClassUtils.getShortName(method.getDeclaringClass());
        }
        if (value instanceof Map) {
            return this.style((Map)value);
        }
        if (value instanceof Map.Entry) {
            return this.style((Map.Entry)value);
        }
        if (value instanceof Collection) {
            return this.style((Collection)value);
        }
        if (value.getClass().isArray()) {
            return this.styleArray(ObjectUtils.toObjectArray((Object)value));
        }
        return String.valueOf(value);
    }

    private String style(Map value) {
        StringBuilder buffer = new StringBuilder(value.size() * 8 + 16);
        buffer.append("map[");
        Iterator it = value.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            buffer.append(this.style(entry));
            if (!it.hasNext()) continue;
            buffer.append(',').append(' ');
        }
        if (value.isEmpty()) {
            buffer.append(EMPTY);
        }
        buffer.append("]");
        return buffer.toString();
    }

    private String style(Map.Entry value) {
        return this.style(value.getKey()) + " -> " + this.style(value.getValue());
    }

    private String style(Collection value) {
        StringBuilder buffer = new StringBuilder(value.size() * 8 + 16);
        buffer.append(this.getCollectionTypeString(value)).append('[');
        Iterator i = value.iterator();
        while (i.hasNext()) {
            buffer.append(this.style(i.next()));
            if (!i.hasNext()) continue;
            buffer.append(',').append(' ');
        }
        if (value.isEmpty()) {
            buffer.append(EMPTY);
        }
        buffer.append("]");
        return buffer.toString();
    }

    private String getCollectionTypeString(Collection value) {
        if (value instanceof List) {
            return LIST;
        }
        if (value instanceof Set) {
            return SET;
        }
        return COLLECTION;
    }

    private String styleArray(Object[] array) {
        StringBuilder buffer = new StringBuilder(array.length * 8 + 16);
        buffer.append("array<" + ClassUtils.getShortName(array.getClass().getComponentType()) + ">[");
        for (int i = 0; i < array.length - 1; ++i) {
            buffer.append(this.style(array[i]));
            buffer.append(',').append(' ');
        }
        if (array.length > 0) {
            buffer.append(this.style(array[array.length - 1]));
        } else {
            buffer.append(EMPTY);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

