/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.annotations.wraper;

import com.frameworkset.orm.annotation.Column;
import com.frameworkset.util.ColumnEditorInf;
import java.util.Locale;
import org.frameworkset.util.annotations.AnnotationUtils;
import org.frameworkset.util.annotations.DateFormateMeta;

public class ColumnWraper {
    private String dataformat;
    private String name;
    private String type;
    private String charset;
    private String editor;
    private Boolean escape = null;
    private String editorparams;
    private ColumnEditorInf _editor;
    private boolean inited;
    private boolean ignoreCUDbind = false;
    private boolean ignorebind = false;
    private Locale locale;
    private String timezone;
    private String localeString;
    private DateFormateMeta dateFormateMeta;

    public ColumnWraper(Column column) {
        this.dataformat = AnnotationUtils.converDefaultValue(column.dataformat());
        this.editorparams = AnnotationUtils.converDefaultValue(column.editorparams());
        this.name = column.name();
        this.type = AnnotationUtils.converDefaultValue(column.type());
        this.charset = AnnotationUtils.converDefaultValue(column.charset());
        this.editor = AnnotationUtils.converDefaultValue(column.editor());
        this.ignoreCUDbind = column.ignoreCUDbind();
        this.ignorebind = column.ignorebind();
        String _escape = AnnotationUtils.converDefaultValue(column.escape());
        if (_escape != null) {
            if (_escape.equals("true")) {
                this.escape = true;
            } else if (_escape.equals("false")) {
                this.escape = false;
            }
        }
        if (this.dataformat != null && !this.dataformat.trim().equals("")) {
            this.timezone = AnnotationUtils.converDefaultValue(column.timezone());
            this.localeString = AnnotationUtils.converDefaultValue(column.locale());
            this.dateFormateMeta = DateFormateMeta.buildDateFormateMeta(this.dataformat, this.localeString, this.timezone);
            this.locale = this.dateFormateMeta.getLocale();
        }
    }

    public String dataformat() {
        return this.dataformat;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String charset() {
        return this.charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnEditorInf editor() {
        if (this.inited) {
            return this._editor;
        }
        ColumnWraper columnWraper = this;
        synchronized (columnWraper) {
            if (this.inited) {
                return this._editor;
            }
            if (this.editor != null && !this.editor.trim().equals("")) {
                try {
                    Class<?> clazz = Class.forName(this.editor.trim());
                    this._editor = (ColumnEditorInf)clazz.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.inited = true;
        }
        return this._editor;
    }

    public String editorparams() {
        return this.editorparams;
    }

    public boolean ignoreCUDbind() {
        return this.ignoreCUDbind;
    }

    public boolean ignorebind() {
        return this.ignorebind;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public DateFormateMeta getDateFormateMeta() {
        return this.dateFormateMeta;
    }

    public Boolean isEscape() {
        return this.escape;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getLocaleString() {
        return this.localeString;
    }

    public void setLocaleString(String localeString) {
        this.localeString = localeString;
    }
}

