/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common;

public class Optional<T> {
    private final T obj;
    private final boolean abs;
    private static final Optional<?> EMPTY = new Optional();

    public static <T> Optional<T> empty() {
        Optional<?> t = EMPTY;
        return t;
    }

    public static <T> Optional<T> of(T value) {
        return new Optional<T>(value);
    }

    private Optional() {
        this.obj = null;
        this.abs = true;
    }

    private Optional(T obj) {
        this.obj = obj;
        this.abs = false;
    }

    public T get() {
        return this.obj;
    }

    public boolean isPresent() {
        return !this.abs;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Optional)) {
            return false;
        }
        Optional that = (Optional)obj;
        return that == EMPTY || this.abs == that.abs && (this.obj == null && that.obj == null || this.obj != null && that.obj != null && this.obj.equals(that.obj));
    }

    public String toString() {
        return "Optional<" + (this.abs ? "?" : (this.obj == null ? "?" : this.obj.getClass().getSimpleName())) + ">: present=" + !this.abs + ", value=(" + this.obj + ")";
    }
}

