/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt;

import com.bazaarvoice.jolt.JoltCliProcessor;
import com.bazaarvoice.jolt.JoltCliUtilities;
import com.bazaarvoice.jolt.Sortr;
import java.io.File;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;

public class SortCliProcessor
implements JoltCliProcessor {
    private static final boolean SUPPRESS_OUTPUT = false;

    @Override
    public void intializeSubCommand(Subparsers subparsers) {
        Subparser sortParser = subparsers.addParser("sort").description("Jolt CLI Sort Tool. This tool will ingest one JSON input (from a file or standard input) and perform the Jolt sort operation on it. The sort order is standard alphabetical ascending, with a special case for \"~\" prefixed keys to be bumped to the top. The program will return an exit code of 0 if the sort operation is performed successfully or a 1 if an error is encountered.").defaultHelp(true);
        sortParser.addArgument("input").help("File path to the input JSON that the sort operation should be performed on. This file should contain valid JSON. If this argument is not specified then standard input will be used.").type(Arguments.fileType().verifyExists().verifyIsFile().verifyCanRead()).nargs("?").setDefault((Object)null).required(false);
        sortParser.addArgument("-u").help("Turns off pretty print for the output. Output will be raw json with no formatting.").action(Arguments.storeTrue());
    }

    @Override
    public boolean process(Namespace ns) {
        File file = (File)ns.get("input");
        Object jsonObject = JoltCliUtilities.readJsonInput(file, false);
        if (jsonObject == null) {
            return false;
        }
        Sortr sortr = new Sortr();
        Object output = sortr.transform(jsonObject);
        Boolean uglyPrint = ns.getBoolean("u");
        return JoltCliUtilities.printJsonObject(output, uglyPrint, false);
    }
}

