/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt;

import com.bazaarvoice.jolt.JsonUtils;
import com.fasterxml.jackson.core.JsonParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class JoltCliUtilities {
    public static final String DIFFY_COMMAND_IDENTIFIER = "diffy";
    public static final String SORT_COMMAND_IDENTIFIER = "sort";
    public static final String TRANSFORM_COMMAND_IDENTIFIER = "transform";

    public static void printToStandardOut(String output, boolean suppressOutput) {
        if (!suppressOutput) {
            System.out.println(output);
        }
    }

    public static Object createJsonObjectFromFile(File file, boolean suppressOutput) {
        Object jsonObject = null;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            jsonObject = JsonUtils.jsonToObject(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            if (e instanceof JsonParseException) {
                JoltCliUtilities.printToStandardOut("File " + file.getAbsolutePath() + " did not contain properly formatted JSON.", suppressOutput);
            } else {
                JoltCliUtilities.printToStandardOut("Failed to open file: " + file.getAbsolutePath(), suppressOutput);
            }
            System.exit(1);
        }
        return jsonObject;
    }

    public static boolean printJsonObject(Object output, Boolean uglyPrint, boolean suppressOutput) {
        try {
            if (uglyPrint.booleanValue()) {
                JoltCliUtilities.printToStandardOut(JsonUtils.toJsonString(output), suppressOutput);
            } else {
                JoltCliUtilities.printToStandardOut(JsonUtils.toPrettyJsonString(output), suppressOutput);
            }
        }
        catch (Exception e) {
            JoltCliUtilities.printToStandardOut("An error occured while attempting to print the output.", suppressOutput);
            return false;
        }
        return true;
    }

    public static Object readJsonInput(File file, boolean suppressOutput) {
        Object jsonObject;
        if (file == null) {
            try {
                jsonObject = JsonUtils.jsonToMap(System.in);
            }
            catch (Exception e) {
                JoltCliUtilities.printToStandardOut("Failed to process standard input.", suppressOutput);
                return null;
            }
        } else {
            jsonObject = JoltCliUtilities.createJsonObjectFromFile(file, suppressOutput);
        }
        return jsonObject;
    }
}

