/*
 * Decompiled with CFR 0.152.
 */
package com.minlessika.db;

import com.minlessika.db.Database;
import com.minlessika.exceptions.DatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;

public class TkTransaction
implements Take {
    private static Logger logger = LoggerFactory.getLogger(TkTransaction.class);
    protected final Database database;
    private final Take origin;

    public TkTransaction(Take origin, Database database) {
        this.origin = origin;
        this.database = database;
    }

    public Response act(Request req) throws Exception {
        this.database.startTransaction();
        try {
            Response response = this.origin.act(req);
            this.database.commit();
            Response response2 = response;
            return response2;
        }
        catch (DatabaseException e) {
            this.database.rollback();
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        finally {
            this.database.terminateTransaction();
        }
    }
}

