/*
 * Decompiled with CFR 0.152.
 */
package com.minlessika.db;

import com.minlessika.db.ClosedShieldConnection;
import com.minlessika.db.Database;
import com.minlessika.exceptions.DatabaseException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicDatabase
implements Database {
    private static Logger logger = LoggerFactory.getLogger(BasicDatabase.class);
    private static final ThreadLocal<Connection> connection = new ThreadLocal();
    private final DataSource source;

    public BasicDatabase(DataSource source) {
        this.source = source;
    }

    @Override
    public Connection getConnection() {
        try {
            if (this.transactionStarted()) {
                return new ClosedShieldConnection(connection.get());
            }
            return this.source.getConnection();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void commit() {
        if (this.transactionStarted()) {
            try {
                connection.get().commit();
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
        }
    }

    @Override
    public void rollback() {
        if (this.transactionStarted()) {
            try {
                connection.get().rollback();
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
        }
    }

    @Override
    public boolean transactionStarted() {
        return connection.get() != null;
    }

    @Override
    public void startTransaction() {
        if (!this.transactionStarted()) {
            try {
                Connection newConnection = this.source.getConnection();
                newConnection.setAutoCommit(false);
                newConnection.setTransactionIsolation(2);
                connection.set(newConnection);
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
        }
    }

    @Override
    public void terminateTransaction() {
        try {
            if (this.transactionStarted()) {
                Connection conn = connection.get();
                connection.remove();
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void start() {
        logger.info("Database started !");
    }

    @Override
    public Connection getConnection(String username, String password) {
        throw new UnsupportedOperationException("BasicDatabase#getConnection");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.source.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.source.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.source.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.source.getLoginTimeout();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.source.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.source.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.source.isWrapperFor(iface);
    }
}

