/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android.json;

import com.batch.android.json.JSONArray;
import com.batch.android.json.JSONException;
import com.batch.android.json.JSONStringer;
import com.batch.android.json.JSONTokener;
import com.batch.android.json.a;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class JSONObject {
    private static final Double a = -0.0;
    public static final Object NULL = new Object(){

        public boolean equals(Object o2) {
            return o2 == this || o2 == null;
        }

        public String toString() {
            return "null";
        }
    };
    private final LinkedHashMap<String, Object> b;

    public JSONObject() {
        this.b = new LinkedHashMap();
    }

    public JSONObject(Map copyFrom) {
        this();
        Map map = copyFrom;
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            if (string == null) {
                throw new NullPointerException("key == null");
            }
            this.b.put(string, JSONObject.wrap(entry.getValue()));
        }
    }

    public JSONObject(JSONTokener readFrom) throws JSONException {
        Object object = readFrom.nextValue();
        if (!(object instanceof JSONObject)) {
            throw com.batch.android.json.a.a(object, "JSONObject");
        }
        this.b = ((JSONObject)object).b;
    }

    public JSONObject(String json) throws JSONException {
        this(new JSONTokener(json));
    }

    public JSONObject(JSONObject copyFrom, String[] names) throws JSONException {
        this();
        for (String string : names) {
            Object object = copyFrom.opt(string);
            if (object == null) continue;
            this.b.put(string, object);
        }
    }

    public int length() {
        return this.b.size();
    }

    public JSONObject put(String name, boolean value) throws JSONException {
        this.b.put(this.a(name), value);
        return this;
    }

    public JSONObject put(String name, double value) throws JSONException {
        this.b.put(this.a(name), com.batch.android.json.a.a(value));
        return this;
    }

    public JSONObject put(String name, int value) throws JSONException {
        this.b.put(this.a(name), value);
        return this;
    }

    public JSONObject put(String name, long value) throws JSONException {
        this.b.put(this.a(name), value);
        return this;
    }

    public JSONObject put(String name, Object value) throws JSONException {
        if (value == null) {
            this.b.remove(name);
            return this;
        }
        if (value instanceof Number) {
            com.batch.android.json.a.a(((Number)value).doubleValue());
        }
        this.b.put(this.a(name), value);
        return this;
    }

    public JSONObject putOpt(String name, Object value) throws JSONException {
        if (name == null || value == null) {
            return this;
        }
        return this.put(name, value);
    }

    public JSONObject accumulate(String name, Object value) throws JSONException {
        Object object = this.b.get(this.a(name));
        if (object == null) {
            return this.put(name, value);
        }
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            jSONArray.a(value);
        } else {
            JSONArray jSONArray = new JSONArray();
            jSONArray.a(object);
            jSONArray.a(value);
            this.b.put(name, jSONArray);
        }
        return this;
    }

    public JSONObject append(String name, Object value) throws JSONException {
        JSONArray jSONArray;
        Object object = this.b.get(this.a(name));
        if (object instanceof JSONArray) {
            jSONArray = (JSONArray)object;
        } else if (object == null) {
            JSONArray jSONArray2 = new JSONArray();
            this.b.put(name, jSONArray2);
            jSONArray = jSONArray2;
        } else {
            throw new JSONException("Key " + name + " is not a JSONArray");
        }
        jSONArray.a(value);
        return this;
    }

    String a(String string) throws JSONException {
        if (string == null) {
            throw new JSONException("Names must be non-null");
        }
        return string;
    }

    public Object remove(String name) {
        return this.b.remove(name);
    }

    public boolean isNull(String name) {
        Object object = this.b.get(name);
        return object == null || object == NULL;
    }

    public boolean has(String name) {
        return this.b.containsKey(name);
    }

    public Object get(String name) throws JSONException {
        Object object = this.b.get(name);
        if (object == null) {
            throw new JSONException("No value for " + name);
        }
        return object;
    }

    public Object opt(String name) {
        return this.b.get(name);
    }

    public boolean getBoolean(String name) throws JSONException {
        Object object = this.get(name);
        Boolean bl = com.batch.android.json.a.a(object);
        if (bl == null) {
            throw com.batch.android.json.a.a(name, object, "boolean");
        }
        return bl;
    }

    public boolean optBoolean(String name) {
        return this.optBoolean(name, false);
    }

    public boolean optBoolean(String name, boolean fallback) {
        Object object = this.opt(name);
        Boolean bl = com.batch.android.json.a.a(object);
        return bl != null ? bl : fallback;
    }

    public Boolean reallyOptBoolean(String name, Boolean fallback) {
        Object object = this.opt(name);
        Boolean bl = object != NULL ? com.batch.android.json.a.a(object) : null;
        return bl != null ? bl : fallback;
    }

    public double getDouble(String name) throws JSONException {
        Object object = this.get(name);
        Double d2 = com.batch.android.json.a.b(object);
        if (d2 == null) {
            throw com.batch.android.json.a.a(name, object, "double");
        }
        return d2;
    }

    public double optDouble(String name) {
        return this.optDouble(name, Double.NaN);
    }

    public double optDouble(String name, double fallback) {
        Object object = this.opt(name);
        Double d2 = com.batch.android.json.a.b(object);
        return d2 != null ? d2 : fallback;
    }

    public Double reallyOptDouble(String name, Double fallback) {
        Object object = this.opt(name);
        Double d2 = object != NULL ? com.batch.android.json.a.b(object) : null;
        return d2 != null ? d2 : fallback;
    }

    public int getInt(String name) throws JSONException {
        Object object = this.get(name);
        Integer n2 = com.batch.android.json.a.c(object);
        if (n2 == null) {
            throw com.batch.android.json.a.a(name, object, "int");
        }
        return n2;
    }

    public int optInt(String name) {
        return this.optInt(name, 0);
    }

    public int optInt(String name, int fallback) {
        Object object = this.opt(name);
        Integer n2 = com.batch.android.json.a.c(object);
        return n2 != null ? n2 : fallback;
    }

    public long getLong(String name) throws JSONException {
        Object object = this.get(name);
        Long l2 = com.batch.android.json.a.d(object);
        if (l2 == null) {
            throw com.batch.android.json.a.a(name, object, "long");
        }
        return l2;
    }

    public long optLong(String name) {
        return this.optLong(name, 0L);
    }

    public long optLong(String name, long fallback) {
        Object object = this.opt(name);
        Long l2 = com.batch.android.json.a.d(object);
        return l2 != null ? l2 : fallback;
    }

    public String getString(String name) throws JSONException {
        Object object = this.get(name);
        String string = com.batch.android.json.a.e(object);
        if (string == null) {
            throw com.batch.android.json.a.a(name, object, "String");
        }
        return string;
    }

    public String optString(String name) {
        return this.optString(name, "");
    }

    public String optString(String name, String fallback) {
        Object object = this.opt(name);
        String string = com.batch.android.json.a.e(object);
        return string != null ? string : fallback;
    }

    public String reallyOptString(String name, String fallback) {
        Object object = this.opt(name);
        String string = object != NULL ? com.batch.android.json.a.e(object) : null;
        return string != null ? string : fallback;
    }

    public JSONArray getJSONArray(String name) throws JSONException {
        Object object = this.get(name);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw com.batch.android.json.a.a(name, object, "JSONArray");
    }

    public JSONArray optJSONArray(String name) {
        Object object = this.opt(name);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    public JSONObject getJSONObject(String name) throws JSONException {
        Object object = this.get(name);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw com.batch.android.json.a.a(name, object, "JSONObject");
    }

    public JSONObject optJSONObject(String name) {
        Object object = this.opt(name);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public JSONArray toJSONArray(JSONArray names) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        if (names == null) {
            return null;
        }
        int n2 = names.length();
        if (n2 == 0) {
            return null;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = com.batch.android.json.a.e(names.opt(i2));
            jSONArray.put(this.opt(string));
        }
        return jSONArray;
    }

    public Iterator<String> keys() {
        return this.b.keySet().iterator();
    }

    public Set<String> keySet() {
        return this.b.keySet();
    }

    public JSONArray names() {
        return this.b.isEmpty() ? null : new JSONArray(new ArrayList<String>(this.b.keySet()));
    }

    public String toString() {
        try {
            JSONStringer jSONStringer = new JSONStringer();
            this.a(jSONStringer);
            return jSONStringer.toString();
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public String toString(int indentSpaces) throws JSONException {
        JSONStringer jSONStringer = new JSONStringer(indentSpaces);
        this.a(jSONStringer);
        return jSONStringer.toString();
    }

    void a(JSONStringer jSONStringer) throws JSONException {
        jSONStringer.object();
        for (Map.Entry<String, Object> entry : this.b.entrySet()) {
            jSONStringer.key(entry.getKey()).value(entry.getValue());
        }
        jSONStringer.endObject();
    }

    public static String numberToString(Number number) throws JSONException {
        if (number == null) {
            throw new JSONException("Number must be non-null");
        }
        double d2 = number.doubleValue();
        com.batch.android.json.a.a(d2);
        if (number.equals(a)) {
            return "-0";
        }
        long l2 = number.longValue();
        if (d2 == (double)l2) {
            return Long.toString(l2);
        }
        return number.toString();
    }

    public static String quote(String data) {
        if (data == null) {
            return "\"\"";
        }
        try {
            JSONStringer jSONStringer = new JSONStringer();
            jSONStringer.a(JSONStringer.a.f, "");
            jSONStringer.value(data);
            jSONStringer.a(JSONStringer.a.f, JSONStringer.a.f, "");
            return jSONStringer.toString();
        }
        catch (JSONException jSONException) {
            throw new AssertionError();
        }
    }

    public static Object wrap(Object o2) {
        if (o2 == null) {
            return NULL;
        }
        if (o2 instanceof JSONArray || o2 instanceof JSONObject) {
            return o2;
        }
        if (o2.equals(NULL)) {
            return o2;
        }
        try {
            if (o2 instanceof Collection) {
                return new JSONArray((Collection)o2);
            }
            if (o2.getClass().isArray()) {
                return new JSONArray(o2);
            }
            if (o2 instanceof Map) {
                return new JSONObject((Map)o2);
            }
            if (o2 instanceof Boolean || o2 instanceof Byte || o2 instanceof Character || o2 instanceof Double || o2 instanceof Float || o2 instanceof Integer || o2 instanceof Long || o2 instanceof Short || o2 instanceof String) {
                return o2;
            }
            if (o2.getClass().getPackage().getName().startsWith("java.")) {
                return o2.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

