/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.IntentService;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.text.TextUtils;
import com.batch.android.BatchActionActivity;
import com.batch.android.BatchActionService;
import com.batch.android.BatchPushPayload;
import com.batch.android.BatchPushReceiver;
import com.batch.android.PushNotificationType;
import com.batch.android.a.a;
import com.batch.android.c;
import com.batch.android.c.l;
import com.batch.android.c.m;
import com.batch.android.c.n;
import com.batch.android.c.o;
import com.batch.android.c.r;
import com.batch.android.c.u;
import com.batch.android.c.x;
import com.batch.android.c.z;
import com.batch.android.e.d;
import com.batch.android.json.JSONException;
import com.batch.android.k;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

@a
public class BatchPushService
extends IntentService {
    private static final String b = "com.batch.android.push.smallicon";
    private static final String c = "com.batch.android.push.color";
    private static final int d = -100;
    private static final String e = "push_already_shown";
    private static final int f = 20;
    protected static final String a = "batch";

    public BatchPushService() {
        super("BatchPushService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onHandleIntent(Intent intent) {
        block15: {
            try {
                BatchPushPayload batchPushPayload;
                Bundle bundle = intent.getExtras();
                if (bundle == null || bundle.isEmpty() || !n.a(this.getApplicationContext(), intent)) break block15;
                try {
                    batchPushPayload = BatchPushPayload.payloadFromReceiverIntent(intent);
                }
                catch (BatchPushPayload.a | IllegalArgumentException exception) {
                    BatchPushReceiver.completeWakefulIntent(intent);
                    return;
                }
                if (batchPushPayload == null) {
                    return;
                }
                o o2 = batchPushPayload.a();
                if (o2 == null) {
                    return;
                }
                if (com.batch.android.e.d.p().n()) {
                    r.c("Ignoring push cause manual display is activated");
                    return;
                }
                String string = intent.getStringExtra("msg");
                String string2 = intent.getStringExtra("title");
                if (string != null && !o2.b()) {
                    BatchPushService._handleNotificationPush((Context)this, bundle, string2, string, batchPushPayload);
                }
            }
            catch (Exception exception) {
                r.a("Error while handing notification", exception);
            }
            finally {
                BatchPushReceiver.completeWakefulIntent(intent);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void _handleNotificationPush(Context context, Bundle extras, String title, String alert, BatchPushPayload payload) throws JSONException {
        Object object;
        Object object2;
        Integer n2;
        Object object3;
        Object object4;
        o o2 = payload.a();
        if (o2 == null) {
            return;
        }
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (!BatchPushService._isPushValid(context, o2)) {
            return;
        }
        if (BatchPushService.a(context, extras, o2)) {
            return;
        }
        String string = o2.f();
        int n3 = BatchPushService.a(context);
        if (n3 == -100) {
            r.c(false, "Batch.Push : Not showing notifications since notification type is NONE or does not contain ALERT");
            return;
        }
        if (title == null || title.length() == 0) {
            try {
                title = context.getPackageManager().getApplicationLabel(applicationInfo).toString();
            }
            catch (Exception exception) {
                r.a(false, "Batch.Push : Unable to find label of the application. Did you correctly set your application label in the manifest?");
                return;
            }
        }
        int n4 = applicationInfo.icon;
        Integer n5 = BatchPushService.c(context);
        if (n5 != null) {
            n4 = n5;
        } else {
            int n6 = com.batch.android.e.d.p().a();
            if (n6 != 0) {
                n4 = n6;
            }
        }
        if (n4 == 0) {
            r.a(false, "Batch.Push : Unable to find icon of the application. Did you correctly set your application icon in the manifest?");
            return;
        }
        Bitmap bitmap = com.batch.android.e.d.p().j();
        if (o2.j()) {
            try {
                object4 = z.a(o2.k());
                object3 = z.a(context, (String)object4);
                if (object3 == null && (object3 = new k(context, o2.k(), o2.l()).a()) != null) {
                    z.a(context, (String)object4, object3);
                }
                if (object3 != null) {
                    bitmap = BatchPushService.a(context, object3);
                } else {
                    r.a("Unable to download custom big image, fallback on default");
                    r.a(false, "Batch.Push : Unable to download large icon image sent via payload, fallback on default");
                }
            }
            catch (Exception exception) {
                r.a("Error while downloading custom big icon image", exception);
                r.a(false, "Batch.Push : Unable to download large icon image sent via payload, fallback on default");
            }
        }
        object4 = null;
        try {
            if (Build.VERSION.SDK_INT >= 16 && o2.m()) {
                object3 = z.a(o2.n());
                n2 = z.a(context, (String)object3);
                if (n2 == null && (n2 = new k(context, o2.n(), o2.o()).a()) != null) {
                    z.a(context, (String)object3, (Bitmap)n2);
                }
                if (n2 != null) {
                    object4 = n2;
                } else {
                    r.a("Unable to download custom big picture, fallback on default");
                    r.a(false, "Batch.Push : Unable to download large big picture image sent via payload, fallback on default");
                }
            }
        }
        catch (Exception exception) {
            r.a("Error while downloading custom big picture image", exception);
            r.a(false, "Batch.Push : Unable to download big picture image sent via payload, fallback on default");
        }
        int n7 = -1;
        n2 = BatchPushService.d(context);
        n7 = n2 != null ? n2.intValue() : com.batch.android.e.d.p().m();
        Intent intent = null;
        if (o2.c()) {
            try {
                if (o2.d()) {
                    throw new NullPointerException("Received scheme is empty");
                }
                object2 = Uri.parse((String)o2.e());
                intent = new Intent(context, BatchActionActivity.class);
                intent.addFlags(0x10000000);
                intent.putExtra("deeplink", o2.e());
            }
            catch (Exception exception) {
                r.a("Error while parsing custom scheme", exception);
                intent = null;
            }
        }
        if (intent == null) {
            intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            intent.setAction("batch_" + Long.toString(System.currentTimeMillis()));
            object2 = com.batch.android.e.d.p().i();
            if (object2 != null) {
                intent.addFlags(((Integer)object2).intValue());
            }
        }
        BatchPushService._putPushExtraToIntent(extras, o2, intent);
        object2 = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        int n8 = (int)(Math.random() * 2.147483647E9);
        Notification notification = null;
        if (m.a("android.support.v4.app.NotificationCompat")) {
            String string2;
            Object object5;
            Object object6;
            object = new NotificationCompat.Builder(context);
            object.setDefaults(n3);
            object.setWhen(System.currentTimeMillis());
            object.setTicker((CharSequence)alert);
            object.setContentTitle((CharSequence)title);
            object.setContentText((CharSequence)alert);
            object.setSmallIcon(n4);
            object.setContentIntent((PendingIntent)object2);
            object.setOnlyAlertOnce(true);
            object.setAutoCancel(true);
            if (m.a(object, "setShowWhen")) {
                object.setShowWhen(true);
            }
            if (n7 != -1 && m.a(object, "setColor")) {
                object.setColor(n7);
            }
            if (bitmap != null) {
                object.setLargeIcon(bitmap);
            }
            if (object4 != null) {
                object6 = new NotificationCompat.BigPictureStyle((NotificationCompat.Builder)object);
                object6.bigPicture((Bitmap)object4);
                object6.setSummaryText((CharSequence)alert);
            } else {
                object6 = new NotificationCompat.BigTextStyle((NotificationCompat.Builder)object);
                object6.bigText((CharSequence)alert);
            }
            object6 = BatchPushService.a(context, payload, n8);
            if (object6 != null) {
                object5 = object6.iterator();
                while (object5.hasNext()) {
                    string2 = (NotificationCompat.Action)object5.next();
                    object.addAction((NotificationCompat.Action)string2);
                }
            }
            if ((object5 = o2.q()) != null && object5 != o.a.a) {
                object.setPriority(((o.a)((Object)object5)).b());
            }
            if ((string2 = o2.r()) != null) {
                object.setGroup(string2);
                object.setGroupSummary(o2.s());
            }
            notification = object.build();
        } else if (Build.VERSION.SDK_INT >= 11) {
            Object object7;
            List<c> list;
            object = new Notification.Builder(context);
            object.setWhen(System.currentTimeMillis());
            object.setDefaults(n3);
            object.setTicker((CharSequence)alert);
            object.setContentTitle((CharSequence)title);
            object.setContentText((CharSequence)alert);
            object.setSmallIcon(n4);
            object.setContentIntent((PendingIntent)object2);
            object.setOnlyAlertOnce(true);
            object.setAutoCancel(true);
            if (bitmap != null) {
                object.setLargeIcon(bitmap);
            }
            if (n7 != -1 && Build.VERSION.SDK_INT >= 21) {
                object.setColor(n7);
            }
            if ((list = payload.getActions()) != null && list.size() > 0) {
                r.a(false, "Batch.Push : Push contains actions but cannot be displayed in compatibility mode. Please add the v4 support library, and make sure proguard is configured correctly.");
            }
            if (Build.VERSION.SDK_INT >= 20 && (object7 = o2.r()) != null) {
                object.setGroup((String)object7);
                object.setGroupSummary(o2.s());
            }
            if (Build.VERSION.SDK_INT >= 16) {
                if (object4 != null) {
                    object7 = new Notification.BigPictureStyle((Notification.Builder)object);
                    object7.bigPicture((Bitmap)object4);
                    object7.setSummaryText((CharSequence)alert);
                } else {
                    object7 = new Notification.BigTextStyle((Notification.Builder)object);
                    object7.bigText((CharSequence)alert);
                }
                object7 = o2.q();
                if (object7 != null && object7 != o.a.a) {
                    object.setPriority(((o.a)((Object)object7)).a());
                }
                notification = object.build();
            } else {
                notification = object.getNotification();
            }
        } else {
            r.b(false, "Batch.Push : Android support library is not available, fallback on deprecated notifications. More info at : https://batch.com/");
            notification = new Notification(n4, (CharSequence)alert, System.currentTimeMillis());
            try {
                object = notification.getClass().getMethod("setLatestEventInfo", Context.class, CharSequence.class, CharSequence.class, PendingIntent.class);
                ((Method)object).invoke((Object)notification, context, title, alert, object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (m.a("android.support.v4.app.NotificationManagerCompat")) {
            object = NotificationManagerCompat.from((Context)context);
            object.notify(a, n8, notification);
        } else {
            object = (NotificationManager)context.getSystemService("notification");
            object.notify(a, n8, notification);
        }
        BatchPushService._markPushIdAsShown(context, string);
    }

    private static boolean a(Context context, Bundle bundle, o o2) {
        return false;
    }

    public static boolean _isPushValid(Context context, o batchData) {
        String string = batchData.f();
        if (string != null && BatchPushService.a(context, string)) {
            r.b("Already shown notification[" + string + "], aborting");
            return false;
        }
        String string2 = batchData.g();
        if (string2 != null && !BatchPushService.b(context, string2)) {
            r.b("Received notification[" + string + "] for another install id[" + string2 + "], aborting");
            return false;
        }
        return true;
    }

    @TargetApi(value=11)
    private static Bitmap a(Context context, Bitmap bitmap) {
        int n2 = 0;
        int n3 = 0;
        if (Build.VERSION.SDK_INT >= 11) {
            Resources resources = context.getResources();
            n2 = (int)resources.getDimension(17104902);
            n3 = (int)resources.getDimension(0x1050005);
        } else {
            n2 = m.b(24, context);
            n3 = m.b(24, context);
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n3, (int)n2, (boolean)false);
    }

    private static int a(Context context) {
        int n2 = 0;
        String string = x.a(context).a("push.notiftype");
        if (string != null) {
            try {
                EnumSet<PushNotificationType> enumSet = PushNotificationType.fromValue(Integer.parseInt(string));
                if (enumSet.size() == 1 && enumSet.contains((Object)PushNotificationType.NONE) || !enumSet.contains((Object)PushNotificationType.ALERT)) {
                    return -100;
                }
                if (enumSet.contains((Object)PushNotificationType.VIBRATE)) {
                    n2 |= 2;
                }
                if (enumSet.contains((Object)PushNotificationType.SOUND)) {
                    n2 |= 1;
                }
                if (enumSet.contains((Object)PushNotificationType.LIGHTS)) {
                    n2 |= 4;
                }
            }
            catch (Exception exception) {
                r.a("Error while reading notification types. Fallback on ALL", exception);
                n2 = -1;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    private static boolean a(Context context, String string) {
        return BatchPushService.b(context).contains(string);
    }

    public static void _markPushIdAsShown(Context context, String pushId) {
        l<String> l2 = BatchPushService.b(context);
        l2.add(pushId);
        if (!u.a(context).a(e, l2)) {
            r.a("Error while saving already shown push ids");
        }
    }

    private static l<String> b(Context context) {
        l l2 = null;
        try {
            Object object = u.a(context).b(e);
            if (object != null) {
                l2 = (l)object;
            }
        }
        catch (Exception exception) {
            r.a("Error while reading stored ids", exception);
        }
        if (l2 == null) {
            l2 = new l(20);
        }
        return l2;
    }

    private static boolean b(Context context, String string) {
        String string2 = new com.batch.android.l(context).a();
        return string.equals(string2);
    }

    private static Integer c(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo.metaData != null) {
                int n2 = applicationInfo.metaData.getInt(b);
                return n2 != 0 ? Integer.valueOf(n2) : null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (Exception exception) {
            r.a("Error while parsing small icon meta data", exception);
        }
        return null;
    }

    private static Integer d(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo.metaData != null) {
                int n2 = applicationInfo.metaData.getInt(c);
                return n2 != 0 ? Integer.valueOf(n2) : null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (Exception exception) {
            r.a("Error while parsing small icon meta data", exception);
        }
        return null;
    }

    @Nullable
    private static List<NotificationCompat.Action> a(@NonNull Context context, @NonNull BatchPushPayload batchPushPayload, int n2) {
        if (!m.a("android.support.v4.app.NotificationCompat$Action")) {
            r.a(true, "Compat actions are not present");
            return null;
        }
        List<c> list = batchPushPayload.getActions();
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<NotificationCompat.Action> arrayList = new ArrayList<NotificationCompat.Action>();
        Bundle bundle = new Bundle();
        batchPushPayload.writeToBundle(bundle);
        int n3 = 0;
        for (c c2 : list) {
            PendingIntent pendingIntent;
            ++n3;
            Intent intent = new Intent(context, c2.e ? BatchActionActivity.class : BatchActionService.class);
            intent.setAction("com.batch.android.action.exec");
            intent.putExtra("actionID", c2.c);
            intent.putExtra("args", c2.d.toString());
            intent.putExtra("notificationID", n2);
            batchPushPayload.writeToIntentExtras(intent);
            if (c2.e) {
                intent.addFlags(0x10000000);
                pendingIntent = PendingIntent.getActivity((Context)context, (int)(n3 * (int)System.currentTimeMillis()), (Intent)intent, (int)0x40000000);
            } else {
                pendingIntent = PendingIntent.getService((Context)context, (int)(n3 * (int)System.currentTimeMillis()), (Intent)intent, (int)0x40000000);
            }
            arrayList.add(new NotificationCompat.Action.Builder(BatchPushService.c(context, c2.b), (CharSequence)c2.a, pendingIntent).build());
        }
        return arrayList;
    }

    private static int c(@NonNull Context context, @Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0;
        }
        int n2 = com.batch.android.e.a.a().b(string);
        if (n2 == 0) {
            n2 = context.getResources().getIdentifier(string, "drawable", context.getPackageName());
        }
        return n2;
    }

    public static void _putPushExtraToIntent(Bundle fullPayload, o batchData, Intent launchIntent) {
        launchIntent.putExtra("fromPush", true);
        if (fullPayload != null && !fullPayload.isEmpty()) {
            launchIntent.putExtra("batchPushPayload", fullPayload);
        }
        if (batchData.f() != null) {
            launchIntent.putExtra("pushId", batchData.f());
        }
    }
}

