/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android.json;

import androidx.annotation.Keep;
import com.batch.android.json.JSONException;

@Keep
class JSON {
    JSON() {
    }

    static double checkDouble(double d2) throws JSONException {
        double d3;
        if (!Double.isInfinite(d2) && !Double.isNaN(d3)) {
            return d3;
        }
        throw new JSONException("Forbidden numeric value: " + d3);
    }

    static Boolean toBoolean(Object value) {
        Object object;
        if (value instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            if ("true".equalsIgnoreCase((String)(object = (String)object))) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase((String)object)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    static Double toDouble(Object value) {
        Object object;
        if (value instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            try {
                return Double.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    static Integer toInteger(Object value) {
        Object object;
        if (value instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            int n2;
            try {
                n2 = (int)Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
            return n2;
        }
        return null;
    }

    static Long toLong(Object value) {
        Object object;
        if (value instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            long l2;
            try {
                l2 = (long)Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
            return l2;
        }
        return null;
    }

    static String toString(Object value) {
        Object object;
        if (value instanceof String) {
            return (String)object;
        }
        if (object != null) {
            return String.valueOf(object);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static JSONException typeMismatch(Object indexOrName, Object actual, String requiredType) throws JSONException {
        void var2_2;
        void var1_1;
        Object object;
        if (actual == null) {
            throw new JSONException("Value at " + object + " is null.");
        }
        throw new JSONException("Value " + var1_1 + " at " + object + " of type " + var1_1.getClass().getName() + " cannot be converted to " + (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static JSONException typeMismatch(Object actual, String requiredType) throws JSONException {
        void var1_1;
        Object object;
        if (actual == null) {
            throw new JSONException("Value is null.");
        }
        throw new JSONException("Value " + object + " of type " + object.getClass().getName() + " cannot be converted to " + (String)var1_1);
    }
}

