/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.batch.android.BatchPushPayload;
import com.batch.android.d.a;
import com.batch.android.f.r;
import com.batch.android.m.w;
import com.batch.android.n0.i;

@a
public final class BatchNotificationChannelsManager {
    public static final String DEFAULT_CHANNEL_ID = "_BATCHSDK_DEFAULT";
    @Nullable
    private String a = null;
    @Nullable
    private ChannelNameProvider b = null;
    @Nullable
    private NotificationChannelIdInterceptor c = null;
    private i d;

    private BatchNotificationChannelsManager(i i2) {
        this.d = i2;
    }

    public static BatchNotificationChannelsManager provide() {
        return new BatchNotificationChannelsManager(w.a());
    }

    private boolean b() {
        return this.a == null;
    }

    public static boolean openSystemChannelSettings(@NonNull Context context) {
        return BatchNotificationChannelsManager.openSystemChannelSettings(context, DEFAULT_CHANNEL_ID);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean openSystemChannelSettings(@NonNull Context context, @NonNull String channelId) {
        if (context != null) {
            void var1_1;
            if (var1_1 != null) {
                if (Build.VERSION.SDK_INT >= 26) {
                    Context context2;
                    Object object;
                    try {
                        context2 = object;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                    Context context3 = object;
                    Intent intent = new Intent("android.settings.CHANNEL_NOTIFICATION_SETTINGS");
                    intent.putExtra("android.provider.extra.CHANNEL_ID", (String)var1_1);
                    object = "android.provider.extra.APP_PACKAGE";
                    intent.putExtra((String)object, context3.getPackageName());
                    context2.startActivity(intent);
                    return true;
                }
                return false;
            }
            throw new IllegalArgumentException("ChannelId is mandatory");
        }
        throw new IllegalArgumentException("Context is mandatory");
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    String a(@Nullable BatchPushPayload payload) {
        void var1_2;
        Object object = DEFAULT_CHANNEL_ID;
        String string = ((BatchNotificationChannelsManager)this_).a;
        if (string != null) {
            object = string;
        }
        if (var1_2 != null && (this_ = ((BatchNotificationChannelsManager)this_).c) != null) {
            try {
                Object this_ = this_.getChannelId((BatchPushPayload)var1_2, (String)object);
                if (this_ != null) {
                    object = this_;
                }
            }
            catch (Exception exception) {
                r.a("Push", "An exception occurred while calling the specified channel id interceptor. Falling back on '" + (String)object + "'", exception);
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    void a(Context c2, boolean forceIfOverridden) {
        if (!forceIfOverridden && !batchNotificationChannelsManager.b()) {
            r.c("Push", "Channel ID overriden, not registering Batch's channel.");
            return;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            void var1_1;
            NotificationChannel notificationChannel;
            r.c("Push", "Registering default Batch notification channel");
            NotificationChannel notificationChannel2 = notificationChannel;
            new NotificationChannel(DEFAULT_CHANNEL_ID, (CharSequence)batchNotificationChannelsManager.a(), 3).setShowBadge(true);
            notificationChannel2.enableLights(true);
            notificationChannel2.enableVibration(true);
            BatchNotificationChannelsManager batchNotificationChannelsManager = batchNotificationChannelsManager.d.s();
            if (batchNotificationChannelsManager != null) {
                notificationChannel2.setSound((Uri)batchNotificationChannelsManager, new AudioAttributes.Builder().setUsage(5).build());
            }
            ((NotificationManager)var1_1.getSystemService(NotificationManager.class)).createNotificationChannel(notificationChannel2);
        }
    }

    String a() {
        BatchNotificationChannelsManager batchNotificationChannelsManager = this_;
        Object this_ = null;
        ChannelNameProvider channelNameProvider = batchNotificationChannelsManager.b;
        if (channelNameProvider != null) {
            try {
                this_ = channelNameProvider.getDefaultChannelName();
            }
            catch (Exception exception) {
                r.a("Push", "An exception occurred while calling the specified channel id interceptor. Falling back on the default name.", exception);
            }
        }
        if (TextUtils.isEmpty((CharSequence)this_)) {
            this_ = "Notifications";
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    public void setChannelIdOverride(@Nullable String channelId) {
        void var1_1;
        this.a = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setChannelNameProvider(@Nullable ChannelNameProvider provider) {
        void var1_1;
        this.b = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setChannelName(@NonNull Context context, @StringRes int channelNameResourceId) {
        void var2_2;
        void var1_1;
        StringResChannelNameProvider stringResChannelNameProvider;
        BatchNotificationChannelsManager batchNotificationChannelsManager = this_;
        StringResChannelNameProvider this_ = stringResChannelNameProvider;
        stringResChannelNameProvider = new StringResChannelNameProvider((Context)var1_1, (int)var2_2);
        batchNotificationChannelsManager.setChannelNameProvider(this_);
    }

    /*
     * WARNING - void declaration
     */
    public void setChannelIdInterceptor(@Nullable NotificationChannelIdInterceptor interceptor) {
        void var1_1;
        this.c = var1_1;
    }

    @a
    public static interface NotificationChannelIdInterceptor {
        @Nullable
        public String getChannelId(@NonNull BatchPushPayload var1, String var2);
    }

    @a
    public static final class StringResChannelNameProvider
    implements ChannelNameProvider {
        private Context a;
        private int b;

        /*
         * WARNING - void declaration
         */
        public StringResChannelNameProvider(@NonNull Context context, @StringRes int channelNameResourceId) {
            void var2_2;
            void var1_1;
            this.a = var1_1.getApplicationContext();
            this.b = var2_2;
        }

        @Override
        @NonNull
        public String getDefaultChannelName() {
            return this.a.getResources().getString(this.b);
        }
    }

    @a
    public static interface ChannelNameProvider {
        @NonNull
        public String getDefaultChannelName();
    }
}

