package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.di.DI;
import com.batch.android.metrics.MetricManager;

/**
 * isSingleton = true
 */
public final class MetricManagerProvider {
  @NonNull
  public static final MetricManager get() {
    MetricManager instance = DI.getInstance().getSingletonInstance(MetricManager.class);
    if (instance != null) {
      return instance;
    }
    instance = MetricManager.provide();
    DI.getInstance().addSingletonInstance(MetricManager.class, instance);
    return instance;
  }

  @Nullable
  public static final MetricManager getSingleton() {
    return DI.getInstance().getSingletonInstance(MetricManager.class);
  }
}
