package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.core.SecureDateProvider;
import com.batch.android.di.DI;

/**
 * isSingleton = true
 */
public final class SecureDateProviderProvider {
  @NonNull
  public static final SecureDateProvider get() {
    SecureDateProvider instance = DI.getInstance().getSingletonInstance(SecureDateProvider.class);
    if (instance != null) {
      return instance;
    }
    instance = new SecureDateProvider();
    DI.getInstance().addSingletonInstance(SecureDateProvider.class, instance);
    return instance;
  }

  @Nullable
  public static final SecureDateProvider getSingleton() {
    return DI.getInstance().getSingletonInstance(SecureDateProvider.class);
  }
}
