package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.di.DI;
import com.batch.android.module.OptOutModule;

/**
 * isSingleton = true
 */
public final class OptOutModuleProvider {
  @NonNull
  public static final OptOutModule get() {
    OptOutModule instance = DI.getInstance().getSingletonInstance(OptOutModule.class);
    if (instance != null) {
      return instance;
    }
    instance = new OptOutModule();
    DI.getInstance().addSingletonInstance(OptOutModule.class, instance);
    return instance;
  }

  @Nullable
  public static final OptOutModule getSingleton() {
    return DI.getInstance().getSingletonInstance(OptOutModule.class);
  }
}
