package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.di.DI;
import com.batch.android.module.LocalCampaignsModule;

/**
 * isSingleton = true
 */
public final class LocalCampaignsModuleProvider {
  @NonNull
  public static final LocalCampaignsModule get() {
    LocalCampaignsModule instance = DI.getInstance().getSingletonInstance(LocalCampaignsModule.class);
    if (instance != null) {
      return instance;
    }
    instance = LocalCampaignsModule.provide();
    DI.getInstance().addSingletonInstance(LocalCampaignsModule.class, instance);
    return instance;
  }

  @Nullable
  public static final LocalCampaignsModule getSingleton() {
    return DI.getInstance().getSingletonInstance(LocalCampaignsModule.class);
  }
}
