package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.di.DI;
import com.batch.android.module.EventDispatcherModule;

/**
 * isSingleton = true
 */
public final class EventDispatcherModuleProvider {
  @NonNull
  public static final EventDispatcherModule get() {
    EventDispatcherModule instance = DI.getInstance().getSingletonInstance(EventDispatcherModule.class);
    if (instance != null) {
      return instance;
    }
    instance = EventDispatcherModule.provide();
    DI.getInstance().addSingletonInstance(EventDispatcherModule.class, instance);
    return instance;
  }

  @Nullable
  public static final EventDispatcherModule getSingleton() {
    return DI.getInstance().getSingletonInstance(EventDispatcherModule.class);
  }
}
