package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.di.DI;
import com.batch.android.module.ActionModule;

/**
 * isSingleton = true
 */
public final class ActionModuleProvider {
  @NonNull
  public static final ActionModule get() {
    ActionModule instance = DI.getInstance().getSingletonInstance(ActionModule.class);
    if (instance != null) {
      return instance;
    }
    instance = new ActionModule();
    DI.getInstance().addSingletonInstance(ActionModule.class, instance);
    return instance;
  }

  @Nullable
  public static final ActionModule getSingleton() {
    return DI.getInstance().getSingletonInstance(ActionModule.class);
  }
}
