package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.di.DI;
import com.batch.android.runtime.RuntimeManager;

/**
 * isSingleton = true
 */
public final class RuntimeManagerProvider {
  @NonNull
  public static final RuntimeManager get() {
    RuntimeManager instance = DI.getInstance().getSingletonInstance(RuntimeManager.class);
    if (instance != null) {
      return instance;
    }
    instance = new RuntimeManager();
    DI.getInstance().addSingletonInstance(RuntimeManager.class, instance);
    return instance;
  }

  @Nullable
  public static final RuntimeManager getSingleton() {
    return DI.getInstance().getSingletonInstance(RuntimeManager.class);
  }
}
