package com.batch.android.di.providers;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.core.Parameters;
import com.batch.android.di.DI;

/**
 * isSingleton = true
 */
public final class ParametersProvider {
  @NonNull
  public static final Parameters get(Context context) {
    Parameters instance = DI.getInstance().getSingletonInstance(Parameters.class);
    if (instance != null) {
      return instance;
    }
    instance = new Parameters(context);
    DI.getInstance().addSingletonInstance(Parameters.class, instance);
    return instance;
  }

  @Nullable
  public static final Parameters getSingleton() {
    return DI.getInstance().getSingletonInstance(Parameters.class);
  }
}
